/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.streams;

import java.util.List;
import java.util.stream.Collectors;
import org.ballerinalang.bre.bvm.BVMExecutor;
import org.ballerinalang.model.values.BClosure;
import org.ballerinalang.model.values.BFunctionPointer;
import org.ballerinalang.model.values.BStream;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.streams.StreamSubscription;
import org.ballerinalang.streams.StreamSubscriptionManager;

public class DefaultStreamSubscription
extends StreamSubscription {
    private BStream stream;
    private BFunctionPointer functionPointer;

    DefaultStreamSubscription(BStream stream2, BFunctionPointer functionPointer, StreamSubscriptionManager streamSubscriptionManager) {
        super(streamSubscriptionManager);
        this.stream = stream2;
        this.functionPointer = functionPointer;
    }

    @Override
    public void execute(BValue value2) {
        List<BValue> argsList = this.functionPointer.getClosureVars().stream().map(BClosure::value).collect(Collectors.toList());
        argsList.add(value2);
        BVMExecutor.executeFunction(this.functionPointer.value().getPackageInfo().getProgramFile(), this.functionPointer.value(), argsList.toArray(new BValue[0]));
    }

    @Override
    public BStream getStream() {
        return this.stream;
    }
}

