/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.streams;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.ballerinalang.model.values.BFunctionPointer;
import org.ballerinalang.model.values.BStream;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.streams.DefaultStreamSubscription;
import org.ballerinalang.streams.StreamSubscription;
import org.ballerinalang.util.exceptions.BallerinaException;

public class StreamSubscriptionManager
implements Observer {
    private Map<String, List<StreamSubscription>> processors = new HashMap<String, List<StreamSubscription>>();
    private static StreamSubscriptionManager streamSubscriptionManager = new StreamSubscriptionManager();

    private StreamSubscriptionManager() {
    }

    public static StreamSubscriptionManager getInstance() {
        return streamSubscriptionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMessageProcessor(BStream stream2, BFunctionPointer functionPointer) {
        StreamSubscriptionManager streamSubscriptionManager = this;
        synchronized (streamSubscriptionManager) {
            this.processors.computeIfAbsent(stream2.topicName, key -> new ArrayList()).add(new DefaultStreamSubscription(stream2, functionPointer, this));
        }
    }

    public void sendMessage(BStream stream2, BValue value2) {
        List<StreamSubscription> msgProcessors = this.processors.get(stream2.topicName);
        if (msgProcessors != null) {
            msgProcessors.forEach(processor -> processor.send(value2));
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (!(o instanceof StreamSubscription)) {
            throw new BallerinaException("Invalid subscription. Expected a subscription to a stream");
        }
        StreamSubscription msgProcessor = (StreamSubscription)o;
        BStream stream2 = msgProcessor.getStream();
        if (!(arg instanceof BValue)) {
            throw new BallerinaException("Data received to stream: " + stream2.getStreamId() + "is not supported");
        }
        msgProcessor.execute((BValue)arg);
    }
}

