/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.codegen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringJoiner;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.util.codegen.FunctionInfo;
import org.ballerinalang.util.codegen.Mnemonics;
import org.ballerinalang.util.codegen.WorkerDataChannelInfo;
import org.ballerinalang.util.codegen.cpentries.ForkJoinCPEntry;
import org.ballerinalang.util.codegen.cpentries.FunctionRefCPEntry;

public class Instruction {
    int opcode;
    int[] operands;

    Instruction(int opcode, int ... operands) {
        this.opcode = opcode;
        this.operands = operands;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public int[] getOperands() {
        return this.operands;
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(" ");
        Arrays.stream(this.operands).forEach(i -> sj.add(String.valueOf(i)));
        return Mnemonics.getMnem(this.opcode) + " " + sj.toString();
    }

    public static class InstructionTrRetry
    extends Instruction {
        public final int blockId;
        public final int abortEndIp;
        public final int trStatusReg;

        InstructionTrRetry(int opcode, int blockId, int abortEndIp, int trStatusReg) {
            super(opcode, new int[0]);
            this.blockId = blockId;
            this.abortEndIp = abortEndIp;
            this.trStatusReg = trStatusReg;
        }

        @Override
        public String toString() {
            StringJoiner sj = new StringJoiner(" ");
            sj.add(String.valueOf(this.blockId));
            sj.add(String.valueOf(this.abortEndIp));
            sj.add(String.valueOf(this.trStatusReg));
            return Mnemonics.getMnem(this.opcode) + " " + sj.toString();
        }
    }

    public static class InstructionTrEnd
    extends Instruction {
        public final int endType;
        public final int blockId;
        public final int statusRegIndex;
        public final int errorRegIndex;

        InstructionTrEnd(int opcode, int blockId, int endType, int statusRegIndex, int errorRegIndex) {
            super(opcode, new int[0]);
            this.blockId = blockId;
            this.endType = endType;
            this.statusRegIndex = statusRegIndex;
            this.errorRegIndex = errorRegIndex;
        }

        @Override
        public String toString() {
            StringJoiner sj = new StringJoiner(" ");
            sj.add(String.valueOf(this.endType));
            sj.add(String.valueOf(this.blockId));
            sj.add(String.valueOf(this.statusRegIndex));
            sj.add(String.valueOf(this.errorRegIndex));
            return Mnemonics.getMnem(this.opcode) + " " + sj.toString();
        }
    }

    public static class InstructionTrBegin
    extends Instruction {
        public final int transactionType;
        public final int blockId;
        public final int retryCountReg;
        public final int committedFuncIndex;
        public final int abortedFuncIndex;

        InstructionTrBegin(int opcode, int transactionType, int blockId, int retryCountReg, int committedFuncIndex, int abortedFuncIndex) {
            super(opcode, new int[0]);
            this.transactionType = transactionType;
            this.blockId = blockId;
            this.retryCountReg = retryCountReg;
            this.committedFuncIndex = committedFuncIndex;
            this.abortedFuncIndex = abortedFuncIndex;
        }

        @Override
        public String toString() {
            StringJoiner sj = new StringJoiner(" ");
            sj.add(String.valueOf(this.transactionType));
            sj.add(String.valueOf(this.blockId));
            sj.add(String.valueOf(this.retryCountReg));
            sj.add(String.valueOf(this.committedFuncIndex));
            sj.add(String.valueOf(this.abortedFuncIndex));
            return Mnemonics.getMnem(this.opcode) + " " + sj.toString();
        }
    }

    public static class InstructionScopeEnd
    extends Instruction {
        public FunctionInfo function;
        public ArrayList<String> childScopes;
        public String scopeName;
        public FunctionRefCPEntry functionCP;

        InstructionScopeEnd(int opcode, FunctionInfo function, ArrayList<String> childScopes, String scopeName, FunctionRefCPEntry funcCP) {
            super(opcode, new int[0]);
            this.function = function;
            this.childScopes = childScopes;
            this.scopeName = scopeName;
        }

        @Override
        public String toString() {
            StringJoiner sj = new StringJoiner(" ");
            sj.add(String.valueOf(this.scopeName));
            for (String child : this.childScopes) {
                sj.add(child);
            }
            return Mnemonics.getMnem(this.opcode) + " " + sj.toString();
        }
    }

    public static class InstructionFlush
    extends Instruction {
        public int retReg;
        public String[] channels;

        InstructionFlush(int opcode, int retReg, String[] channels) {
            super(opcode, new int[0]);
            this.retReg = retReg;
            this.channels = channels;
        }

        @Override
        public String toString() {
            StringJoiner sj = new StringJoiner(" ");
            sj.add(String.valueOf(this.retReg));
            for (int i = 0; i < this.channels.length; ++i) {
                sj.add(this.channels[i]);
            }
            return Mnemonics.getMnem(this.opcode) + " " + sj.toString();
        }
    }

    public static class InstructionWRKSyncSend
    extends Instruction {
        public int channelRefCPIndex;
        public WorkerDataChannelInfo dataChannelInfo;
        public int sigCPIndex;
        public BType type;
        public int reg;
        public int retReg;
        public boolean isSameStrand;

        InstructionWRKSyncSend(int opcode, int channelRefCPIndex, WorkerDataChannelInfo dataChannelInfo, int sigCPIndex, BType type, int reg, int retReg, boolean isSameStrand) {
            super(opcode, new int[0]);
            this.channelRefCPIndex = channelRefCPIndex;
            this.dataChannelInfo = dataChannelInfo;
            this.sigCPIndex = sigCPIndex;
            this.type = type;
            this.reg = reg;
            this.retReg = retReg;
            this.isSameStrand = isSameStrand;
        }

        @Override
        public String toString() {
            StringJoiner sj = new StringJoiner(" ");
            sj.add(String.valueOf(this.channelRefCPIndex));
            sj.add(String.valueOf(this.sigCPIndex));
            sj.add(String.valueOf(this.reg));
            return Mnemonics.getMnem(this.opcode) + " " + sj.toString();
        }
    }

    public static class InstructionCompensate
    extends Instruction {
        public String scopeName;
        public ArrayList<String> childScopes = new ArrayList();
        public int retRegIndex;

        InstructionCompensate(int opcode, String scopeName, ArrayList<String> childScopes, int retRegIndex) {
            super(opcode, new int[0]);
            this.scopeName = scopeName;
            this.childScopes = childScopes;
            this.retRegIndex = retRegIndex;
        }

        @Override
        public String toString() {
            StringJoiner sj = new StringJoiner(" ");
            sj.add(String.valueOf(this.scopeName));
            for (String child : this.childScopes) {
                sj.add(child);
            }
            return Mnemonics.getMnem(this.opcode) + " " + sj.toString() + " " + this.retRegIndex;
        }
    }

    public static class InstructionUnLock
    extends Instruction {
        public BType[] types;
        public int[] pkgRefs;
        public int[] varRegs;
        public int varCount;
        public String uuid;
        public boolean hasFieldVar;

        InstructionUnLock(int opcode, BType[] types, int[] pkgRefs, int[] varRegs, int varCount, String uuid, boolean hasFieldsVar) {
            super(opcode, new int[0]);
            this.types = types;
            this.pkgRefs = pkgRefs;
            this.varRegs = varRegs;
            this.varCount = varCount;
            this.uuid = uuid;
            this.hasFieldVar = hasFieldsVar;
        }

        @Override
        public String toString() {
            StringJoiner sj = new StringJoiner(" ");
            for (int i = 0; i < this.varRegs.length; ++i) {
                sj.add(this.types[i].toString());
                sj.add(String.valueOf(this.pkgRefs[i]));
                sj.add(String.valueOf(this.varRegs[i]));
            }
            return Mnemonics.getMnem(this.opcode) + " " + sj.toString();
        }
    }

    public static class InstructionLock
    extends Instruction {
        public BType[] types;
        public int[] pkgRefs;
        public int[] varRegs;
        public int[] fieldRegs;
        public int varCount;
        public String uuid;

        InstructionLock(int opcode, BType[] types, int[] pkgRefs, int[] varRegs, int[] fieldNames, int varCount, String uuid) {
            super(opcode, new int[0]);
            this.types = types;
            this.pkgRefs = pkgRefs;
            this.varRegs = varRegs;
            this.fieldRegs = fieldNames;
            this.varCount = varCount;
            this.uuid = uuid;
        }

        @Override
        public String toString() {
            StringJoiner sj = new StringJoiner(" ");
            for (int i = 0; i < this.varRegs.length; ++i) {
                sj.add(this.types[i].toString());
                sj.add(String.valueOf(this.pkgRefs[i]));
                sj.add(String.valueOf(this.varRegs[i]));
            }
            return Mnemonics.getMnem(this.opcode) + " " + sj.toString();
        }
    }

    public static class InstructionIteratorNext
    extends Instruction {
        public int iteratorIndex;
        public int arity;
        public int[] typeTags;
        public int[] retRegs;
        public BType constraintType;

        InstructionIteratorNext(int opcode, int iteratorIndex, int arity, int[] typeTags, int[] retRegs, BType constraintType) {
            super(opcode, new int[0]);
            this.iteratorIndex = iteratorIndex;
            this.arity = arity;
            this.typeTags = typeTags;
            this.retRegs = retRegs;
            this.constraintType = constraintType;
        }
    }

    public static class InstructionFORKJOIN
    extends Instruction {
        public int forkJoinCPIndex;
        public ForkJoinCPEntry forkJoinCPEntry;
        public int timeoutRegIndex;
        public int joinVarRegIndex;
        public int joinBlockAddr;
        public int timeoutVarRegIndex;
        public int timeoutBlockAddr;

        public InstructionFORKJOIN(int opcode, int forkJoinCPIndex, ForkJoinCPEntry forkJoinCPEntry, int timeoutRegIndex, int joinVarRegIndex, int joinBlockAddr, int timeoutVarRegIndex, int timeoutBlockAddr) {
            super(opcode, new int[0]);
            this.forkJoinCPIndex = forkJoinCPIndex;
            this.forkJoinCPEntry = forkJoinCPEntry;
            this.timeoutRegIndex = timeoutRegIndex;
            this.joinVarRegIndex = joinVarRegIndex;
            this.joinBlockAddr = joinBlockAddr;
            this.timeoutVarRegIndex = timeoutVarRegIndex;
            this.timeoutBlockAddr = timeoutBlockAddr;
        }

        @Override
        public String toString() {
            StringJoiner sj = new StringJoiner(" ");
            sj.add(String.valueOf(this.forkJoinCPIndex));
            sj.add(String.valueOf(this.timeoutRegIndex));
            sj.add(String.valueOf(this.joinVarRegIndex));
            sj.add(String.valueOf(this.joinBlockAddr));
            sj.add(String.valueOf(this.timeoutVarRegIndex));
            sj.add(String.valueOf(this.timeoutBlockAddr));
            return Mnemonics.getMnem(this.opcode) + " " + sj.toString();
        }
    }

    public static class InstructionCHNSend
    extends Instruction {
        public String channelName;
        public BType dataType;
        public int dataReg;
        public BType keyType;
        public int keyReg;

        public InstructionCHNSend(int opcode, String channelName, BType dataType, int dataReg, BType keyType, int keyReg) {
            super(opcode, new int[0]);
            this.channelName = channelName;
            this.dataType = dataType;
            this.dataReg = dataReg;
            this.keyType = keyType;
            this.keyReg = keyReg;
        }
    }

    public static class InstructionCHNReceive
    extends Instruction {
        public String channelName;
        public BType receiverType;
        public int receiverReg;
        public BType keyType;
        public int keyReg;

        public InstructionCHNReceive(int opcode, String channelName, BType receiverType, int receiverReg, BType keyType, int keyReg) {
            super(opcode, new int[0]);
            this.channelName = channelName;
            this.receiverType = receiverType;
            this.receiverReg = receiverReg;
            this.keyType = keyType;
            this.keyReg = keyReg;
        }
    }

    public static class InstructionWRKSendReceive
    extends Instruction {
        public int channelRefCPIndex;
        public WorkerDataChannelInfo dataChannelInfo;
        public int sigCPIndex;
        public BType type;
        public int reg;
        public boolean channelInSameStrand;

        InstructionWRKSendReceive(int opcode, int channelRefCPIndex, WorkerDataChannelInfo dataChannelInfo, int sigCPIndex, BType type, int reg, boolean channelInSameStrand) {
            super(opcode, new int[0]);
            this.channelRefCPIndex = channelRefCPIndex;
            this.dataChannelInfo = dataChannelInfo;
            this.sigCPIndex = sigCPIndex;
            this.type = type;
            this.reg = reg;
            this.channelInSameStrand = channelInSameStrand;
        }

        @Override
        public String toString() {
            StringJoiner sj = new StringJoiner(" ");
            sj.add(String.valueOf(this.channelRefCPIndex));
            sj.add(String.valueOf(this.sigCPIndex));
            sj.add(String.valueOf(this.reg));
            return Mnemonics.getMnem(this.opcode) + " " + sj.toString();
        }
    }

    public static class InstructionACALL
    extends Instruction {
        public int actionRefCPIndex;
        public String actionName;
        public int flags;
        public int[] argRegs;
        public int[] retRegs;

        InstructionACALL(int opcode, int actionRefCPIndex, String actionName, int flags, int[] argRegs, int[] retRegs) {
            super(opcode, new int[0]);
            this.actionRefCPIndex = actionRefCPIndex;
            this.actionName = actionName;
            this.flags = flags;
            this.argRegs = argRegs;
            this.retRegs = retRegs;
        }
    }

    public static class InstructionVCALL
    extends InstructionCALL {
        public int receiverRegIndex;

        InstructionVCALL(int opcode, int receiverRegIndex, int funcRefCPIndex, FunctionInfo functionInfo, int flags, int[] argRegs, int[] retRegs) {
            super(opcode, funcRefCPIndex, functionInfo, flags, argRegs, retRegs);
            this.receiverRegIndex = receiverRegIndex;
        }

        @Override
        public String toString() {
            StringJoiner sj = new StringJoiner(" ");
            sj.add(String.valueOf(this.receiverRegIndex));
            sj.add(String.valueOf(this.funcRefCPIndex));
            sj.add(String.valueOf(this.argRegs.length));
            Arrays.stream(this.argRegs).forEach(i -> sj.add(String.valueOf(i)));
            sj.add(String.valueOf(this.retRegs.length));
            Arrays.stream(this.retRegs).forEach(i -> sj.add(String.valueOf(i)));
            return Mnemonics.getMnem(this.opcode) + " " + sj.toString();
        }
    }

    public static class InstructionCALL
    extends Instruction {
        public int funcRefCPIndex;
        public FunctionInfo functionInfo;
        public int flags;
        public int[] argRegs;
        public int[] retRegs;

        InstructionCALL(int opcode, int funcRefCPIndex, FunctionInfo functionInfo, int flags, int[] argRegs, int[] retRegs) {
            super(opcode, new int[0]);
            this.funcRefCPIndex = funcRefCPIndex;
            this.functionInfo = functionInfo;
            this.flags = flags;
            this.argRegs = argRegs;
            this.retRegs = retRegs;
        }

        @Override
        public String toString() {
            StringJoiner sj = new StringJoiner(" ");
            sj.add(String.valueOf(this.funcRefCPIndex));
            sj.add(String.valueOf(this.flags));
            sj.add(String.valueOf(this.argRegs.length));
            Arrays.stream(this.argRegs).forEach(i -> sj.add(String.valueOf(i)));
            sj.add(String.valueOf(this.retRegs.length));
            Arrays.stream(this.retRegs).forEach(i -> sj.add(String.valueOf(i)));
            return Mnemonics.getMnem(this.opcode) + " " + sj.toString();
        }
    }
}

