/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.codegen;

import java.util.Objects;
import org.ballerinalang.util.codegen.Instruction;
import org.ballerinalang.util.codegen.PackageInfo;

public class LineNumberInfo {
    private int lineNumber = -1;
    private int fileNameCPIndex = -1;
    private String fileName;
    private int ip = -1;
    private boolean isDebugPoint = false;
    private int endIp;
    private PackageInfo packageInfo;

    public LineNumberInfo(int lineNumber, int fileNameCPIndex, String fileName, int ip) {
        this.lineNumber = lineNumber;
        this.fileNameCPIndex = fileNameCPIndex;
        this.fileName = fileName;
        this.ip = ip;
    }

    public int getFileNameCPIndex() {
        return this.fileNameCPIndex;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getFileName() {
        return this.fileName;
    }

    public PackageInfo getPackageInfo() {
        return this.packageInfo;
    }

    public void setPackageInfo(PackageInfo packageInfo) {
        this.packageInfo = packageInfo;
    }

    public int getIp() {
        return this.ip;
    }

    public void setIp(int ip) {
        this.ip = ip;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LineNumberInfo)) {
            return false;
        }
        LineNumberInfo that = (LineNumberInfo)o;
        return this.lineNumber == that.getLineNumber() && this.fileNameCPIndex == that.getFileNameCPIndex() && this.packageInfo == that.getPackageInfo();
    }

    public int hashCode() {
        return Objects.hash(this.lineNumber, this.fileNameCPIndex, this.packageInfo, this.ip);
    }

    public String toString() {
        return "\t" + this.fileName + ":" + this.lineNumber + "\t\t" + this.ip;
    }

    public boolean isDebugPoint() {
        return this.isDebugPoint;
    }

    public void setDebugPoint(boolean debugPoint) {
        this.isDebugPoint = debugPoint;
    }

    public void setEndIp(int endIp) {
        this.endIp = endIp;
    }

    public boolean checkIpRangeForInstructionCode(Instruction[] codes, int matchingCode) {
        for (int i = this.ip; i < this.endIp; ++i) {
            if (codes[i].getOpcode() != matchingCode) continue;
            return true;
        }
        return false;
    }
}

