/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.codegen;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.ballerinalang.util.codegen.PackageInfoReader;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.exceptions.BLangRuntimeException;
import org.wso2.ballerinalang.compiler.util.Names;

public class PackageFileReader {
    private ProgramFile programFile;

    public PackageFileReader(ProgramFile programFile) {
        this.programFile = programFile;
    }

    public void readPackage(String packageId) throws IOException {
        if (!packageId.startsWith("ballerina/")) {
            throw new UnsupportedOperationException("only internal modules can be loaded at runtime: " + packageId);
        }
        String pkgName = packageId.replaceFirst("^ballerina\\/", "");
        this.readPackage(this.getCompiledPackageBinary(pkgName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readPackage(Path programFilePath) throws IOException {
        try (InputStream fileIS = null;){
            this.programFile.setProgramFilePath(programFilePath);
            fileIS = Files.newInputStream(programFilePath, StandardOpenOption.READ, LinkOption.NOFOLLOW_LINKS);
            BufferedInputStream bufferedIS = new BufferedInputStream(fileIS);
            DataInputStream dataInStream = new DataInputStream(bufferedIS);
            this.readPackageInternal(dataInStream);
        }
    }

    public void readPackage(InputStream programFileInStream) throws IOException {
        DataInputStream dataInStream = new DataInputStream(programFileInStream);
        this.readPackageInternal(dataInStream);
    }

    private void readPackageInternal(DataInputStream dataInStream) throws IOException {
        PackageInfoReader pkgInfoReader = new PackageInfoReader(dataInStream, this.programFile);
        int magicNumber = dataInStream.readInt();
        if (magicNumber != -1) {
            throw new BLangRuntimeException("ballerina: invalid magic number " + magicNumber);
        }
        short version = dataInStream.readShort();
        if (version != 50) {
            throw new BLangRuntimeException("ballerina: unsupported program file version " + version);
        }
        this.programFile.setVersion(version);
        pkgInfoReader.readPackageInfo();
    }

    private InputStream getCompiledPackageBinary(String pkgName) throws IOException {
        String ballerinaHome = System.getProperty("ballerina.home");
        Path libsPath = Paths.get(ballerinaHome, "lib", "repo", "ballerina", pkgName, Names.DEFAULT_VERSION.value, pkgName + ".zip");
        ZipFile zipFile = new ZipFile(libsPath.toFile());
        ZipEntry zipEntry = zipFile.getEntry("obj/" + pkgName + ".balo");
        BufferedInputStream is = new BufferedInputStream(zipFile.getInputStream(zipEntry));
        return is;
    }
}

