/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.codegen;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import java.util.stream.Stream;
import org.ballerinalang.model.NativeCallableUnit;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BAttachedFunction;
import org.ballerinalang.model.types.BErrorType;
import org.ballerinalang.model.types.BField;
import org.ballerinalang.model.types.BFiniteType;
import org.ballerinalang.model.types.BFunctionType;
import org.ballerinalang.model.types.BMapType;
import org.ballerinalang.model.types.BObjectType;
import org.ballerinalang.model.types.BRecordType;
import org.ballerinalang.model.types.BServiceType;
import org.ballerinalang.model.types.BStreamType;
import org.ballerinalang.model.types.BStructureType;
import org.ballerinalang.model.types.BTableType;
import org.ballerinalang.model.types.BTupleType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.types.BUnionType;
import org.ballerinalang.model.util.Flags;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BByte;
import org.ballerinalang.model.values.BDecimal;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueType;
import org.ballerinalang.natives.NativeUnitLoader;
import org.ballerinalang.util.codegen.CallableUnitInfo;
import org.ballerinalang.util.codegen.CustomTypeInfo;
import org.ballerinalang.util.codegen.DefaultValue;
import org.ballerinalang.util.codegen.ErrorTableEntry;
import org.ballerinalang.util.codegen.ErrorTypeInfo;
import org.ballerinalang.util.codegen.FiniteTypeInfo;
import org.ballerinalang.util.codegen.ForkjoinInfo;
import org.ballerinalang.util.codegen.FunctionInfo;
import org.ballerinalang.util.codegen.Instruction;
import org.ballerinalang.util.codegen.InstructionFactory;
import org.ballerinalang.util.codegen.LineNumberInfo;
import org.ballerinalang.util.codegen.LocalVariableInfo;
import org.ballerinalang.util.codegen.ObjectTypeInfo;
import org.ballerinalang.util.codegen.PackageFileReader;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.PackageVarInfo;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.codegen.RecordTypeInfo;
import org.ballerinalang.util.codegen.ServiceInfo;
import org.ballerinalang.util.codegen.StructFieldInfo;
import org.ballerinalang.util.codegen.StructureTypeInfo;
import org.ballerinalang.util.codegen.TypeDefInfo;
import org.ballerinalang.util.codegen.WorkerDataChannelInfo;
import org.ballerinalang.util.codegen.WorkerInfo;
import org.ballerinalang.util.codegen.attributes.AttributeInfo;
import org.ballerinalang.util.codegen.attributes.AttributeInfoPool;
import org.ballerinalang.util.codegen.attributes.CodeAttributeInfo;
import org.ballerinalang.util.codegen.attributes.DefaultValueAttributeInfo;
import org.ballerinalang.util.codegen.attributes.DocumentationAttributeInfo;
import org.ballerinalang.util.codegen.attributes.ErrorTableAttributeInfo;
import org.ballerinalang.util.codegen.attributes.LineNumberTableAttributeInfo;
import org.ballerinalang.util.codegen.attributes.LocalVariableAttributeInfo;
import org.ballerinalang.util.codegen.attributes.ParamDefaultValueAttributeInfo;
import org.ballerinalang.util.codegen.attributes.ParameterAttributeInfo;
import org.ballerinalang.util.codegen.attributes.TaintTableAttributeInfo;
import org.ballerinalang.util.codegen.attributes.VarTypeCountAttributeInfo;
import org.ballerinalang.util.codegen.attributes.WorkerSendInsAttributeInfo;
import org.ballerinalang.util.codegen.cpentries.ActionRefCPEntry;
import org.ballerinalang.util.codegen.cpentries.BlobCPEntry;
import org.ballerinalang.util.codegen.cpentries.ConstantPool;
import org.ballerinalang.util.codegen.cpentries.ConstantPoolEntry;
import org.ballerinalang.util.codegen.cpentries.FloatCPEntry;
import org.ballerinalang.util.codegen.cpentries.ForkJoinCPEntry;
import org.ballerinalang.util.codegen.cpentries.FunctionCallCPEntry;
import org.ballerinalang.util.codegen.cpentries.FunctionRefCPEntry;
import org.ballerinalang.util.codegen.cpentries.IntegerCPEntry;
import org.ballerinalang.util.codegen.cpentries.MapCPEntry;
import org.ballerinalang.util.codegen.cpentries.PackageRefCPEntry;
import org.ballerinalang.util.codegen.cpentries.StringCPEntry;
import org.ballerinalang.util.codegen.cpentries.StructureRefCPEntry;
import org.ballerinalang.util.codegen.cpentries.TypeRefCPEntry;
import org.ballerinalang.util.codegen.cpentries.UTF8CPEntry;
import org.ballerinalang.util.codegen.cpentries.WorkerDataChannelRefCPEntry;
import org.ballerinalang.util.exceptions.BLangRuntimeException;
import org.ballerinalang.util.exceptions.ProgramFileFormatException;
import org.wso2.ballerinalang.compiler.TypeCreator;
import org.wso2.ballerinalang.compiler.TypeSignatureReader;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.programfile.ConstantValue;
import org.wso2.ballerinalang.programfile.KeyInfo;

public class PackageInfoReader {
    private ProgramFile programFile;
    private DataInputStream dataInStream;
    private List<ConstantPoolEntry> unresolvedCPEntries = new ArrayList<ConstantPoolEntry>();
    private TypeSignatureReader<BType> typeSigReader;

    public PackageInfoReader(DataInputStream dataInStream, ProgramFile programFile) {
        this.dataInStream = dataInStream;
        this.programFile = programFile;
        this.typeSigReader = new TypeSignatureReader();
    }

    public void readConstantPool(ConstantPool constantPool) throws IOException {
        int constantPoolSize = this.dataInStream.readInt();
        for (int i = 0; i < constantPoolSize; ++i) {
            byte cpTag = this.dataInStream.readByte();
            ConstantPoolEntry.EntryType cpEntryType = ConstantPoolEntry.EntryType.values()[cpTag - 1];
            ConstantPoolEntry cpEntry = this.readCPEntry(constantPool, cpEntryType);
            constantPool.addCPEntry(cpEntry);
        }
    }

    private ConstantPoolEntry readCPEntry(ConstantPool constantPool, ConstantPoolEntry.EntryType cpEntryType) throws IOException {
        switch (cpEntryType) {
            case CP_ENTRY_UTF8: {
                short length = this.dataInStream.readShort();
                String strValue = null;
                if (length >= 0) {
                    strValue = this.dataInStream.readUTF();
                }
                return new UTF8CPEntry(strValue);
            }
            case CP_ENTRY_BLOB: {
                int blobLength = this.dataInStream.readInt();
                byte[] blobValue = null;
                if (blobLength >= 0) {
                    blobValue = new byte[blobLength];
                    this.dataInStream.readFully(blobValue);
                }
                return new BlobCPEntry(blobValue);
            }
            case CP_ENTRY_INTEGER: {
                long longVal = this.dataInStream.readLong();
                return new IntegerCPEntry(longVal);
            }
            case CP_ENTRY_FLOAT: {
                double doubleVal = this.dataInStream.readDouble();
                return new FloatCPEntry(doubleVal);
            }
            case CP_ENTRY_STRING: {
                int cpIndex = this.dataInStream.readInt();
                UTF8CPEntry utf8CPEntry = (UTF8CPEntry)constantPool.getCPEntry(cpIndex);
                return new StringCPEntry(cpIndex, utf8CPEntry.getValue());
            }
            case CP_ENTRY_PACKAGE: {
                int cpIndex = this.dataInStream.readInt();
                UTF8CPEntry utf8CPEntry = (UTF8CPEntry)constantPool.getCPEntry(cpIndex);
                int versionCPIndex = this.dataInStream.readInt();
                UTF8CPEntry utf8VersionCPEntry = (UTF8CPEntry)constantPool.getCPEntry(versionCPIndex);
                PackageRefCPEntry packageRefCPEntry = new PackageRefCPEntry(cpIndex, utf8CPEntry.getValue(), versionCPIndex, utf8VersionCPEntry.getValue());
                Optional<PackageInfo> packageInfoOptional = Optional.ofNullable(this.programFile.getPackageInfo(packageRefCPEntry.getPackageName()));
                if (packageInfoOptional.isPresent()) {
                    packageRefCPEntry.setPackageInfo(packageInfoOptional.get());
                } else {
                    this.unresolvedCPEntries.add(packageRefCPEntry);
                }
                return packageRefCPEntry;
            }
            case CP_ENTRY_FUNCTION_REF: {
                int pkgCPIndex = this.dataInStream.readInt();
                PackageRefCPEntry packageRefCPEntry = (PackageRefCPEntry)constantPool.getCPEntry(pkgCPIndex);
                int cpIndex = this.dataInStream.readInt();
                UTF8CPEntry utf8CPEntry = (UTF8CPEntry)constantPool.getCPEntry(cpIndex);
                String funcName = utf8CPEntry.getValue();
                FunctionRefCPEntry functionRefCPEntry = new FunctionRefCPEntry(pkgCPIndex, packageRefCPEntry.getPackageName(), cpIndex, funcName);
                Optional<PackageInfo> packageInfoOptional = Optional.ofNullable(this.programFile.getPackageInfo(packageRefCPEntry.getPackageName()));
                Optional<FunctionInfo> funcInfoOptional = packageInfoOptional.map(packageInfo -> packageInfo.getFunctionInfo(funcName));
                if (!funcInfoOptional.isPresent()) {
                    this.unresolvedCPEntries.add(functionRefCPEntry);
                    return functionRefCPEntry;
                }
                functionRefCPEntry.setFunctionInfo(funcInfoOptional.get());
                return functionRefCPEntry;
            }
            case CP_ENTRY_ACTION_REF: {
                int pkgCPIndex = this.dataInStream.readInt();
                PackageRefCPEntry packageRefCPEntry = (PackageRefCPEntry)constantPool.getCPEntry(pkgCPIndex);
                int cpIndex = this.dataInStream.readInt();
                UTF8CPEntry nameCPEntry = (UTF8CPEntry)constantPool.getCPEntry(cpIndex);
                String actionName = nameCPEntry.getValue();
                return new ActionRefCPEntry(pkgCPIndex, packageRefCPEntry.getPackageName(), cpIndex, actionName);
            }
            case CP_ENTRY_STRUCTURE_REF: {
                int pkgCPIndex = this.dataInStream.readInt();
                PackageRefCPEntry packageRefCPEntry = (PackageRefCPEntry)constantPool.getCPEntry(pkgCPIndex);
                int cpIndex = this.dataInStream.readInt();
                UTF8CPEntry utf8CPEntry = (UTF8CPEntry)constantPool.getCPEntry(cpIndex);
                StructureRefCPEntry structureRefCPEntry = new StructureRefCPEntry(pkgCPIndex, packageRefCPEntry.getPackageName(), cpIndex, utf8CPEntry.getValue());
                Optional<PackageInfo> packageInfoOptional = Optional.ofNullable(this.programFile.getPackageInfo(packageRefCPEntry.getPackageName()));
                Optional<CustomTypeInfo> structInfoOptional = packageInfoOptional.map(packageInfo -> packageInfo.getStructureTypeInfo(utf8CPEntry.getValue()));
                if (!structInfoOptional.isPresent()) {
                    this.unresolvedCPEntries.add(structureRefCPEntry);
                    return structureRefCPEntry;
                }
                structureRefCPEntry.setStructureTypeInfo(structInfoOptional.get());
                return structureRefCPEntry;
            }
            case CP_ENTRY_TYPE_REF: {
                int typeSigCPIndex = this.dataInStream.readInt();
                UTF8CPEntry utf8CPEntry = (UTF8CPEntry)constantPool.getCPEntry(typeSigCPIndex);
                TypeRefCPEntry typeRefCPEntry = new TypeRefCPEntry(typeSigCPIndex, utf8CPEntry.getValue());
                this.unresolvedCPEntries.add(typeRefCPEntry);
                return typeRefCPEntry;
            }
            case CP_ENTRY_FORK_JOIN: {
                int forkJoinCPIndex = this.dataInStream.readInt();
                return new ForkJoinCPEntry(forkJoinCPIndex);
            }
            case CP_ENTRY_WRKR_DATA_CHNL_REF: {
                int uniqueNameCPIndex = this.dataInStream.readInt();
                UTF8CPEntry wrkrDtChnlTypesSigCPEntry = (UTF8CPEntry)constantPool.getCPEntry(uniqueNameCPIndex);
                return new WorkerDataChannelRefCPEntry(uniqueNameCPIndex, wrkrDtChnlTypesSigCPEntry.getValue());
            }
            case CP_ENTRY_MAP: {
                return this.getMapConstantPoolEntry(constantPool);
            }
        }
        throw new ProgramFileFormatException("invalid constant pool entry " + cpEntryType.getValue());
    }

    private ConstantPoolEntry getMapConstantPoolEntry(ConstantPool constantPool) throws IOException {
        LinkedHashMap<KeyInfo, ConstantValue> valueMap = new LinkedHashMap<KeyInfo, ConstantValue>();
        BMap<String, BRefType> bValueMap = new BMap<String, BRefType>();
        int size = this.dataInStream.readInt();
        for (int i = 0; i < size; ++i) {
            int keyCPIndex = this.dataInStream.readInt();
            UTF8CPEntry keyCPEntry = (UTF8CPEntry)constantPool.getCPEntry(keyCPIndex);
            boolean isSimpleLiteral = this.dataInStream.readBoolean();
            if (isSimpleLiteral) {
                BMap<String, BRefType> tempMap = this.readSimpleLiteral(constantPool, valueMap, keyCPEntry);
                for (String key : tempMap.keys()) {
                    bValueMap.put(key, tempMap.get(key));
                }
                continue;
            }
            int constantValueCPEntryIndex = this.dataInStream.readInt();
            MapCPEntry mapCPEntry = (MapCPEntry)constantPool.getCPEntry(constantValueCPEntryIndex);
            bValueMap.put(keyCPEntry.getValue(), mapCPEntry.getBMap());
            KeyInfo keyInfo = new KeyInfo(keyCPEntry.getValue());
            ConstantValue constantValue = new ConstantValue();
            constantValue.valueCPEntryIndex = constantValueCPEntryIndex;
            constantValue.constantValueMap = mapCPEntry.getConstantValueMap();
            valueMap.put(keyInfo, constantValue);
        }
        return new MapCPEntry(valueMap, bValueMap);
    }

    private BMap<String, BRefType> readSimpleLiteral(ConstantPool constantPool, LinkedHashMap<KeyInfo, ConstantValue> valueMap, UTF8CPEntry keyCPEntry) throws IOException {
        BMap<String, BRefType<Object>> bValueMap;
        int typeTag = this.dataInStream.readInt();
        ConstantValue constantValue = new ConstantValue();
        constantValue.literalValueTypeTag = typeTag;
        constantValue.isSimpleLiteral = true;
        KeyInfo keyInfo = new KeyInfo(keyCPEntry.getValue());
        valueMap.put(keyInfo, constantValue);
        if (typeTag == 10) {
            BMapType bMapType = new BMapType(BTypes.typeNull);
            bValueMap = new BMap<String, BRefType>(bMapType);
            bValueMap.put(keyCPEntry.getValue(), null);
        } else if (typeTag == 6) {
            boolean value2 = this.dataInStream.readBoolean();
            BMapType bMapType = new BMapType(BTypes.typeBoolean);
            bValueMap = new BMap(bMapType);
            constantValue.booleanValue = value2;
            BBoolean bBoolean = new BBoolean(value2);
            bValueMap.put(keyCPEntry.getValue(), bBoolean);
        } else {
            int valueCPIndex;
            constantValue.valueCPEntryIndex = valueCPIndex = this.dataInStream.readInt();
            ConstantPoolEntry cpEntry = constantPool.getCPEntry(valueCPIndex);
            switch (typeTag) {
                case 1: {
                    BMapType bMapType = new BMapType(BTypes.typeInt);
                    bValueMap = new BMap(bMapType);
                    BInteger bInteger = new BInteger(((IntegerCPEntry)cpEntry).getValue());
                    bValueMap.put(keyCPEntry.getValue(), bInteger);
                    break;
                }
                case 2: {
                    BMapType bMapType = new BMapType(BTypes.typeByte);
                    bValueMap = new BMap(bMapType);
                    BByte bByte = new BByte(((IntegerCPEntry)cpEntry).getValue());
                    bValueMap.put(keyCPEntry.getValue(), bByte);
                    break;
                }
                case 3: {
                    BMapType bMapType = new BMapType(BTypes.typeFloat);
                    bValueMap = new BMap(bMapType);
                    BFloat bFloat = new BFloat(((FloatCPEntry)cpEntry).getValue());
                    bValueMap.put(keyCPEntry.getValue(), bFloat);
                    break;
                }
                case 4: {
                    BMapType bMapType = new BMapType(BTypes.typeDecimal);
                    bValueMap = new BMap(bMapType);
                    BDecimal bDecimal = new BDecimal(new BigDecimal(((UTF8CPEntry)cpEntry).getValue(), MathContext.DECIMAL128));
                    bValueMap.put(keyCPEntry.getValue(), bDecimal);
                    break;
                }
                case 5: {
                    BMapType bMapType = new BMapType(BTypes.typeString);
                    bValueMap = new BMap(bMapType);
                    BString bString = new BString(((UTF8CPEntry)cpEntry).getValue());
                    bValueMap.put(keyCPEntry.getValue(), bString);
                    break;
                }
                default: {
                    throw new RuntimeException("unexpected type tag");
                }
            }
        }
        return bValueMap;
    }

    public void readEntryPoint() throws IOException {
        int pkdCPIndex = this.dataInStream.readInt();
        PackageRefCPEntry packageRefCPEntry = (PackageRefCPEntry)this.programFile.getCPEntry(pkdCPIndex);
        this.programFile.setEntryPkgCPIndex(pkdCPIndex);
        this.programFile.setEntryPkgName(packageRefCPEntry.getPackageName());
        byte flags = this.dataInStream.readByte();
        if ((flags & 1) == 1) {
            this.programFile.setMainEPAvailable(true);
        }
        if ((flags & 2) == 2) {
            this.programFile.setServiceEPAvailable(true);
        }
    }

    public void readPackageInfo() throws IOException {
        PackageInfo packageInfo = new PackageInfo();
        this.readConstantPool(packageInfo);
        int orgNameCPIndex = this.dataInStream.readInt();
        UTF8CPEntry orgNameCPEntry = (UTF8CPEntry)packageInfo.getCPEntry(orgNameCPIndex);
        packageInfo.orgNameCPIndex = orgNameCPIndex;
        int pkgNameCPIndex = this.dataInStream.readInt();
        UTF8CPEntry pkgNameCPEntry = (UTF8CPEntry)packageInfo.getCPEntry(pkgNameCPIndex);
        packageInfo.nameCPIndex = pkgNameCPIndex;
        int pkgVersionCPIndex = this.dataInStream.readInt();
        UTF8CPEntry pkgVersionCPEntry = (UTF8CPEntry)packageInfo.getCPEntry(pkgVersionCPIndex);
        packageInfo.versionCPIndex = pkgVersionCPIndex;
        packageInfo.pkgVersion = pkgVersionCPEntry.getValue();
        packageInfo.pkgPath = this.getPackagePath(orgNameCPEntry.getValue(), pkgNameCPEntry.getValue(), pkgVersionCPEntry.getValue());
        packageInfo.setProgramFile(this.programFile);
        this.readImportPackageInfoEntries(packageInfo);
        packageInfo.pkgIndex = this.programFile.currentPkgIndex++;
        this.programFile.addPackageInfo(packageInfo.pkgPath, packageInfo);
        this.readTypeDefInfoEntries(packageInfo);
        this.readAnnotationInfoEntries(packageInfo);
        this.readServiceInfoEntries(packageInfo);
        this.resolveUserDefinedTypes(packageInfo);
        this.readResourceInfoEntries(packageInfo);
        this.readConstantInfoEntries(packageInfo);
        this.readGlobalVarInfoEntries(packageInfo);
        this.readFunctionInfoEntries(packageInfo);
        this.setAttachedFunctions(packageInfo);
        this.resolveCPEntries(packageInfo);
        this.readAttributeInfoEntries(packageInfo, packageInfo, packageInfo);
        this.readInstructions(packageInfo);
        packageInfo.complete();
    }

    private void readImportPackageInfoEntries(PackageInfo packageInfo) throws IOException {
        int impPkgCount = this.dataInStream.readShort();
        for (int i = 0; i < impPkgCount; ++i) {
            int orgNameCPIndex = this.dataInStream.readInt();
            UTF8CPEntry orgNameCPEntry = (UTF8CPEntry)packageInfo.getCPEntry(orgNameCPIndex);
            int pkgNameCPIndex = this.dataInStream.readInt();
            UTF8CPEntry pkgNameCPEntry = (UTF8CPEntry)packageInfo.getCPEntry(pkgNameCPIndex);
            int pkgVersionCPIndex = this.dataInStream.readInt();
            UTF8CPEntry pkgVersionCPEntry = (UTF8CPEntry)packageInfo.getCPEntry(pkgVersionCPIndex);
            this.getPackageInfo(this.getPackagePath(orgNameCPEntry.getValue(), pkgNameCPEntry.getValue(), pkgVersionCPEntry.getValue()));
        }
    }

    private void readTypeDefInfoEntries(PackageInfo packageInfo) throws IOException {
        int typeDefCount = this.dataInStream.readShort();
        for (int i = 0; i < typeDefCount; ++i) {
            int typeDefNameCPIndex = this.dataInStream.readInt();
            int flags = this.dataInStream.readInt();
            boolean isLabel = this.dataInStream.readBoolean();
            int typeTag = this.dataInStream.readInt();
            UTF8CPEntry typeDefNameUTF8Entry = (UTF8CPEntry)packageInfo.getCPEntry(typeDefNameCPIndex);
            String typeDefName = typeDefNameUTF8Entry.getValue();
            TypeDefInfo typeDefInfo = new TypeDefInfo(packageInfo.getPkgNameCPIndex(), packageInfo.getPkgPath(), typeDefNameCPIndex, typeDefName, flags);
            typeDefInfo.typeTag = typeTag;
            if (isLabel) {
                this.dataInStream.readInt();
                this.readAttributeInfoEntries(packageInfo, packageInfo, typeDefInfo);
                continue;
            }
            switch (typeDefInfo.typeTag) {
                case 33: {
                    this.readObjectInfoEntry(packageInfo, typeDefInfo);
                    packageInfo.addTypeDefInfo(typeDefName, typeDefInfo);
                    break;
                }
                case 12: {
                    this.readRecordInfoEntry(packageInfo, typeDefInfo);
                    packageInfo.addTypeDefInfo(typeDefName, typeDefInfo);
                    break;
                }
                case 27: {
                    this.readErrorInfoEntry(packageInfo, typeDefInfo);
                    packageInfo.addTypeDefInfo(typeDefName, typeDefInfo);
                    break;
                }
                case 32: {
                    this.readFiniteTypeInfoEntry(packageInfo, typeDefInfo);
                    packageInfo.addTypeDefInfo(typeDefName, typeDefInfo);
                    break;
                }
                default: {
                    this.dataInStream.readInt();
                }
            }
            this.readAttributeInfoEntries(packageInfo, packageInfo, typeDefInfo);
        }
    }

    private void readAnnotationInfoEntries(PackageInfo packageInfo) throws IOException {
        int typeDefCount = this.dataInStream.readShort();
        for (int i = 0; i < typeDefCount; ++i) {
            this.dataInStream.readInt();
            this.dataInStream.readInt();
            this.dataInStream.readInt();
            this.dataInStream.readInt();
        }
    }

    private void readObjectInfoEntry(PackageInfo packageInfo, TypeDefInfo typeDefInfo) throws IOException {
        ObjectTypeInfo objectInfo = new ObjectTypeInfo();
        BObjectType objectType = Flags.isFlagOn(typeDefInfo.flags, 524288) ? new BServiceType(objectInfo, typeDefInfo.name, packageInfo.getPkgPath(), typeDefInfo.flags) : new BObjectType(objectInfo, typeDefInfo.name, packageInfo.getPkgPath(), typeDefInfo.flags);
        objectInfo.setType(objectType);
        int fieldCount = this.dataInStream.readShort();
        for (int j = 0; j < fieldCount; ++j) {
            int fieldNameCPIndex = this.dataInStream.readInt();
            UTF8CPEntry fieldNameUTF8Entry = (UTF8CPEntry)packageInfo.getCPEntry(fieldNameCPIndex);
            int fieldTypeSigCPIndex = this.dataInStream.readInt();
            UTF8CPEntry fieldTypeSigUTF8Entry = (UTF8CPEntry)packageInfo.getCPEntry(fieldTypeSigCPIndex);
            int fieldFlags = this.dataInStream.readInt();
            this.dataInStream.readInt();
            StructFieldInfo fieldInfo = new StructFieldInfo(fieldNameCPIndex, fieldNameUTF8Entry.getValue(), fieldTypeSigCPIndex, fieldTypeSigUTF8Entry.getValue(), fieldFlags);
            objectInfo.addFieldInfo(fieldInfo);
            this.readAttributeInfoEntries(packageInfo, packageInfo, fieldInfo);
        }
        this.readAttributeInfoEntries(packageInfo, packageInfo, objectInfo);
        typeDefInfo.typeInfo = objectInfo;
    }

    private void readRecordInfoEntry(PackageInfo packageInfo, TypeDefInfo typeDefInfo) throws IOException {
        RecordTypeInfo recordInfo = new RecordTypeInfo();
        BRecordType recordType = new BRecordType(recordInfo, typeDefInfo.name, packageInfo.getPkgPath(), typeDefInfo.flags);
        recordInfo.setType(recordType);
        recordType.sealed = this.dataInStream.readBoolean();
        if (!recordType.sealed) {
            int restFieldCPIndex = this.dataInStream.readInt();
            UTF8CPEntry restFieldTypeSigUTF8Entry = (UTF8CPEntry)packageInfo.getCPEntry(restFieldCPIndex);
            recordInfo.setRestFieldSignatureCPIndex(restFieldCPIndex);
            recordInfo.setRestFieldTypeSignature(restFieldTypeSigUTF8Entry.getValue());
        }
        int fieldCount = this.dataInStream.readShort();
        for (int j = 0; j < fieldCount; ++j) {
            int fieldNameCPIndex = this.dataInStream.readInt();
            UTF8CPEntry fieldNameUTF8Entry = (UTF8CPEntry)packageInfo.getCPEntry(fieldNameCPIndex);
            int fieldTypeSigCPIndex = this.dataInStream.readInt();
            UTF8CPEntry fieldTypeSigUTF8Entry = (UTF8CPEntry)packageInfo.getCPEntry(fieldTypeSigCPIndex);
            int fieldFlags = this.dataInStream.readInt();
            this.dataInStream.readInt();
            StructFieldInfo fieldInfo = new StructFieldInfo(fieldNameCPIndex, fieldNameUTF8Entry.getValue(), fieldTypeSigCPIndex, fieldTypeSigUTF8Entry.getValue(), fieldFlags);
            recordInfo.addFieldInfo(fieldInfo);
            this.readAttributeInfoEntries(packageInfo, packageInfo, fieldInfo);
        }
        this.readAttributeInfoEntries(packageInfo, packageInfo, recordInfo);
        typeDefInfo.typeInfo = recordInfo;
    }

    private void readErrorInfoEntry(PackageInfo packageInfo, TypeDefInfo typeDefInfo) throws IOException {
        ErrorTypeInfo errorTypeInfo = new ErrorTypeInfo();
        int reasonTypeCPIndex = this.dataInStream.readInt();
        UTF8CPEntry reasonTypeSigUTF8Entry = (UTF8CPEntry)packageInfo.getCPEntry(reasonTypeCPIndex);
        errorTypeInfo.setReasonFieldTypeSignature(reasonTypeSigUTF8Entry.getValue());
        int detailTypeCPIndex = this.dataInStream.readInt();
        UTF8CPEntry detailTypeSigUTF8Entry = (UTF8CPEntry)packageInfo.getCPEntry(detailTypeCPIndex);
        errorTypeInfo.setDetailFieldTypeSignature(detailTypeSigUTF8Entry.getValue());
        BErrorType errorType = new BErrorType(errorTypeInfo, typeDefInfo.name, packageInfo.getPkgPath());
        errorTypeInfo.setType(errorType);
        this.readAttributeInfoEntries(packageInfo, packageInfo, errorTypeInfo);
        typeDefInfo.typeInfo = errorTypeInfo;
    }

    private void readFiniteTypeInfoEntry(PackageInfo packageInfo, TypeDefInfo typeDefInfo) throws IOException {
        FiniteTypeInfo typeInfo = new FiniteTypeInfo();
        BFiniteType finiteType = new BFiniteType(typeDefInfo.name, packageInfo.getPkgPath());
        typeInfo.setType(finiteType);
        int valueSpaceCount = this.dataInStream.readShort();
        for (int k = 0; k < valueSpaceCount; ++k) {
            finiteType.valueSpace.add(this.getDefaultValueToBValue(this.getDefaultValue(packageInfo)));
        }
        typeDefInfo.typeInfo = typeInfo;
    }

    private void readServiceInfoEntries(PackageInfo packageInfo) throws IOException {
        int serviceCount = this.dataInStream.readShort();
        for (int i = 0; i < serviceCount; ++i) {
            int serviceNameCPIndex = this.dataInStream.readInt();
            UTF8CPEntry serviceNameUTF8Entry = (UTF8CPEntry)packageInfo.getCPEntry(serviceNameCPIndex);
            int flags = this.dataInStream.readInt();
            TypeRefCPEntry serviceType = (TypeRefCPEntry)packageInfo.getCPEntry(this.dataInStream.readInt());
            ServiceInfo serviceInfo = new ServiceInfo(packageInfo.getPkgNameCPIndex(), packageInfo.getPkgPath(), serviceNameCPIndex, serviceNameUTF8Entry.getValue(), flags, serviceType);
            serviceInfo.setPackageInfo(packageInfo);
            packageInfo.addServiceInfo(serviceInfo.getName(), serviceInfo);
        }
    }

    private void readResourceInfoEntries(PackageInfo packageInfo) throws IOException {
        this.dataInStream.readShort();
        for (ServiceInfo serviceInfo : packageInfo.getServiceInfoEntries()) {
            int actionCount = this.dataInStream.readShort();
            for (int j = 0; j < actionCount; ++j) {
                int resNameCPIndex = this.dataInStream.readInt();
                UTF8CPEntry resNameUTF8Entry = (UTF8CPEntry)packageInfo.getCPEntry(resNameCPIndex);
                String resName = resNameUTF8Entry.getValue();
                serviceInfo.addResourceInfo(resName);
            }
        }
    }

    private void readConstantInfoEntries(PackageInfo packageInfo) throws IOException {
        int constCount = this.dataInStream.readShort();
        for (int i = 0; i < constCount; ++i) {
            this.readConstantInfo(packageInfo, packageInfo);
        }
    }

    private void readGlobalVarInfoEntries(PackageInfo packageInfo) throws IOException {
        int globalVarCount = this.dataInStream.readShort();
        for (int i = 0; i < globalVarCount; ++i) {
            PackageVarInfo packageVarInfo = this.getGlobalVarInfo(packageInfo, packageInfo);
            packageInfo.addPackageVarInfo(packageVarInfo.getName(), packageVarInfo);
        }
    }

    private void readConstantInfo(PackageInfo packageInfo, ConstantPool constantPool) throws IOException {
        this.dataInStream.readInt();
        this.dataInStream.readInt();
        boolean isSimpleLiteral = this.dataInStream.readBoolean();
        if (isSimpleLiteral) {
            this.dataInStream.readInt();
            int valueTypeSigCPIndex = this.dataInStream.readInt();
            UTF8CPEntry resNameUTF8Entry = (UTF8CPEntry)packageInfo.getCPEntry(valueTypeSigCPIndex);
            RuntimeTypeCreator typeCreator = new RuntimeTypeCreator(packageInfo);
            BType type = (BType)this.typeSigReader.getBTypeFromDescriptor((TypeCreator)typeCreator, resNameUTF8Entry.getValue());
            this.readSimpleLiteral(type);
        } else {
            this.dataInStream.readInt();
            this.dataInStream.readInt();
            this.readMapLiteral(packageInfo);
        }
        int attributesCount = this.dataInStream.readShort();
        for (int k = 0; k < attributesCount; ++k) {
            this.getAttributeInfo(packageInfo, constantPool);
        }
    }

    private void readSimpleLiteral(BType type) throws IOException {
        switch (type.getTag()) {
            case 6: {
                this.dataInStream.readBoolean();
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.dataInStream.readInt();
                break;
            }
            case 10: {
                break;
            }
            default: {
                throw new RuntimeException("unexpected type tag: " + type.getTag());
            }
        }
    }

    private void readMapLiteral(PackageInfo packageInfo) throws IOException {
        int size = this.dataInStream.readInt();
        for (int i = 0; i < size; ++i) {
            this.dataInStream.readInt();
            boolean isSimpleLiteral = this.dataInStream.readBoolean();
            this.dataInStream.readBoolean();
            if (isSimpleLiteral) {
                int valueTypeSigCPIndex = this.dataInStream.readInt();
                UTF8CPEntry resNameUTF8Entry = (UTF8CPEntry)packageInfo.getCPEntry(valueTypeSigCPIndex);
                RuntimeTypeCreator typeCreator = new RuntimeTypeCreator(packageInfo);
                BType type = (BType)this.typeSigReader.getBTypeFromDescriptor((TypeCreator)typeCreator, resNameUTF8Entry.getValue());
                this.readSimpleLiteral(type);
                continue;
            }
            this.dataInStream.readInt();
            this.dataInStream.readInt();
            this.readMapLiteral(packageInfo);
        }
    }

    private PackageVarInfo getGlobalVarInfo(PackageInfo packageInfo, ConstantPool constantPool) throws IOException {
        int nameCPIndex = this.dataInStream.readInt();
        UTF8CPEntry nameUTF8CPEntry = (UTF8CPEntry)constantPool.getCPEntry(nameCPIndex);
        int sigCPIndex = this.dataInStream.readInt();
        UTF8CPEntry sigUTF8CPEntry = (UTF8CPEntry)constantPool.getCPEntry(sigCPIndex);
        this.dataInStream.readInt();
        int globalMemIndex = this.dataInStream.readInt();
        boolean isIdentifierLiteral = this.dataInStream.readBoolean();
        BType type = this.getBTypeFromDescriptor(packageInfo, sigUTF8CPEntry.getValue());
        PackageVarInfo packageVarInfo = new PackageVarInfo(nameCPIndex, nameUTF8CPEntry.getValue(), sigCPIndex, globalMemIndex, type, isIdentifierLiteral);
        this.readAttributeInfoEntries(packageInfo, constantPool, packageVarInfo);
        return packageVarInfo;
    }

    private void readFunctionInfoEntries(PackageInfo packageInfo) throws IOException {
        int funcCount = this.dataInStream.readShort();
        for (int i = 0; i < funcCount; ++i) {
            this.readFunctionInfo(packageInfo);
        }
        packageInfo.setInitFunctionInfo(packageInfo.getFunctionInfo(packageInfo.getPkgPath() + ".<init>"));
        packageInfo.setStartFunctionInfo(packageInfo.getFunctionInfo(packageInfo.getPkgPath() + ".<start>"));
        packageInfo.setStopFunctionInfo(packageInfo.getFunctionInfo(packageInfo.getPkgPath() + ".<stop>"));
        packageInfo.setTestInitFunctionInfo(packageInfo.getFunctionInfo(packageInfo.getPkgPath() + ".<testinit>"));
        packageInfo.setTestStartFunctionInfo(packageInfo.getFunctionInfo(packageInfo.getPkgPath() + ".<teststart>"));
        packageInfo.setTestStopFunctionInfo(packageInfo.getFunctionInfo(packageInfo.getPkgPath() + ".<teststop>"));
    }

    private void readFunctionInfo(PackageInfo packageInfo) throws IOException {
        String uniqueFuncName;
        int funcNameCPIndex = this.dataInStream.readInt();
        UTF8CPEntry funcNameUTF8Entry = (UTF8CPEntry)packageInfo.getCPEntry(funcNameCPIndex);
        String funcName = funcNameUTF8Entry.getValue();
        FunctionInfo functionInfo = new FunctionInfo(packageInfo.getPkgNameCPIndex(), packageInfo.getPkgPath(), funcNameCPIndex, funcName);
        functionInfo.setPackageInfo(packageInfo);
        int funcSigCPIndex = this.dataInStream.readInt();
        UTF8CPEntry funcSigUTF8Entry = (UTF8CPEntry)packageInfo.getCPEntry(funcSigCPIndex);
        this.setCallableUnitSignature(packageInfo, functionInfo, funcSigUTF8Entry.getValue());
        functionInfo.flags = this.dataInStream.readInt();
        boolean nativeFunc = Flags.isFlagOn(functionInfo.flags, 2);
        functionInfo.setNative(nativeFunc);
        functionInfo.setPublic(Flags.isFlagOn(functionInfo.flags, 1));
        boolean attached = Flags.isFlagOn(functionInfo.flags, 8);
        if (attached) {
            functionInfo.attachedToTypeCPIndex = this.dataInStream.readInt();
            TypeRefCPEntry typeRefCPEntry = (TypeRefCPEntry)packageInfo.getCPEntry(functionInfo.attachedToTypeCPIndex);
            functionInfo.attachedToType = typeRefCPEntry.getType();
            uniqueFuncName = Symbols.getAttachedFuncSymbolName((String)typeRefCPEntry.getType().getName(), (String)funcName);
            this.updateAttachFunctionInfo(packageInfo, typeRefCPEntry.getType(), funcName, functionInfo);
        } else {
            uniqueFuncName = funcName;
        }
        packageInfo.addFunctionInfo(uniqueFuncName, functionInfo);
        this.readWorkerData(packageInfo, functionInfo);
        if (nativeFunc) {
            NativeCallableUnit nativeFunction = NativeUnitLoader.getInstance().loadNativeFunction(functionInfo.getPkgPath(), uniqueFuncName);
            if (nativeFunction == null) {
                throw new BLangRuntimeException("native function not available " + functionInfo.getPkgPath() + ":" + uniqueFuncName);
            }
            functionInfo.setNativeCallableUnit(nativeFunction);
        }
        this.readAttributeInfoEntries(packageInfo, packageInfo, functionInfo);
        WorkerSendInsAttributeInfo attributeInfo = (WorkerSendInsAttributeInfo)functionInfo.getAttributeInfo(AttributeInfo.Kind.WORKER_SEND_INS);
        functionInfo.workerSendInChannels = new CallableUnitInfo.ChannelDetails[attributeInfo.sendIns.length];
        if (functionInfo.workerSendInChannels.length == 0) {
            return;
        }
        String currentWorkerName = functionInfo.defaultWorkerInfo.getWorkerName();
        for (int i = 0; i < attributeInfo.sendIns.length; ++i) {
            String chnlName = attributeInfo.sendIns[i];
            functionInfo.workerSendInChannels[i] = new CallableUnitInfo.ChannelDetails(chnlName, currentWorkerName.equals("default"), this.isChannelSend(chnlName, currentWorkerName));
        }
    }

    private boolean isChannelSend(String chnlName, String workerName) {
        return chnlName.startsWith(workerName) && chnlName.split(workerName)[1].startsWith("->");
    }

    private void readWorkerData(PackageInfo packageInfo, CallableUnitInfo callableUnitInfo) throws IOException {
        int workerDataLength = this.dataInStream.readInt();
        if (workerDataLength == 0) {
            return;
        }
        int workerDataChannelsLength = this.dataInStream.readShort();
        for (int i = 0; i < workerDataChannelsLength; ++i) {
            this.readWorkerDataChannelEntries(packageInfo, callableUnitInfo);
        }
        this.readWorkerInfoEntries(packageInfo, callableUnitInfo);
    }

    private void updateAttachFunctionInfo(PackageInfo packageInfo, BType attachedType, String funcName, FunctionInfo functionInfo) throws IOException {
        BType[] paramTypes = (BType[])Stream.concat(Stream.of(functionInfo.attachedToType), Stream.of(functionInfo.getParamTypes())).toArray(BType[]::new);
        functionInfo.setParamTypes(paramTypes);
        if (attachedType.getTag() != 33 && attachedType.getTag() != 12) {
            return;
        }
        BStructureType structType = (BStructureType)attachedType;
        String objectInit = attachedType.getTag() == 33 ? "__init" : structType.getName() + ".<init>";
        StructureTypeInfo typeInfo = (StructureTypeInfo)structType.getTypeInfo();
        typeInfo.funcInfoEntries.put(funcName, functionInfo);
        if (objectInit.equals(funcName)) {
            typeInfo.initializer = functionInfo;
        }
    }

    public void readWorkerDataChannelEntries(PackageInfo packageInfo, CallableUnitInfo callableUnitInfo) throws IOException {
        int sourceCPIndex = this.dataInStream.readInt();
        int targetCPIndex = this.dataInStream.readInt();
        UTF8CPEntry sourceCPEntry = (UTF8CPEntry)packageInfo.getCPEntry(sourceCPIndex);
        UTF8CPEntry targetCPEntry = (UTF8CPEntry)packageInfo.getCPEntry(targetCPIndex);
        WorkerDataChannelInfo workerDataChannelInfo = new WorkerDataChannelInfo(sourceCPIndex, sourceCPEntry.getValue(), targetCPIndex, targetCPEntry.getValue());
        int dataChannelRefCPIndex = this.dataInStream.readInt();
        WorkerDataChannelRefCPEntry refCPEntry = (WorkerDataChannelRefCPEntry)packageInfo.getCPEntry(dataChannelRefCPIndex);
        refCPEntry.setWorkerDataChannelInfo(workerDataChannelInfo);
        callableUnitInfo.addWorkerDataChannelInfo(workerDataChannelInfo);
    }

    private void setCallableUnitSignature(PackageInfo packageInfo, CallableUnitInfo callableUnitInfo, String sig) {
        callableUnitInfo.funcType = this.getFunctionType(packageInfo, sig);
        callableUnitInfo.setParamTypes(callableUnitInfo.funcType.paramTypes);
        callableUnitInfo.setRetParamTypes(callableUnitInfo.funcType.retParamTypes);
    }

    private BFunctionType getFunctionType(PackageInfo packageInfo, String sig) {
        char[] chars = sig.toCharArray();
        Stack typeStack = new Stack();
        this.typeSigReader.createFunctionType((TypeCreator)new RuntimeTypeCreator(packageInfo), chars, 0, typeStack);
        return (BFunctionType)typeStack.pop();
    }

    private BType[] getParamTypes(PackageInfo packageInfo, String signature) {
        int index = 0;
        Stack typeStack = new Stack();
        char[] chars = signature.toCharArray();
        while (index < chars.length) {
            index = this.typeSigReader.createBTypeFromSig((TypeCreator)new RuntimeTypeCreator(packageInfo), chars, index, typeStack);
        }
        return typeStack.toArray(new BType[0]);
    }

    private void readWorkerInfoEntries(PackageInfo packageInfo, CallableUnitInfo callableUnitInfo) throws IOException {
        short workerCount = this.dataInStream.readShort();
        WorkerInfo defaultWorker = this.getWorkerInfo(packageInfo);
        callableUnitInfo.setDefaultWorkerInfo(defaultWorker);
        for (int i = 0; i < workerCount - 1; ++i) {
            WorkerInfo workerInfo = this.getWorkerInfo(packageInfo);
            callableUnitInfo.addWorkerInfo(workerInfo.getWorkerName(), workerInfo);
        }
    }

    private WorkerInfo getWorkerInfo(PackageInfo packageInfo) throws IOException {
        int workerNameCPIndex = this.dataInStream.readInt();
        UTF8CPEntry workerNameUTF8Entry = (UTF8CPEntry)packageInfo.getCPEntry(workerNameCPIndex);
        WorkerInfo workerInfo = new WorkerInfo(workerNameCPIndex, workerNameUTF8Entry.getValue());
        int wrkrDtChnlRefCPIndex = this.dataInStream.readInt();
        workerInfo.setWrkrDtChnlRefCPIndex(wrkrDtChnlRefCPIndex);
        if (wrkrDtChnlRefCPIndex >= 0) {
            WorkerDataChannelRefCPEntry refCPEntry = (WorkerDataChannelRefCPEntry)packageInfo.getCPEntry(wrkrDtChnlRefCPIndex);
            workerInfo.setWorkerDataChannelInfoForForkJoin(refCPEntry.getWorkerDataChannelInfo());
        }
        this.readForkJoinInfo(packageInfo, workerInfo);
        this.readAttributeInfoEntries(packageInfo, packageInfo, workerInfo);
        CodeAttributeInfo codeAttribute = (CodeAttributeInfo)workerInfo.getAttributeInfo(AttributeInfo.Kind.CODE_ATTRIBUTE);
        workerInfo.setCodeAttributeInfo(codeAttribute);
        return workerInfo;
    }

    private void readForkJoinInfo(PackageInfo packageInfo, WorkerInfo workerInfo) throws IOException {
        int forkJoinCount = this.dataInStream.readShort();
        ForkjoinInfo[] forkjoinInfos = new ForkjoinInfo[forkJoinCount];
        for (int i = 0; i < forkJoinCount; ++i) {
            ForkjoinInfo forkjoinInfo;
            forkjoinInfos[i] = forkjoinInfo = this.getForkJoinInfo(packageInfo);
        }
        workerInfo.setForkjoinInfos(forkjoinInfos);
    }

    private ForkjoinInfo getForkJoinInfo(PackageInfo packageInfo) throws IOException {
        int indexCPIndex = this.dataInStream.readInt();
        int argRegLength = this.dataInStream.readShort();
        int[] argRegs = new int[argRegLength];
        for (int i = 0; i < argRegLength; ++i) {
            argRegs[i] = this.dataInStream.readInt();
        }
        ForkJoinCPEntry forkJoinCPEntry = (ForkJoinCPEntry)packageInfo.getCPEntry(indexCPIndex);
        ForkjoinInfo forkjoinInfo = new ForkjoinInfo(argRegs);
        forkjoinInfo.setIndex(forkJoinCPEntry.getForkJoinCPIndex());
        forkjoinInfo.setIndexCPIndex(indexCPIndex);
        int workerCount = this.dataInStream.readShort();
        for (int i = 0; i < workerCount; ++i) {
            WorkerInfo workerInfo = this.getWorkerInfo(packageInfo);
            forkjoinInfo.addWorkerInfo(workerInfo.getWorkerName(), workerInfo);
        }
        boolean isTimeoutAvailable = this.dataInStream.readBoolean();
        forkjoinInfo.setTimeoutAvailable(isTimeoutAvailable);
        int joinTypeCPIndex = this.dataInStream.readInt();
        UTF8CPEntry joinTypeCPEntry = (UTF8CPEntry)packageInfo.getCPEntry(joinTypeCPIndex);
        forkjoinInfo.setJoinType(joinTypeCPEntry.getValue());
        forkjoinInfo.setJoinTypeCPIndex(joinTypeCPIndex);
        int joinWorkerCount = this.dataInStream.readInt();
        forkjoinInfo.setWorkerCount(joinWorkerCount);
        int joinWrkrCPIndexesLen = this.dataInStream.readShort();
        int[] joinWrkrCPIndexes = new int[joinWrkrCPIndexesLen];
        String[] joinWrkrNames = new String[joinWrkrCPIndexesLen];
        for (int i = 0; i < joinWrkrCPIndexesLen; ++i) {
            int cpIndex = this.dataInStream.readInt();
            UTF8CPEntry workerNameCPEntry = (UTF8CPEntry)packageInfo.getCPEntry(cpIndex);
            joinWrkrCPIndexes[i] = cpIndex;
            joinWrkrNames[i] = workerNameCPEntry.getValue();
        }
        forkjoinInfo.setJoinWrkrNameIndexes(joinWrkrCPIndexes);
        forkjoinInfo.setJoinWorkerNames(joinWrkrNames);
        forkJoinCPEntry.setForkjoinInfo(forkjoinInfo);
        return forkjoinInfo;
    }

    public void readAttributeInfoEntries(PackageInfo packageInfo, ConstantPool constantPool, AttributeInfoPool attributeInfoPool) throws IOException {
        int attributesCount = this.dataInStream.readShort();
        for (int k = 0; k < attributesCount; ++k) {
            AttributeInfo attributeInfo = this.getAttributeInfo(packageInfo, constantPool);
            if (attributeInfo == null) continue;
            attributeInfoPool.addAttributeInfo(attributeInfo.getKind(), attributeInfo);
        }
    }

    private AttributeInfo getAttributeInfo(PackageInfo packageInfo, ConstantPool constantPool) throws IOException {
        int attribNameCPIndex = this.dataInStream.readInt();
        UTF8CPEntry attribNameCPEntry = (UTF8CPEntry)constantPool.getCPEntry(attribNameCPIndex);
        AttributeInfo.Kind attribKind = AttributeInfo.Kind.fromString(attribNameCPEntry.getValue());
        if (attribKind == null) {
            throw new ProgramFileFormatException("unknown attribute kind " + attribNameCPEntry.getValue());
        }
        this.dataInStream.readInt();
        switch (attribKind) {
            case CODE_ATTRIBUTE: {
                CodeAttributeInfo codeAttributeInfo = new CodeAttributeInfo();
                codeAttributeInfo.setAttributeNameIndex(attribNameCPIndex);
                codeAttributeInfo.setCodeAddrs(this.dataInStream.readInt());
                codeAttributeInfo.setMaxLongLocalVars(this.dataInStream.readUnsignedShort());
                codeAttributeInfo.setMaxDoubleLocalVars(this.dataInStream.readShort());
                codeAttributeInfo.setMaxStringLocalVars(this.dataInStream.readShort());
                codeAttributeInfo.setMaxIntLocalVars(this.dataInStream.readShort());
                codeAttributeInfo.setMaxRefLocalVars(this.dataInStream.readShort());
                codeAttributeInfo.setMaxLongRegs(this.dataInStream.readShort());
                codeAttributeInfo.setMaxDoubleRegs(this.dataInStream.readShort());
                codeAttributeInfo.setMaxStringRegs(this.dataInStream.readShort());
                codeAttributeInfo.setMaxIntRegs(this.dataInStream.readShort());
                codeAttributeInfo.setMaxRefRegs(this.dataInStream.readShort());
                return codeAttributeInfo;
            }
            case VARIABLE_TYPE_COUNT_ATTRIBUTE: {
                VarTypeCountAttributeInfo varCountAttributeInfo = new VarTypeCountAttributeInfo(attribNameCPIndex);
                varCountAttributeInfo.setMaxLongVars(this.dataInStream.readShort());
                varCountAttributeInfo.setMaxDoubleVars(this.dataInStream.readShort());
                varCountAttributeInfo.setMaxStringVars(this.dataInStream.readShort());
                varCountAttributeInfo.setMaxIntVars(this.dataInStream.readShort());
                varCountAttributeInfo.setMaxRefVars(this.dataInStream.readShort());
                return varCountAttributeInfo;
            }
            case ERROR_TABLE: {
                ErrorTableAttributeInfo tableAttributeInfo = new ErrorTableAttributeInfo(attribNameCPIndex);
                int tableEntryCount = this.dataInStream.readShort();
                for (int i = 0; i < tableEntryCount; ++i) {
                    int ipFrom = this.dataInStream.readInt();
                    int ipTo = this.dataInStream.readInt();
                    int ipTarget = this.dataInStream.readInt();
                    int regIndex = this.dataInStream.readInt();
                    ErrorTableEntry tableEntry = new ErrorTableEntry(ipFrom, ipTo, ipTarget, regIndex);
                    tableAttributeInfo.addErrorTableEntry(tableEntry);
                }
                return tableAttributeInfo;
            }
            case LOCAL_VARIABLES_ATTRIBUTE: {
                LocalVariableAttributeInfo localVarAttrInfo = new LocalVariableAttributeInfo(attribNameCPIndex);
                int localVarInfoCount = this.dataInStream.readShort();
                for (int i = 0; i < localVarInfoCount; ++i) {
                    LocalVariableInfo localVariableInfo = this.getLocalVariableInfo(packageInfo, constantPool);
                    localVarAttrInfo.addLocalVarInfo(localVariableInfo);
                }
                return localVarAttrInfo;
            }
            case WORKER_SEND_INS: {
                WorkerSendInsAttributeInfo workerSendInsAttrInfo = new WorkerSendInsAttributeInfo(attribNameCPIndex);
                int sendInsCount = this.dataInStream.readShort();
                workerSendInsAttrInfo.sendIns = new String[sendInsCount];
                for (int i = 0; i < sendInsCount; ++i) {
                    UTF8CPEntry stringCPEntry = (UTF8CPEntry)constantPool.getCPEntry(this.dataInStream.readInt());
                    workerSendInsAttrInfo.sendIns[i] = stringCPEntry.getValue();
                }
                return workerSendInsAttrInfo;
            }
            case LINE_NUMBER_TABLE_ATTRIBUTE: {
                LineNumberTableAttributeInfo lnNoTblAttrInfo = new LineNumberTableAttributeInfo(attribNameCPIndex);
                int lineNoInfoCount = this.dataInStream.readInt();
                for (int i = 0; i < lineNoInfoCount; ++i) {
                    LineNumberInfo lineNumberInfo = this.getLineNumberInfo(constantPool);
                    lnNoTblAttrInfo.addLineNumberInfo(lineNumberInfo);
                }
                return lnNoTblAttrInfo;
            }
            case DEFAULT_VALUE_ATTRIBUTE: {
                DefaultValue defaultValue = this.getDefaultValue(constantPool);
                DefaultValueAttributeInfo defaultValAttrInfo = new DefaultValueAttributeInfo(attribNameCPIndex, defaultValue);
                return defaultValAttrInfo;
            }
            case DOCUMENT_ATTACHMENT_ATTRIBUTE: {
                return this.getDocumentAttachmentAttribute(constantPool, attribNameCPIndex);
            }
            case PARAMETER_DEFAULTS_ATTRIBUTE: {
                ParamDefaultValueAttributeInfo paramDefaultValAttrInfo = new ParamDefaultValueAttributeInfo(attribNameCPIndex);
                int paramDefaultsInfoCount = this.dataInStream.readShort();
                for (int i = 0; i < paramDefaultsInfoCount; ++i) {
                    DefaultValue paramDefaultValue = this.getDefaultValue(constantPool);
                    paramDefaultValAttrInfo.addParamDefaultValueInfo(paramDefaultValue);
                }
                return paramDefaultValAttrInfo;
            }
            case PARAMETERS_ATTRIBUTE: {
                ParameterAttributeInfo parameterAttributeInfo = new ParameterAttributeInfo(attribNameCPIndex);
                parameterAttributeInfo.requiredParamsCount = this.dataInStream.readInt();
                parameterAttributeInfo.defaultableParamsCount = this.dataInStream.readInt();
                parameterAttributeInfo.restParamCount = this.dataInStream.readInt();
                return parameterAttributeInfo;
            }
            case TAINT_TABLE: {
                TaintTableAttributeInfo taintTableAttributeInfo = new TaintTableAttributeInfo(attribNameCPIndex);
                taintTableAttributeInfo.rowCount = this.dataInStream.readShort();
                taintTableAttributeInfo.columnCount = this.dataInStream.readShort();
                for (int rowIndex = 0; rowIndex < taintTableAttributeInfo.rowCount; ++rowIndex) {
                    short paramIndex = this.dataInStream.readShort();
                    ArrayList<Boolean> taintRecord = new ArrayList<Boolean>();
                    for (int columnIndex = 0; columnIndex < taintTableAttributeInfo.columnCount; ++columnIndex) {
                        taintRecord.add(this.dataInStream.readBoolean());
                    }
                    taintTableAttributeInfo.taintTable.put(Integer.valueOf(paramIndex), taintRecord);
                }
                return taintTableAttributeInfo;
            }
        }
        throw new ProgramFileFormatException("unsupported attribute kind " + attribNameCPEntry.getValue());
    }

    private AttributeInfo getDocumentAttachmentAttribute(ConstantPool constantPool, int attribNameCPIndex) throws IOException {
        int descCPIndex = this.dataInStream.readInt();
        String docDesc = this.getUTF8EntryValue(descCPIndex, constantPool);
        DocumentationAttributeInfo docAttrInfo = new DocumentationAttributeInfo(attribNameCPIndex, descCPIndex, docDesc);
        int noOfParamInfoEntries = this.dataInStream.readShort();
        for (int i = 0; i < noOfParamInfoEntries; ++i) {
            int nameCPIndex = this.dataInStream.readInt();
            String name = this.getUTF8EntryValue(nameCPIndex, constantPool);
            int paramDescCPIndex = this.dataInStream.readInt();
            String paramDesc = this.getUTF8EntryValue(paramDescCPIndex, constantPool);
            DocumentationAttributeInfo.ParameterDocumentInfo paramDocInfo = new DocumentationAttributeInfo.ParameterDocumentInfo(nameCPIndex, name, paramDescCPIndex, paramDesc);
            docAttrInfo.paramDocInfoList.add(paramDocInfo);
        }
        boolean isReturnDocDescriptionAvailable = this.dataInStream.readBoolean();
        if (isReturnDocDescriptionAvailable) {
            int returnParamDescCPIndex = this.dataInStream.readInt();
            docAttrInfo.returnParameterDescription = this.getUTF8EntryValue(returnParamDescCPIndex, constantPool);
        }
        return docAttrInfo;
    }

    private LocalVariableInfo getLocalVariableInfo(PackageInfo packageInfo, ConstantPool constantPool) throws IOException {
        int varNameCPIndex = this.dataInStream.readInt();
        UTF8CPEntry varNameCPEntry = (UTF8CPEntry)constantPool.getCPEntry(varNameCPIndex);
        int variableIndex = this.dataInStream.readInt();
        int typeSigCPIndex = this.dataInStream.readInt();
        int scopeStartLineNumber = this.dataInStream.readInt();
        int scopeEndLineNumber = this.dataInStream.readInt();
        boolean isIdentifierLiteral = this.dataInStream.readBoolean();
        UTF8CPEntry typeSigCPEntry = (UTF8CPEntry)constantPool.getCPEntry(typeSigCPIndex);
        BType type = this.getBTypeFromDescriptor(packageInfo, typeSigCPEntry.getValue());
        LocalVariableInfo localVariableInfo = new LocalVariableInfo(varNameCPEntry.getValue(), varNameCPIndex, variableIndex, typeSigCPIndex, type, scopeStartLineNumber, scopeEndLineNumber, isIdentifierLiteral);
        int attchmntIndexesLength = this.dataInStream.readShort();
        int[] attachmentIndexes = new int[attchmntIndexesLength];
        for (int i = 0; i < attchmntIndexesLength; ++i) {
            attachmentIndexes[i] = this.dataInStream.readInt();
        }
        localVariableInfo.setAttachmentIndexes(attachmentIndexes);
        return localVariableInfo;
    }

    private LineNumberInfo getLineNumberInfo(ConstantPool constantPool) throws IOException {
        int lineNumber = this.dataInStream.readInt();
        int fileNameCPIndex = this.dataInStream.readInt();
        int ip = this.dataInStream.readInt();
        UTF8CPEntry fileNameCPEntry = (UTF8CPEntry)constantPool.getCPEntry(fileNameCPIndex);
        LineNumberInfo lineNumberInfo = new LineNumberInfo(lineNumber, fileNameCPIndex, fileNameCPEntry.getValue(), ip);
        lineNumberInfo.setPackageInfo((PackageInfo)constantPool);
        return lineNumberInfo;
    }

    private void readInstructions(PackageInfo packageInfo) throws IOException {
        int codeLength = this.dataInStream.readInt();
        byte[] code = new byte[codeLength];
        this.dataInStream.read(code);
        DataInputStream codeStream = new DataInputStream(new ByteArrayInputStream(code));
        block27: while (codeStream.available() > 0) {
            int opcode = codeStream.readUnsignedByte();
            switch (opcode) {
                case 117: 
                case 219: {
                    packageInfo.addInstruction(InstructionFactory.get(opcode, new int[0]));
                    continue block27;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 60: 
                case 116: 
                case 234: {
                    int i = codeStream.readInt();
                    packageInfo.addInstruction(InstructionFactory.get(opcode, i));
                    continue block27;
                }
                case 122: 
                case 123: {
                    this.readFunctionPointerLoadInstruction(packageInfo, codeStream, opcode);
                    continue block27;
                }
                case 1: 
                case 2: 
                case 3: 
                case 20: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 150: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 177: 
                case 190: 
                case 200: 
                case 201: 
                case 207: 
                case 208: 
                case 209: 
                case 211: 
                case 220: 
                case 221: 
                case 227: 
                case 228: 
                case 230: 
                case 233: 
                case 236: {
                    int i = codeStream.readInt();
                    int j = codeStream.readInt();
                    packageInfo.addInstruction(InstructionFactory.get(opcode, i, j));
                    continue block27;
                }
                case 213: 
                case 214: 
                case 215: 
                case 216: 
                case 217: 
                case 218: {
                    int j = codeStream.readInt();
                    packageInfo.addInstruction(InstructionFactory.get(opcode, j));
                    continue block27;
                }
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 42: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 58: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 147: 
                case 148: 
                case 149: 
                case 151: 
                case 152: 
                case 153: 
                case 154: 
                case 159: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 186: 
                case 187: 
                case 188: 
                case 189: 
                case 191: 
                case 192: 
                case 193: 
                case 194: 
                case 195: 
                case 196: 
                case 197: 
                case 203: 
                case 206: 
                case 210: 
                case 212: 
                case 222: 
                case 223: 
                case 224: 
                case 229: 
                case 231: 
                case 232: 
                case 235: 
                case 237: 
                case 238: {
                    int i = codeStream.readInt();
                    int j = codeStream.readInt();
                    int k = codeStream.readInt();
                    packageInfo.addInstruction(InstructionFactory.get(opcode, i, j, k));
                    continue block27;
                }
                case 118: {
                    int i = codeStream.readInt();
                    int j = codeStream.readInt();
                    int k = codeStream.readInt();
                    packageInfo.addInstruction(new Instruction.InstructionTrRetry(opcode, i, j, k));
                    continue block27;
                }
                case 41: 
                case 59: 
                case 225: 
                case 226: {
                    int i = codeStream.readInt();
                    int j = codeStream.readInt();
                    int k = codeStream.readInt();
                    int h = codeStream.readInt();
                    packageInfo.addInstruction(InstructionFactory.get(opcode, i, j, k, h));
                    continue block27;
                }
                case 181: {
                    int i = codeStream.readInt();
                    int j = codeStream.readInt();
                    int k = codeStream.readInt();
                    int h = codeStream.readInt();
                    packageInfo.addInstruction(new Instruction.InstructionTrEnd(opcode, i, j, k, h));
                    continue block27;
                }
                case 180: {
                    int i = codeStream.readInt();
                    int j = codeStream.readInt();
                    int k = codeStream.readInt();
                    int h = codeStream.readInt();
                    int l = codeStream.readInt();
                    packageInfo.addInstruction(new Instruction.InstructionTrBegin(opcode, i, j, k, h, l));
                    continue block27;
                }
                case 202: {
                    int i = codeStream.readInt();
                    int j = codeStream.readInt();
                    int k = codeStream.readInt();
                    int h = codeStream.readInt();
                    int l = codeStream.readInt();
                    packageInfo.addInstruction(InstructionFactory.get(opcode, i, j, k, h, l));
                    continue block27;
                }
                case 185: {
                    int c = codeStream.readInt();
                    int[] ops = new int[c + 3];
                    ops[0] = c;
                    ops[1] = codeStream.readInt();
                    ops[2] = codeStream.readInt();
                    for (int p = 0; p < c; ++p) {
                        ops[p + 3] = codeStream.readInt();
                    }
                    packageInfo.addInstruction(InstructionFactory.get(opcode, ops));
                    continue block27;
                }
                case 199: {
                    int d = codeStream.readInt();
                    int[] oprds = new int[d + 3];
                    oprds[0] = d;
                    oprds[1] = codeStream.readInt();
                    oprds[2] = codeStream.readInt();
                    for (int p = 0; p < d; ++p) {
                        oprds[p + 3] = codeStream.readInt();
                    }
                    packageInfo.addInstruction(InstructionFactory.get(opcode, oprds));
                    continue block27;
                }
                case 198: {
                    int retReg = codeStream.readInt();
                    int workerCount = codeStream.readInt();
                    String[] workerList = new String[workerCount];
                    for (int wrkCount = 0; wrkCount < workerCount; ++wrkCount) {
                        int channelRefCPIndex = codeStream.readInt();
                        WorkerDataChannelRefCPEntry channelRefCPEntry = (WorkerDataChannelRefCPEntry)packageInfo.getCPEntry(channelRefCPIndex);
                        workerList[wrkCount] = channelRefCPEntry.getWorkerDataChannelInfo().getChannelName();
                    }
                    packageInfo.addInstruction(new Instruction.InstructionFlush(opcode, retReg, workerList));
                    continue block27;
                }
                case 184: {
                    int syncChannelRefCPIndex = codeStream.readInt();
                    WorkerDataChannelRefCPEntry syncChannelRefCPEntry = (WorkerDataChannelRefCPEntry)packageInfo.getCPEntry(syncChannelRefCPIndex);
                    int syncSigCPIndex = codeStream.readInt();
                    UTF8CPEntry syncSigCPEntry = (UTF8CPEntry)packageInfo.getCPEntry(syncSigCPIndex);
                    BType syncSendType = this.getParamTypes(packageInfo, syncSigCPEntry.getValue())[0];
                    int exprIndex = codeStream.readInt();
                    int syncSendIndex = codeStream.readInt();
                    WorkerDataChannelInfo syncChannelInfo = syncChannelRefCPEntry.getWorkerDataChannelInfo();
                    boolean channelSendInSameStrand = syncChannelInfo.getSource().equals("default");
                    packageInfo.addInstruction(new Instruction.InstructionWRKSyncSend(opcode, syncChannelRefCPIndex, syncChannelInfo, syncSigCPIndex, syncSendType, exprIndex, syncSendIndex, channelSendInSameStrand));
                    continue block27;
                }
                case 21: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    int pkgRefCPIndex = codeStream.readInt();
                    int i = codeStream.readInt();
                    int j = codeStream.readInt();
                    PackageRefCPEntry pkgRefCPEntry = (PackageRefCPEntry)packageInfo.getCPEntry(pkgRefCPIndex);
                    packageInfo.addInstruction(InstructionFactory.get(opcode, pkgRefCPEntry.getPackageInfo().pkgIndex, i, j));
                    continue block27;
                }
                case 119: {
                    int funcRefCPIndex = codeStream.readInt();
                    int flags = codeStream.readInt();
                    FunctionRefCPEntry funcRefCPEntry = (FunctionRefCPEntry)packageInfo.getCPEntry(funcRefCPIndex);
                    packageInfo.addInstruction(new Instruction.InstructionCALL(opcode, funcRefCPIndex, funcRefCPEntry.getFunctionInfo(), flags, this.getArgRegs(codeStream), this.getArgRegs(codeStream)));
                    continue block27;
                }
                case 120: {
                    int receiverRegIndex = codeStream.readInt();
                    int funcRefCPIndex = codeStream.readInt();
                    int flags = codeStream.readInt();
                    FunctionRefCPEntry funcRefCPEntry = (FunctionRefCPEntry)packageInfo.getCPEntry(funcRefCPIndex);
                    packageInfo.addInstruction(new Instruction.InstructionVCALL(opcode, receiverRegIndex, funcRefCPIndex, funcRefCPEntry.getFunctionInfo(), flags, this.getArgRegs(codeStream), this.getArgRegs(codeStream)));
                    continue block27;
                }
                case 121: {
                    int funcRefCPIndex = codeStream.readInt();
                    int flags = codeStream.readInt();
                    int[] argRegs = this.getArgRegs(codeStream);
                    int[] retRegs = this.getArgRegs(codeStream);
                    FunctionCallCPEntry funcCallCPEntry = new FunctionCallCPEntry(flags, argRegs, retRegs);
                    int funcCallCPIndex = packageInfo.addCPEntry(funcCallCPEntry);
                    packageInfo.addInstruction(InstructionFactory.get(opcode, funcRefCPIndex, funcCallCPIndex));
                    continue block27;
                }
                case 182: 
                case 183: {
                    int channelRefCPIndex = codeStream.readInt();
                    WorkerDataChannelRefCPEntry channelRefCPEntry = (WorkerDataChannelRefCPEntry)packageInfo.getCPEntry(channelRefCPIndex);
                    int sigCPIndex = codeStream.readInt();
                    UTF8CPEntry sigCPEntry = (UTF8CPEntry)packageInfo.getCPEntry(sigCPIndex);
                    BType bType = this.getParamTypes(packageInfo, sigCPEntry.getValue())[0];
                    WorkerDataChannelInfo dataChannelInfo = channelRefCPEntry.getWorkerDataChannelInfo();
                    boolean channelInSameStrand = opcode == 182 ? dataChannelInfo.getSource().equals("default") : dataChannelInfo.getTarget().equals("default");
                    packageInfo.addInstruction(new Instruction.InstructionWRKSendReceive(opcode, channelRefCPIndex, dataChannelInfo, sigCPIndex, bType, codeStream.readInt(), channelInSameStrand));
                    continue block27;
                }
                case 39: {
                    BType keyType = null;
                    int keyIndex = -1;
                    int hasKey = codeStream.readInt();
                    if (hasKey == 1) {
                        UTF8CPEntry keySigCPEntry = (UTF8CPEntry)packageInfo.getCPEntry(codeStream.readInt());
                        keyType = this.getParamTypes(packageInfo, keySigCPEntry.getValue())[0];
                        keyIndex = codeStream.readInt();
                    }
                    String channelName = ((UTF8CPEntry)packageInfo.getCPEntry(codeStream.readInt())).getValue();
                    UTF8CPEntry receiverSigCPEntry = (UTF8CPEntry)packageInfo.getCPEntry(codeStream.readInt());
                    BType chnReceiveType = this.getParamTypes(packageInfo, receiverSigCPEntry.getValue())[0];
                    int receiverIndex = codeStream.readInt();
                    packageInfo.addInstruction(new Instruction.InstructionCHNReceive(opcode, channelName, chnReceiveType, receiverIndex, keyType, keyIndex));
                    continue block27;
                }
                case 40: {
                    BType keyType = null;
                    int keyIndex = -1;
                    int hasKey = codeStream.readInt();
                    if (hasKey == 1) {
                        keyIndex = codeStream.readInt();
                        UTF8CPEntry keySigCPEntry = (UTF8CPEntry)packageInfo.getCPEntry(codeStream.readInt());
                        keyType = this.getParamTypes(packageInfo, keySigCPEntry.getValue())[0];
                    }
                    String chnName = ((UTF8CPEntry)packageInfo.getCPEntry(codeStream.readInt())).getValue();
                    int dataIndex = codeStream.readInt();
                    UTF8CPEntry dataSigCPEntry = (UTF8CPEntry)packageInfo.getCPEntry(codeStream.readInt());
                    BType dataType = this.getParamTypes(packageInfo, dataSigCPEntry.getValue())[0];
                    packageInfo.addInstruction(new Instruction.InstructionCHNSend(opcode, chnName, dataType, dataIndex, keyType, keyIndex));
                    continue block27;
                }
                case 205: {
                    int iteratorIndex = codeStream.readInt();
                    int[] typeTags = this.getArgRegs(codeStream);
                    int[] retRegs = this.getArgRegs(codeStream);
                    int constraintTypeSigCPIndex = codeStream.readInt();
                    TypeRefCPEntry constraintTypeRefCPEntry = (TypeRefCPEntry)packageInfo.getCPEntry(constraintTypeSigCPIndex);
                    BType constraintType = constraintTypeRefCPEntry.getType();
                    packageInfo.addInstruction(new Instruction.InstructionIteratorNext(opcode, iteratorIndex, retRegs.length, typeTags, retRegs, constraintType));
                    continue block27;
                }
                case 178: {
                    PackageRefCPEntry pkgRefCPEntry;
                    int pkgRefCPIndex;
                    int varCount = codeStream.readInt();
                    int fieldCount = codeStream.readInt();
                    BType[] varTypes = new BType[varCount];
                    int[] pkgRefs = new int[varCount + fieldCount];
                    int[] varRegs = new int[varCount + fieldCount];
                    int[] fieldRegs = new int[fieldCount];
                    for (int m = 0; m < varCount; ++m) {
                        int varSigCPIndex = codeStream.readInt();
                        TypeRefCPEntry typeRefCPEntry = (TypeRefCPEntry)packageInfo.getCPEntry(varSigCPIndex);
                        varTypes[m] = typeRefCPEntry.getType();
                        pkgRefCPIndex = codeStream.readInt();
                        pkgRefCPEntry = (PackageRefCPEntry)packageInfo.getCPEntry(pkgRefCPIndex);
                        pkgRefs[m] = pkgRefCPEntry.getPackageInfo().pkgIndex;
                        varRegs[m] = codeStream.readInt();
                    }
                    String uuid = ((UTF8CPEntry)packageInfo.getCPEntry(codeStream.readInt())).getValue();
                    for (int n = 0; n < fieldCount; ++n) {
                        pkgRefCPIndex = codeStream.readInt();
                        pkgRefCPEntry = (PackageRefCPEntry)packageInfo.getCPEntry(pkgRefCPIndex);
                        pkgRefs[varCount + n] = pkgRefCPEntry.getPackageInfo().pkgIndex;
                        varRegs[varCount + n] = codeStream.readInt();
                        fieldRegs[n] = codeStream.readInt();
                    }
                    packageInfo.addInstruction(new Instruction.InstructionLock(opcode, varTypes, pkgRefs, varRegs, fieldRegs, varCount, uuid));
                    continue block27;
                }
                case 179: {
                    PackageRefCPEntry pkgRefCPEntry;
                    int pkgRefCPIndex;
                    int globalVarCount = codeStream.readInt();
                    boolean hasFieldVar = codeStream.readInt() > 0;
                    String lockUuid = ((UTF8CPEntry)packageInfo.getCPEntry(codeStream.readInt())).getValue();
                    BType[] globalVarTypes = new BType[globalVarCount];
                    int[] lockPkgRefs = new int[globalVarCount];
                    int[] globalVarRegs = new int[globalVarCount];
                    for (int m = 0; m < globalVarCount; ++m) {
                        int varSigCPIndex = codeStream.readInt();
                        TypeRefCPEntry typeRefCPEntry = (TypeRefCPEntry)packageInfo.getCPEntry(varSigCPIndex);
                        globalVarTypes[m] = typeRefCPEntry.getType();
                        pkgRefCPIndex = codeStream.readInt();
                        pkgRefCPEntry = (PackageRefCPEntry)packageInfo.getCPEntry(pkgRefCPIndex);
                        lockPkgRefs[m] = pkgRefCPEntry.getPackageInfo().pkgIndex;
                        globalVarRegs[m] = codeStream.readInt();
                    }
                    packageInfo.addInstruction(new Instruction.InstructionUnLock(opcode, globalVarTypes, lockPkgRefs, globalVarRegs, globalVarCount, lockUuid, hasFieldVar));
                    continue block27;
                }
            }
            throw new ProgramFileFormatException("unknown opcode " + opcode + " in module " + packageInfo.getPkgPath());
        }
    }

    private void readFunctionPointerLoadInstruction(PackageInfo packageInfo, DataInputStream codeStream, int opcode) throws IOException {
        packageInfo.addInstruction(InstructionFactory.get(opcode, this.getFunctionPointerLoadOperands(codeStream)));
    }

    private int[] getFunctionPointerLoadOperands(DataInputStream codeStream) throws IOException {
        int[] operands;
        int h = codeStream.readInt();
        int i = codeStream.readInt();
        int j = codeStream.readInt();
        int k = codeStream.readInt();
        if (k == 0) {
            operands = new int[]{h, i, j, k};
        } else {
            operands = new int[4 + k];
            operands[0] = h;
            operands[1] = i;
            operands[2] = j;
            operands[3] = k;
            for (int x = 0; x < k; ++x) {
                operands[x + 4] = codeStream.readInt();
            }
        }
        return operands;
    }

    void resolveCPEntries(PackageInfo currentPackageInfo) {
        for (ConstantPoolEntry cpEntry : this.unresolvedCPEntries) {
            switch (cpEntry.getEntryType()) {
                case CP_ENTRY_PACKAGE: {
                    PackageRefCPEntry pkgRefCPEntry = (PackageRefCPEntry)cpEntry;
                    PackageInfo packageInfo = this.getPackageInfo(pkgRefCPEntry.getPackageName());
                    pkgRefCPEntry.setPackageInfo(packageInfo);
                    break;
                }
                case CP_ENTRY_FUNCTION_REF: {
                    FunctionRefCPEntry funcRefCPEntry = (FunctionRefCPEntry)cpEntry;
                    PackageInfo packageInfo = this.getPackageInfo(funcRefCPEntry.getPackagePath());
                    FunctionInfo functionInfo = packageInfo.getFunctionInfo(funcRefCPEntry.getFunctionName());
                    funcRefCPEntry.setFunctionInfo(functionInfo);
                    break;
                }
                case CP_ENTRY_STRUCTURE_REF: {
                    StructureRefCPEntry structureRefCPEntry = (StructureRefCPEntry)cpEntry;
                    PackageInfo packageInfo = this.getPackageInfo(structureRefCPEntry.getPackagePath());
                    CustomTypeInfo structureTypeInfo = packageInfo.getStructureTypeInfo(structureRefCPEntry.getStructureName());
                    structureRefCPEntry.setStructureTypeInfo(structureTypeInfo);
                    break;
                }
                case CP_ENTRY_TYPE_REF: {
                    TypeRefCPEntry typeRefCPEntry = (TypeRefCPEntry)cpEntry;
                    String typeSig = typeRefCPEntry.getTypeSig();
                    BType bType = this.getBTypeFromDescriptor(currentPackageInfo, typeSig);
                    typeRefCPEntry.setType(bType);
                    break;
                }
            }
        }
    }

    private void resolveUserDefinedTypes(PackageInfo packageInfo) {
        TypeDefInfo[] structInfoEntries = packageInfo.getTypeDefInfoEntries();
        for (TypeDefInfo structInfo : structInfoEntries) {
            if (structInfo.typeTag == 32) continue;
            if (structInfo.typeTag == 27) {
                this.resolveErrorType(packageInfo, (ErrorTypeInfo)structInfo.typeInfo);
                continue;
            }
            StructureTypeInfo structureTypeInfo = (StructureTypeInfo)structInfo.typeInfo;
            StructFieldInfo[] fieldInfoEntries = structureTypeInfo.getFieldInfoEntries();
            BStructureType structType = structureTypeInfo.getType();
            LinkedHashMap<String, BField> structFields = new LinkedHashMap<String, BField>();
            for (int i = 0; i < fieldInfoEntries.length; ++i) {
                StructFieldInfo fieldInfo = fieldInfoEntries[i];
                String typeDesc = fieldInfo.getTypeDescriptor();
                BType fieldType = this.getBTypeFromDescriptor(packageInfo, typeDesc);
                fieldInfo.setFieldType(fieldType);
                BField structField = new BField(fieldType, fieldInfo.getName(), fieldInfo.flags);
                structFields.put(structField.fieldName, structField);
            }
            if (structType.getTag() == 12 && !((BRecordType)structType).sealed) {
                BType restFieldType;
                RecordTypeInfo recTypeInfo = (RecordTypeInfo)structureTypeInfo;
                String restTypeDesc = recTypeInfo.getRestFieldTypeSignature();
                recTypeInfo.getType().restFieldType = restFieldType = this.getBTypeFromDescriptor(packageInfo, restTypeDesc);
            }
            VarTypeCountAttributeInfo attributeInfo = (VarTypeCountAttributeInfo)structInfo.typeInfo.getAttributeInfo(AttributeInfo.Kind.VARIABLE_TYPE_COUNT_ATTRIBUTE);
            structType.setFieldTypeCount(attributeInfo.getVarTypeCount());
            structType.setFields(structFields);
        }
        for (ConstantPoolEntry cpEntry : this.unresolvedCPEntries) {
            switch (cpEntry.getEntryType()) {
                case CP_ENTRY_TYPE_REF: {
                    TypeRefCPEntry typeRefCPEntry = (TypeRefCPEntry)cpEntry;
                    String typeSig = typeRefCPEntry.getTypeSig();
                    BType bType = this.getBTypeFromDescriptor(packageInfo, typeSig);
                    typeRefCPEntry.setType(bType);
                    break;
                }
            }
        }
    }

    private void resolveErrorType(PackageInfo packageInfo, ErrorTypeInfo errorTypeInfo) {
        errorTypeInfo.getType().reasonType = this.getBTypeFromDescriptor(packageInfo, errorTypeInfo.getReasonFieldTypeSignature());
        errorTypeInfo.getType().detailType = this.getBTypeFromDescriptor(packageInfo, errorTypeInfo.getDetailFieldTypeSignature());
    }

    private void setAttachedFunctions(PackageInfo packageInfo) {
        TypeDefInfo[] structInfoEntries;
        for (TypeDefInfo structInfo : structInfoEntries = packageInfo.getTypeDefInfoEntries()) {
            StructureTypeInfo structureTypeInfo;
            BStructureType structType;
            if (structInfo.typeTag == 32 || structInfo.typeTag == 27 || (structType = (structureTypeInfo = (StructureTypeInfo)structInfo.typeInfo).getType()).getTag() != 33 && structType.getTag() != 12) continue;
            int attachedFuncCount = structureTypeInfo.funcInfoEntries.size();
            BAttachedFunction[] attachedFunctions = new BAttachedFunction[attachedFuncCount];
            int count = 0;
            for (FunctionInfo attachedFuncInfo : structureTypeInfo.funcInfoEntries.values()) {
                BAttachedFunction attachedFunction = new BAttachedFunction(attachedFuncInfo.name, attachedFuncInfo.funcType, attachedFuncInfo.flags);
                attachedFunctions[count++] = attachedFunction;
                if (structureTypeInfo.initializer != attachedFuncInfo) continue;
                structureTypeInfo.getType().initializer = attachedFunction;
            }
            structureTypeInfo.getType().setAttachedFunctions(attachedFunctions);
        }
    }

    private DefaultValue getDefaultValue(ConstantPool constantPool) throws IOException {
        int typeDescCPIndex = this.dataInStream.readInt();
        UTF8CPEntry typeDescCPEntry = (UTF8CPEntry)constantPool.getCPEntry(typeDescCPIndex);
        String typeDesc = typeDescCPEntry.getValue();
        DefaultValue defaultValue = new DefaultValue(typeDescCPIndex, typeDesc);
        switch (typeDesc) {
            case "B": {
                boolean boolValue = this.dataInStream.readBoolean();
                defaultValue.setBooleanValue(boolValue);
                break;
            }
            case "I": {
                int valueCPIndex = this.dataInStream.readInt();
                IntegerCPEntry integerCPEntry = (IntegerCPEntry)constantPool.getCPEntry(valueCPIndex);
                defaultValue.setIntValue(integerCPEntry.getValue());
                break;
            }
            case "W": {
                int valueCPIndex = this.dataInStream.readInt();
                IntegerCPEntry byteEntry = (IntegerCPEntry)constantPool.getCPEntry(valueCPIndex);
                defaultValue.setByteValue(byteEntry.getValue());
                break;
            }
            case "F": {
                int valueCPIndex = this.dataInStream.readInt();
                FloatCPEntry floatCPEntry = (FloatCPEntry)constantPool.getCPEntry(valueCPIndex);
                defaultValue.setFloatValue(floatCPEntry.getValue());
                break;
            }
            case "L": {
                int valueCPIndex = this.dataInStream.readInt();
                UTF8CPEntry decimalEntry = (UTF8CPEntry)constantPool.getCPEntry(valueCPIndex);
                defaultValue.setDecimalValue(new BigDecimal(decimalEntry.getValue(), MathContext.DECIMAL128));
                break;
            }
            case "S": {
                int valueCPIndex = this.dataInStream.readInt();
                UTF8CPEntry stringCPEntry = (UTF8CPEntry)constantPool.getCPEntry(valueCPIndex);
                defaultValue.setStringValue(stringCPEntry.getValue());
                break;
            }
            case "N": {
                break;
            }
            default: {
                throw new ProgramFileFormatException("unknown default value type " + typeDesc);
            }
        }
        return defaultValue;
    }

    private BValue getDefaultValueToBValue(DefaultValue defaultValue) throws IOException {
        BValueType value2;
        String typeDesc;
        switch (typeDesc = defaultValue.getTypeDesc()) {
            case "B": {
                boolean boolValue = defaultValue.getBooleanValue();
                value2 = new BBoolean(boolValue);
                break;
            }
            case "I": {
                long intValue = defaultValue.getIntValue();
                value2 = new BInteger(intValue);
                break;
            }
            case "W": {
                long byteValue = defaultValue.getByteValue();
                value2 = new BByte(byteValue);
                break;
            }
            case "F": {
                double floatValue = defaultValue.getFloatValue();
                value2 = new BFloat(floatValue);
                break;
            }
            case "L": {
                BigDecimal decimalValue = defaultValue.getDecimalValue();
                value2 = new BDecimal(decimalValue);
                break;
            }
            case "S": {
                String stringValue = defaultValue.getStringValue();
                value2 = new BString(stringValue);
                break;
            }
            case "N": {
                value2 = null;
                break;
            }
            default: {
                throw new ProgramFileFormatException("unknown default value type " + typeDesc);
            }
        }
        return value2;
    }

    private int[] getArgRegs(DataInputStream codeStream) throws IOException {
        int nArgRegs = codeStream.readInt();
        int[] argRegs = new int[nArgRegs];
        for (int index = 0; index < nArgRegs; ++index) {
            argRegs[index] = codeStream.readInt();
        }
        return argRegs;
    }

    private String getUTF8EntryValue(int cpEntryIndex, ConstantPool constantPool) {
        UTF8CPEntry pkgNameCPEntry = (UTF8CPEntry)constantPool.getCPEntry(cpEntryIndex);
        return pkgNameCPEntry.getValue();
    }

    private PackageInfo getPackageInfo(String pkgPath) {
        PackageInfo pkgInfo = this.programFile.getPackageInfo(pkgPath);
        if (pkgInfo != null) {
            return pkgInfo;
        }
        try {
            PackageFileReader pkgFileReader = new PackageFileReader(this.programFile);
            pkgFileReader.readPackage(pkgPath);
        }
        catch (IOException e) {
            throw new BLangRuntimeException("error reading module: " + pkgPath, e);
        }
        return this.programFile.getPackageInfo(pkgPath);
    }

    private BType getBTypeFromDescriptor(PackageInfo packageInfo, String desc) {
        return (BType)this.typeSigReader.getBTypeFromDescriptor((TypeCreator)new RuntimeTypeCreator(packageInfo), desc);
    }

    private String getPackagePath(String orgName, String pkgName, String version) {
        if (Names.DOT.value.equals(pkgName)) {
            return pkgName;
        }
        orgName = orgName.equals(Names.ANON_ORG.value) ? "" : orgName + Names.ORG_NAME_SEPARATOR.value;
        if (Names.EMPTY.value.equals(version)) {
            return orgName + pkgName;
        }
        return orgName + pkgName + Names.VERSION_SEPARATOR.value + version;
    }

    private class RuntimeTypeCreator
    implements TypeCreator<BType> {
        PackageInfo packageInfo;

        public RuntimeTypeCreator(PackageInfo packageInfo) {
            this.packageInfo = packageInfo;
        }

        public BType getBasicType(char typeChar) {
            switch (typeChar) {
                case 'I': {
                    return BTypes.typeInt;
                }
                case 'W': {
                    return BTypes.typeByte;
                }
                case 'F': {
                    return BTypes.typeFloat;
                }
                case 'L': {
                    return BTypes.typeDecimal;
                }
                case 'S': {
                    return BTypes.typeString;
                }
                case 'B': {
                    return BTypes.typeBoolean;
                }
                case 'Y': {
                    return BTypes.typeDesc;
                }
                case 'A': {
                    return BTypes.typeAny;
                }
                case 'N': {
                    return BTypes.typeNull;
                }
                case 'K': {
                    return BTypes.typeAnydata;
                }
            }
            throw new IllegalArgumentException("unsupported basic type char: " + typeChar);
        }

        public BType getBuiltinRefType(String typeName) {
            return BTypes.getTypeFromName(typeName);
        }

        public BType getRefType(char typeChar, String pkgId, String typeName) {
            if (typeName.isEmpty()) {
                return null;
            }
            PackageInfo packageInfoOfType = pkgId != null ? PackageInfoReader.this.getPackageInfo(pkgId) : this.packageInfo;
            switch (typeChar) {
                case 'X': {
                    return BTypes.typeAnyService;
                }
            }
            TypeDefInfo typeDefInfo = packageInfoOfType.getTypeDefInfo(typeName);
            if (typeDefInfo != null) {
                return typeDefInfo.typeInfo.getType();
            }
            return BTypes.getTypeFromName(typeName);
        }

        public BType getConstrainedType(char typeChar, BType constraint) {
            switch (typeChar) {
                case 'D': {
                    if (constraint == null) {
                        return BTypes.typeTable;
                    }
                    return new BTableType(constraint);
                }
                case 'M': {
                    if (constraint == null || constraint == BTypes.typeAny) {
                        return BTypes.typeMap;
                    }
                    return new BMapType(constraint);
                }
                case 'H': {
                    return new BStreamType(constraint);
                }
            }
            return constraint;
        }

        public BType getArrayType(BType elementType, int size) {
            return new BArrayType(elementType, size);
        }

        public BType getCollectionType(char typeChar, List<BType> memberTypes) {
            switch (typeChar) {
                case 'O': {
                    return new BUnionType(memberTypes);
                }
                case 'P': {
                    return new BTupleType(memberTypes);
                }
            }
            throw new IllegalArgumentException("unsupported collection type char: " + typeChar);
        }

        public BType getFunctionType(List<BType> funcParams, BType retType) {
            BType[] returnTypes = retType == null ? new BType[]{} : new BType[]{retType};
            return new BFunctionType(funcParams.toArray(new BType[funcParams.size()]), returnTypes);
        }

        public BType getErrorType(BType reasonType, BType detailsType) {
            if (reasonType == BTypes.typeString && detailsType == BTypes.typeMap) {
                return BTypes.typeError;
            }
            return new BErrorType(reasonType, detailsType);
        }
    }
}

