/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.codegen;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.ballerinalang.util.codegen.PackageFileReader;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.PackageInfoReader;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.exceptions.BLangRuntimeException;

public class ProgramFileReader {
    private ProgramFile programFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgramFile readProgram(Path programFilePath) throws IOException {
        try (InputStream fileIS = null;){
            this.programFile = new ProgramFile();
            this.programFile.setProgramFilePath(programFilePath);
            fileIS = Files.newInputStream(programFilePath, StandardOpenOption.READ, LinkOption.NOFOLLOW_LINKS);
            BufferedInputStream bufferedIS = new BufferedInputStream(fileIS);
            DataInputStream dataInStream = new DataInputStream(bufferedIS);
            ProgramFile programFile = this.readProgramInternal(dataInStream);
            return programFile;
        }
    }

    public ProgramFile readProgram(InputStream programFileInStream) throws IOException {
        this.programFile = new ProgramFile();
        DataInputStream dataInStream = new DataInputStream(programFileInStream);
        return this.readProgramInternal(dataInStream);
    }

    private ProgramFile readProgramInternal(DataInputStream dataInStream) throws IOException {
        this.loadBuiltinPackage();
        this.loadRuntimePackage();
        PackageInfoReader pkgInfoReader = new PackageInfoReader(dataInStream, this.programFile);
        int magicNumber = dataInStream.readInt();
        if (magicNumber != -1172462386) {
            throw new BLangRuntimeException("ballerina: invalid magic number " + magicNumber);
        }
        short version = dataInStream.readShort();
        if (version != 50) {
            throw new BLangRuntimeException("ballerina: unsupported program file version " + version);
        }
        this.programFile.setVersion(version);
        pkgInfoReader.readConstantPool(this.programFile);
        pkgInfoReader.readEntryPoint();
        int pkgInfoCount = dataInStream.readShort();
        for (int i = 0; i < pkgInfoCount; ++i) {
            PackageInfoReader pkgReader = new PackageInfoReader(dataInStream, this.programFile);
            pkgReader.readPackageInfo();
        }
        pkgInfoReader.resolveCPEntries(this.programFile.getEntryPackage());
        PackageInfo entryPkg = this.programFile.getPackageInfo(this.programFile.getEntryPkgName());
        this.programFile.setEntryPackage(entryPkg);
        entryPkg.setProgramFile(this.programFile);
        pkgInfoReader.readAttributeInfoEntries(entryPkg, this.programFile, this.programFile);
        this.programFile.initializeGlobalMemArea();
        return this.programFile;
    }

    private void loadBuiltinPackage() throws IOException {
        PackageFileReader pkgFileReader = new PackageFileReader(this.programFile);
        pkgFileReader.readPackage("ballerina/builtin");
    }

    private void loadRuntimePackage() throws IOException {
        PackageFileReader pkgFileReader = new PackageFileReader(this.programFile);
        pkgFileReader.readPackage("ballerina/runtime");
    }
}

