/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.debugger;

import org.ballerinalang.util.codegen.LineNumberInfo;
import org.ballerinalang.util.debugger.DebugCommand;

public class DebugContext {
    private volatile DebugCommand currentCommand;
    private LineNumberInfo lastLine;
    private int framePointer;
    private boolean strandPaused;
    private boolean cmdChanged = false;

    public DebugContext() {
        this.currentCommand = DebugCommand.RESUME;
    }

    public DebugContext(DebugCommand command) {
        this.currentCommand = command;
    }

    public DebugCommand getCurrentCommand() {
        return this.currentCommand;
    }

    public void setCurrentCommand(DebugCommand currentCommand) {
        this.cmdChanged = true;
        this.currentCommand = currentCommand;
    }

    public LineNumberInfo getLastLine() {
        return this.lastLine;
    }

    public void updateContext(LineNumberInfo lastLine, int framePointer) {
        this.framePointer = framePointer;
        this.lastLine = lastLine;
    }

    public int getFramePointer() {
        return this.framePointer;
    }

    public void clearContext() {
        this.framePointer = -1;
        this.lastLine = null;
    }

    public boolean isStrandPaused() {
        return this.strandPaused;
    }

    public void setStrandPaused(boolean strandPaused) {
        this.strandPaused = strandPaused;
    }

    public boolean isCmdChanged() {
        return this.cmdChanged;
    }
}

