/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.debugger;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ballerinalang.util.codegen.LineNumberInfo;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.codegen.attributes.AttributeInfo;
import org.ballerinalang.util.codegen.attributes.LineNumberTableAttributeInfo;
import org.ballerinalang.util.debugger.dto.BreakPointDTO;

class DebugInfoHolder {
    private Map<String, DebuggerPkgInfo> packageInfoMap = new HashMap<String, DebuggerPkgInfo>();

    DebugInfoHolder(ProgramFile programFile) {
        this.init(programFile);
    }

    private void init(ProgramFile programFile) {
        this.processPkgInfos(programFile.getPackageInfoEntries());
    }

    private void processPkgInfos(PackageInfo[] pkgInfos) {
        Arrays.stream(pkgInfos).forEach(this::processPkgInfo);
    }

    private void processPkgInfo(PackageInfo packageInfo) {
        DebuggerPkgInfo debuggerPkgInfo = new DebuggerPkgInfo(packageInfo.getInstructionCount());
        LineNumberTableAttributeInfo lineNumberTableAttributeInfo = (LineNumberTableAttributeInfo)packageInfo.getAttributeInfo(AttributeInfo.Kind.LINE_NUMBER_TABLE_ATTRIBUTE);
        List lineNumberInfos = lineNumberTableAttributeInfo.getLineNumberInfoList().stream().sorted(Comparator.comparing(LineNumberInfo::getIp)).collect(Collectors.toList());
        LineNumberInfo currentLineNoInfo = null;
        for (LineNumberInfo lineNoInfo : lineNumberInfos) {
            if (currentLineNoInfo == null) {
                currentLineNoInfo = lineNoInfo;
                continue;
            }
            debuggerPkgInfo.addLineNumberInfo(currentLineNoInfo.getIp(), lineNoInfo.getIp(), currentLineNoInfo);
            currentLineNoInfo = lineNoInfo;
        }
        if (currentLineNoInfo != null) {
            debuggerPkgInfo.addLineNumberInfo(currentLineNoInfo.getIp(), packageInfo.getInstructionCount(), currentLineNoInfo);
        }
        this.packageInfoMap.put(packageInfo.getPkgPath(), debuggerPkgInfo);
    }

    private boolean addDebugPoint(BreakPointDTO breakPointDTO) {
        if (this.packageInfoMap.get(breakPointDTO.getPackagePath()) == null) {
            return false;
        }
        return this.packageInfoMap.get(breakPointDTO.getPackagePath()).markDebugPoint(breakPointDTO);
    }

    List<BreakPointDTO> addDebugPoints(List<BreakPointDTO> breakPointDTOS) {
        ArrayList<BreakPointDTO> deployedBreakPoints = new ArrayList<BreakPointDTO>();
        this.packageInfoMap.values().forEach(DebuggerPkgInfo::clearDebugPoints);
        for (BreakPointDTO nodeLocation : breakPointDTOS) {
            if (!this.addDebugPoint(nodeLocation)) continue;
            deployedBreakPoints.add(nodeLocation);
        }
        return deployedBreakPoints;
    }

    void clearDebugLocations() {
        this.packageInfoMap.values().forEach(DebuggerPkgInfo::clearDebugPoints);
    }

    LineNumberInfo getLineNumber(String packagePath, int ip) {
        return this.packageInfoMap.get(packagePath).getLineNumberInfo(ip);
    }

    static class DebuggerPkgInfo {
        LineNumberInfo[] ipLineNos;
        Map<String, LineNumberInfo> lineNumbers = new HashMap<String, LineNumberInfo>();

        DebuggerPkgInfo(int instructionCount) {
            this.ipLineNos = new LineNumberInfo[instructionCount];
        }

        void addLineNumberInfo(int beginIp, int endIp, LineNumberInfo lineNumberInfo) {
            for (int i = beginIp; i < endIp; ++i) {
                this.ipLineNos[i] = lineNumberInfo;
            }
            lineNumberInfo.setEndIp(endIp);
            String fileName = lineNumberInfo.getFileName();
            if (fileName.contains(File.separator)) {
                String[] pathArray = fileName.split(File.separatorChar == '\\' ? "\\\\" : File.separator);
                fileName = pathArray[pathArray.length - 1];
            }
            String fileNameAndNo = fileName + ":" + lineNumberInfo.getLineNumber();
            this.lineNumbers.put(fileNameAndNo, lineNumberInfo);
        }

        boolean markDebugPoint(BreakPointDTO breakPointDTO) {
            String[] pathArray;
            String fileName = breakPointDTO.getFileName();
            if (fileName.contains("/")) {
                pathArray = fileName.split("/");
                fileName = pathArray[pathArray.length - 1];
            } else if (fileName.contains("\\")) {
                pathArray = fileName.split("\\\\");
                fileName = pathArray[pathArray.length - 1];
            }
            String fileNameAndNo = fileName + ":" + breakPointDTO.getLineNumber();
            LineNumberInfo lineNumberInfo = this.lineNumbers.get(fileNameAndNo);
            if (lineNumberInfo == null) {
                return false;
            }
            lineNumberInfo.setDebugPoint(true);
            return true;
        }

        void clearDebugPoints() {
            this.lineNumbers.values().forEach(l -> l.setDebugPoint(false));
        }

        LineNumberInfo getLineNumberInfo(int ip) {
            return this.ipLineNos[ip];
        }
    }
}

