/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.debugger;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import java.io.PrintStream;
import org.ballerinalang.util.debugger.Debugger;
import org.ballerinalang.util.debugger.VMDebugServerHandler;

class DebugServer {
    private Debugger debugger;
    private Channel serverChannel;

    DebugServer(Debugger debugger) {
        this.debugger = debugger;
    }

    void startServer() {
        Runnable run = this::startListening;
        new Thread(run).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startListening() {
        int port = this.getDebugPort();
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new DebugServerInitializer(this.debugger));
            this.serverChannel = b.bind(port).sync().channel();
            PrintStream out = System.out;
            out.println("Ballerina remote debugger is activated on port : " + port);
            this.serverChannel.closeFuture().sync();
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }

    private int getDebugPort() {
        String debugPort = System.getProperty("debug");
        if (debugPort == null || debugPort.equals("")) {
            debugPort = "5006";
        }
        return Integer.parseInt(debugPort);
    }

    void closeServerChannel() {
        this.serverChannel.close();
    }

    static class DebugServerInitializer
    extends ChannelInitializer<SocketChannel> {
        Debugger debugManager;

        DebugServerInitializer(Debugger debugManager) {
            this.debugManager = debugManager;
        }

        public void initChannel(SocketChannel ch) throws Exception {
            ChannelPipeline pipeline = ch.pipeline();
            pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
            pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
            pipeline.addLast(new ChannelHandler[]{new VMDebugServerHandler(this.debugManager)});
        }
    }
}

