/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.debugger;

import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import org.ballerinalang.bre.bvm.StackFrame;
import org.ballerinalang.bre.bvm.Strand;
import org.ballerinalang.model.util.JsonGenerator;
import org.ballerinalang.util.codegen.LineNumberInfo;
import org.ballerinalang.util.codegen.LocalVariableInfo;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.PackageVarInfo;
import org.ballerinalang.util.codegen.attributes.AttributeInfo;
import org.ballerinalang.util.codegen.attributes.LocalVariableAttributeInfo;
import org.ballerinalang.util.debugger.Debugger;
import org.ballerinalang.util.debugger.dto.VariableDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionEvaluator {
    private static final Logger log = LoggerFactory.getLogger(ExpressionEvaluator.class);
    private static final String STATUS = "status";
    private static final String RESULTS = "results";
    private static final String SUCCESS = "success";
    private static final String FAILURE = "failure";
    private static final String INTERNAL_ERROR = "{\"status\":\"failure\", \"results\":\"internal error\"}";
    private static final String COLON = ":";

    public String evaluateVariable(Strand ctx, LineNumberInfo currentExecLine, String variableName) {
        PackageVarInfo[] globalVars;
        int currentExecLineNum = currentExecLine.getLineNumber();
        String defaultMessage = this.constructJsonResults(false, "cannot find variable '" + variableName + "'");
        List<LocalVariableInfo> localVars = this.getLocalVariables(ctx.currentFrame);
        for (LocalVariableInfo localVariableInfo : localVars) {
            if (!localVariableInfo.getVariableName().equals(variableName)) continue;
            if (localVariableInfo.getScopeStartLineNumber() < currentExecLineNum && currentExecLineNum <= localVariableInfo.getScopeEndLineNumber()) {
                VariableDTO variableDTO = Debugger.constructLocalVariable(ctx.currentFrame, localVariableInfo);
                return this.constructJsonResults(true, variableDTO.getValue());
            }
            return defaultMessage;
        }
        for (PackageVarInfo var : globalVars = this.getPackageVariables(ctx)) {
            if (!var.getName().equals(variableName)) continue;
            int pkgIndex = ctx.currentFrame.callableUnitInfo.getPackageInfo().pkgIndex;
            VariableDTO variableDTO = Debugger.constructGlobalVariable(ctx, var, pkgIndex);
            return this.constructJsonResults(true, variableDTO.getValue());
        }
        if (variableName.contains(COLON)) {
            PackageInfo[] packageInfoEntries;
            String[] stringArray = variableName.split(COLON);
            StringBuilder pathBuilder = new StringBuilder(stringArray[0]);
            for (int i = 1; i < stringArray.length - 1; ++i) {
                pathBuilder.append(COLON).append(stringArray[i]);
            }
            String packagePath = pathBuilder.toString();
            String varName = stringArray[stringArray.length - 1];
            for (PackageInfo packageInfo : packageInfoEntries = ctx.programFile.getPackageInfoEntries()) {
                PackageVarInfo[] otherPackageVars;
                if (!packageInfo.pkgPath.equals(packagePath)) continue;
                for (PackageVarInfo var : otherPackageVars = packageInfo.getPackageInfoEntries()) {
                    if (!var.getName().equals(varName)) continue;
                    VariableDTO variableDTO = Debugger.constructGlobalVariable(ctx, var, packageInfo.pkgIndex);
                    return this.constructJsonResults(true, variableDTO.getValue());
                }
                break;
            }
        }
        return defaultMessage;
    }

    private List<LocalVariableInfo> getLocalVariables(StackFrame ctx) {
        LocalVariableAttributeInfo localVarAttrInfo = (LocalVariableAttributeInfo)ctx.callableUnitInfo.getDefaultWorkerInfo().getAttributeInfo(AttributeInfo.Kind.LOCAL_VARIABLES_ATTRIBUTE);
        return localVarAttrInfo.getLocalVariables();
    }

    private PackageVarInfo[] getPackageVariables(Strand ctx) {
        return ctx.programFile.getPackageInfo(ctx.programFile.getEntryPkgName()).getPackageInfoEntries();
    }

    private String constructJsonResults(boolean isSuccess, String value2) {
        StringWriter writer = new StringWriter();
        JsonGenerator gen = new JsonGenerator(writer);
        try {
            gen.startObject();
            gen.writeFieldName(STATUS);
            gen.writeString(isSuccess ? SUCCESS : FAILURE);
            gen.writeFieldName(RESULTS);
            gen.writeString(value2);
            gen.endObject();
            gen.flush();
        }
        catch (IOException e) {
            log.error("error while constructing json results after evaluating given expression, " + e.getMessage(), e);
            return INTERNAL_ERROR;
        }
        return writer.toString();
    }
}

