/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.debugger.util;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.ballerinalang.model.util.JsonGenerator;
import org.ballerinalang.model.util.JsonParser;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BValueArray;
import org.ballerinalang.util.debugger.dto.BreakPointDTO;
import org.ballerinalang.util.debugger.dto.CommandDTO;
import org.ballerinalang.util.debugger.dto.FrameDTO;
import org.ballerinalang.util.debugger.dto.MessageDTO;
import org.ballerinalang.util.debugger.dto.VariableDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugMsgUtil {
    private static final Logger log = LoggerFactory.getLogger(DebugMsgUtil.class);
    private static final String CODE = "code";
    private static final String MESSAGE = "message";
    private static final String THREAD_ID = "threadId";
    private static final String FRAMES = "frames";
    private static final String LOCATION = "location";
    private static final String PACKAGE_PATH = "packagePath";
    private static final String FILE_NAME = "fileName";
    private static final String LINE_NUMBER = "lineNumber";
    private static final String PACKAGE_NAME = "packageName";
    private static final String FRAME_NAME = "frameName";
    private static final String LINE_ID = "lineID";
    private static final String VARIABLES = "variables";
    private static final String SCOPE = "scope";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private static final String COMMAND = "command";
    private static final String POINTS = "points";
    private static final String EXPRESSION = "expression";

    public static String getMsgString(MessageDTO msg) {
        if (msg == null) {
            return "{ \"error\": true }";
        }
        StringWriter writer = new StringWriter();
        JsonGenerator gen = new JsonGenerator(writer);
        try {
            DebugMsgUtil.parseMessageDTO(msg, gen);
            gen.flush();
            return writer.toString();
        }
        catch (IOException e) {
            log.error("error parsing MessageDTO to json, " + e.getMessage(), e);
            return "{ \"error\": true }";
        }
    }

    public static CommandDTO buildCommandDTO(String jsonStr) {
        BRefType<?> node = JsonParser.parse(jsonStr);
        CommandDTO commandDTO = new CommandDTO();
        if (node.getType().getTag() == 7) {
            BMap json = (BMap)node;
            commandDTO.setCommand(json.get(COMMAND) == null ? null : ((BRefType)json.get(COMMAND)).stringValue());
            commandDTO.setThreadId(json.get(THREAD_ID) == null ? null : ((BRefType)json.get(THREAD_ID)).stringValue());
            commandDTO.setVariableName(json.get(EXPRESSION) == null ? null : ((BRefType)json.get(EXPRESSION)).stringValue());
            commandDTO.setPoints(DebugMsgUtil.buildBreakPoints((BRefType)json.get(POINTS)));
        }
        return commandDTO;
    }

    private static List<BreakPointDTO> buildBreakPoints(BRefType<?> json) {
        if (json == null || json.getType().getTag() != 19) {
            return null;
        }
        ArrayList<BreakPointDTO> bPoints = new ArrayList<BreakPointDTO>();
        BValueArray jsonArray = (BValueArray)json;
        int i = 0;
        while ((long)i < jsonArray.size()) {
            BMap element = (BMap)jsonArray.getRefValue(i);
            BreakPointDTO bPoint = new BreakPointDTO();
            bPoint.setPackagePath(element.get(PACKAGE_PATH) == null ? null : ((BRefType)element.get(PACKAGE_PATH)).stringValue());
            bPoint.setFileName(element.get(FILE_NAME) == null ? null : ((BRefType)element.get(FILE_NAME)).stringValue());
            bPoint.setLineNumber(element.get(LINE_NUMBER) == null ? -1 : (int)((BInteger)element.get(LINE_NUMBER)).intValue());
            bPoints.add(bPoint);
            ++i;
        }
        return bPoints;
    }

    private static void parseMessageDTO(MessageDTO msg, JsonGenerator gen) throws IOException {
        gen.startObject();
        gen.writeFieldName(CODE);
        DebugMsgUtil.writeStringField(gen, msg.getCode());
        gen.writeFieldName(MESSAGE);
        DebugMsgUtil.writeStringField(gen, msg.getMessage());
        gen.writeFieldName(THREAD_ID);
        DebugMsgUtil.writeStringField(gen, msg.getThreadId());
        gen.writeFieldName(LOCATION);
        DebugMsgUtil.parseBreakPoint(msg.getLocation(), gen);
        gen.writeFieldName(FRAMES);
        DebugMsgUtil.parseFrameList(msg.getFrames(), gen);
        gen.endObject();
    }

    private static void parseBreakPoint(BreakPointDTO bPoint, JsonGenerator gen) throws IOException {
        if (bPoint == null) {
            gen.writeNull();
            return;
        }
        gen.startObject();
        gen.writeFieldName(PACKAGE_PATH);
        DebugMsgUtil.writeStringField(gen, bPoint.getPackagePath());
        gen.writeFieldName(FILE_NAME);
        DebugMsgUtil.writeStringField(gen, bPoint.getFileName());
        gen.writeFieldName(LINE_NUMBER);
        gen.writeNumber(bPoint.getLineNumber());
        gen.endObject();
    }

    private static void parseFrameList(List<FrameDTO> frames, JsonGenerator gen) throws IOException {
        if (frames == null) {
            gen.writeNull();
            return;
        }
        gen.writeStartArray();
        for (FrameDTO f : frames) {
            DebugMsgUtil.parseFrame(f, gen);
        }
        gen.writeEndArray();
    }

    private static void parseFrame(FrameDTO frame, JsonGenerator gen) throws IOException {
        if (frame == null) {
            gen.writeNull();
            return;
        }
        gen.startObject();
        gen.writeFieldName(PACKAGE_NAME);
        DebugMsgUtil.writeStringField(gen, frame.getPackageName());
        gen.writeFieldName(FRAME_NAME);
        DebugMsgUtil.writeStringField(gen, frame.getFrameName());
        gen.writeFieldName(FILE_NAME);
        DebugMsgUtil.writeStringField(gen, frame.getFileName());
        gen.writeFieldName(LINE_ID);
        gen.writeNumber(frame.getLineID());
        gen.writeFieldName(VARIABLES);
        DebugMsgUtil.parseVarList(frame.getVariables(), gen);
        gen.endObject();
    }

    private static void parseVarList(List<VariableDTO> vars, JsonGenerator gen) throws IOException {
        if (vars == null) {
            gen.writeNull();
            return;
        }
        gen.writeStartArray();
        for (VariableDTO v : vars) {
            DebugMsgUtil.parseVar(v, gen);
        }
        gen.writeEndArray();
    }

    private static void parseVar(VariableDTO var, JsonGenerator gen) throws IOException {
        if (var == null) {
            gen.writeNull();
            return;
        }
        gen.startObject();
        gen.writeFieldName(SCOPE);
        DebugMsgUtil.writeStringField(gen, var.getScope());
        gen.writeFieldName(NAME);
        DebugMsgUtil.writeStringField(gen, var.getName());
        gen.writeFieldName(TYPE);
        DebugMsgUtil.writeStringField(gen, var.getType());
        gen.writeFieldName(VALUE);
        DebugMsgUtil.writeStringField(gen, StringEscapeUtils.escapeJson(var.getValue()));
        gen.endObject();
    }

    private static void writeStringField(JsonGenerator gen, String value2) throws IOException {
        if (value2 == null) {
            gen.writeNull();
            return;
        }
        gen.writeString(value2);
    }
}

