/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.metrics;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import org.ballerinalang.util.metrics.Counter;
import org.ballerinalang.util.metrics.Gauge;
import org.ballerinalang.util.metrics.Metric;
import org.ballerinalang.util.metrics.MetricId;
import org.ballerinalang.util.metrics.PolledGauge;
import org.ballerinalang.util.metrics.StatisticConfig;
import org.ballerinalang.util.metrics.spi.MetricProvider;

public class MetricRegistry {
    private final MetricProvider metricProvider;
    private final ConcurrentMap<MetricId, Metric> metrics;

    public MetricRegistry(MetricProvider metricProvider) {
        this.metricProvider = metricProvider;
        this.metrics = new ConcurrentHashMap<MetricId, Metric>();
    }

    public Counter counter(MetricId id) {
        return this.getOrCreate(id, Counter.class, () -> this.metricProvider.newCounter(id));
    }

    public Counter register(Counter counter) {
        return this.register(counter, Counter.class);
    }

    public void unregister(Counter counter) {
        this.unregister(counter, Counter.class);
    }

    public Gauge gauge(MetricId id, StatisticConfig ... statisticConfigs) {
        return this.getOrCreate(id, Gauge.class, () -> this.metricProvider.newGauge(id, statisticConfigs));
    }

    public Gauge register(Gauge gauge) {
        return this.register(gauge, Gauge.class);
    }

    public void unregister(Gauge gauge) {
        this.unregister(gauge, Gauge.class);
    }

    public <T> PolledGauge polledGauge(MetricId id, T obj, ToDoubleFunction<T> valueFunction) {
        return this.getOrCreate(id, PolledGauge.class, () -> this.metricProvider.newPolledGauge(id, obj, valueFunction));
    }

    public PolledGauge register(PolledGauge gauge) {
        return this.register(gauge, PolledGauge.class);
    }

    public void unregister(PolledGauge gauge) {
        this.unregister(gauge, PolledGauge.class);
    }

    private <M extends Metric> M getOrCreate(MetricId id, Class<M> metricClass, Supplier<M> metricSupplier) {
        M metric = this.readMetric(id, metricClass);
        if (metric == null) {
            Metric newMetric = (Metric)metricSupplier.get();
            return this.writeMetricIfNotExists(newMetric, metricClass);
        }
        return metric;
    }

    private <M extends Metric> M readMetric(MetricId metricId, Class<M> metricClass) {
        Metric existingMetrics = this.lookup(metricId);
        if (existingMetrics != null) {
            if (metricClass.isInstance(existingMetrics)) {
                return (M)existingMetrics;
            }
            throw new IllegalArgumentException(metricId + " is already used for a different type of metric: " + metricClass.getSimpleName());
        }
        return null;
    }

    private <M extends Metric> M writeMetricIfNotExists(Metric metric, Class<M> metricClass) {
        Metric existing = this.metrics.putIfAbsent(metric.getId(), metric);
        if (existing != null) {
            if (metricClass.isInstance(existing)) {
                return (M)existing;
            }
            throw new IllegalArgumentException(metric.getId() + " is already used for a different type of metric: " + metricClass.getSimpleName());
        }
        return (M)metric;
    }

    private <M extends Metric> M register(Metric registerMetric, Class<M> metricClass) {
        M metric = this.readMetric(registerMetric.getId(), metricClass);
        if (metric == null) {
            return this.writeMetricIfNotExists(registerMetric, metricClass);
        }
        return metric;
    }

    private void unregister(Metric registerMetric, Class metricClass) {
        Object metric = this.readMetric(registerMetric.getId(), metricClass);
        if (metric != null) {
            this.metrics.remove(registerMetric.getId());
        }
    }

    public void remove(String name) {
        List<MetricId> ids = this.metrics.keySet().stream().filter(id -> id.getName().equals(name)).collect(Collectors.toList());
        ids.forEach(this.metrics::remove);
    }

    public MetricProvider getMetricProvider() {
        return this.metricProvider;
    }

    public Metric[] getAllMetrics() {
        return this.metrics.values().toArray(new Metric[this.metrics.values().size()]);
    }

    public Metric lookup(MetricId metricId) {
        return (Metric)this.metrics.get(metricId);
    }
}

