/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.metrics;

import java.time.Duration;
import java.util.Arrays;
import org.ballerinalang.util.metrics.PercentileValue;

public class Snapshot {
    private static final PercentileValue[] EMPTY_PERCENTILE_VALUES = new PercentileValue[0];
    private final Duration timeWindow;
    private final double min;
    private final double mean;
    private final double stdDev;
    private final double max;
    private final PercentileValue[] percentileValues;

    public Snapshot(Duration timeWindow, double min, double mean, double stdDev, double max, PercentileValue[] percentileValues) {
        this.timeWindow = timeWindow;
        this.min = min;
        this.mean = mean;
        this.stdDev = stdDev;
        this.max = max;
        this.percentileValues = percentileValues;
    }

    public Duration getTimeWindow() {
        return this.timeWindow;
    }

    public double getMin() {
        return this.min;
    }

    public double getMean() {
        return this.mean;
    }

    public double getStdDev() {
        return this.stdDev;
    }

    public double getMax() {
        return this.max;
    }

    public PercentileValue[] getPercentileValues() {
        return this.percentileValues != null ? Arrays.copyOf(this.percentileValues, this.percentileValues.length) : EMPTY_PERCENTILE_VALUES;
    }
}

