/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.metrics;

import java.time.Duration;
import java.util.Arrays;
import java.util.Objects;

public class StatisticConfig {
    public static final StatisticConfig DEFAULT = StatisticConfig.builder().percentiles(0.33, 0.5, 0.66, 0.99, 0.999).build();
    private double[] percentiles;
    private int percentilePrecision = 2;
    private Duration timeWindow = Duration.ofMinutes(10L);
    private long buckets = 5L;

    private StatisticConfig() {
    }

    public double[] getPercentiles() {
        return this.percentiles != null ? Arrays.copyOf(this.percentiles, this.percentiles.length) : this.percentiles;
    }

    public Integer getPercentilePrecision() {
        return this.percentilePrecision;
    }

    public Duration getTimeWindow() {
        return this.timeWindow;
    }

    public long getBuckets() {
        return this.buckets;
    }

    public static Builder builder() {
        return new Builder();
    }

    static /* synthetic */ double[] access$102(StatisticConfig x0, double[] x1) {
        x0.percentiles = x1;
        return x1;
    }

    public static class Builder {
        private StatisticConfig config = new StatisticConfig();

        public Builder percentiles(double ... percentiles) {
            if ((percentiles = Objects.requireNonNull(percentiles, "percentiles array should not be null.")).length == 0) {
                throw new IllegalArgumentException("percentiles array should not be empty.");
            }
            for (double quantile : percentiles) {
                if (!(quantile < 0.0) && !(quantile > 1.0)) continue;
                throw new IllegalArgumentException("Quantile " + quantile + " invalid: Expected number between 0.0 and 1.0.");
            }
            StatisticConfig.access$102(this.config, percentiles);
            return this;
        }

        public Builder percentilePrecision(int digitsOfPrecision) {
            if (digitsOfPrecision < 0 || digitsOfPrecision > 5) {
                throw new IllegalArgumentException("precision cannot be " + digitsOfPrecision + ". It must be a non-negative integer between 0 and 5");
            }
            this.config.percentilePrecision = digitsOfPrecision;
            return this;
        }

        public Builder expiry(Duration expiry) {
            if (expiry.getSeconds() <= 0L) {
                throw new IllegalArgumentException("timeWindow cannot be " + expiry + ". It must be greater than zero.");
            }
            this.config.timeWindow = expiry;
            return this;
        }

        public Builder buckets(long buckets) {
            if (buckets <= 0L) {
                throw new IllegalArgumentException("buckets cannot be " + buckets + ". It must be greater than zero.");
            }
            this.config.buckets = buckets;
            return this;
        }

        public StatisticConfig build() {
            return this.config;
        }
    }
}

