/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.metrics;

import java.util.Objects;

public final class Tag
implements Comparable<Tag> {
    private final String key;
    private final String value;
    private final int hashCode;

    public Tag(String key, String value2) {
        this.key = Objects.requireNonNull(key);
        this.value = Objects.requireNonNull(value2);
        this.hashCode = Objects.hash(key, value2);
    }

    static Tag of(String key, String value2) {
        return new Tag(key, value2);
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public int compareTo(Tag o) {
        return this.key.compareTo(o.key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tag tag = (Tag)o;
        return Objects.equals(this.key, tag.key) && Objects.equals(this.value, tag.value);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Tag{");
        sb.append("key='").append(this.key).append('\'');
        sb.append(", value='").append(this.value).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

