/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.observability;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.old.WorkerExecutionContext;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.util.codegen.ServiceInfo;
import org.ballerinalang.util.observability.BallerinaObserver;
import org.ballerinalang.util.observability.ObserverContext;
import org.ballerinalang.util.tracer.BSpan;

public class ObservabilityUtils {
    private static final List<BallerinaObserver> observers = new CopyOnWriteArrayList<BallerinaObserver>();
    private static final boolean enabled;
    private static final boolean tracingEnabled;
    private static final String PACKAGE_SEPARATOR = ".";

    public static boolean isObservabilityEnabled() {
        return enabled;
    }

    public static void addObserver(BallerinaObserver observer) {
        observers.add(observer);
    }

    public static void removeObserver(BallerinaObserver observer) {
        observers.remove(observer);
    }

    public static Optional<ObserverContext> startServerObservation(String connectorName, ServiceInfo serviceInfo, String resourceName, WorkerExecutionContext parentContext) {
        if (!enabled) {
            return Optional.empty();
        }
        Objects.requireNonNull(connectorName);
        ObserverContext ctx = new ObserverContext();
        ctx.setConnectorName(connectorName);
        ctx.setServiceName(ObservabilityUtils.getFullServiceName(serviceInfo));
        ctx.setResourceName(resourceName);
        if (parentContext != null) {
            ObservabilityUtils.continueServerObservation(ctx, parentContext);
        }
        return Optional.of(ctx);
    }

    public static Optional<ObserverContext> startClientObservation(String connectorName, String actionName, WorkerExecutionContext parentCtx) {
        if (!enabled) {
            return Optional.empty();
        }
        Objects.requireNonNull(connectorName);
        ObserverContext ctx = new ObserverContext();
        ctx.setConnectorName(connectorName);
        ctx.setActionName(actionName);
        if (parentCtx != null) {
            ObservabilityUtils.continueClientObservation(ctx, parentCtx);
        }
        return Optional.of(ctx);
    }

    public static void continueServerObservation(ObserverContext observerContext, WorkerExecutionContext parentCtx) {
        if (!enabled) {
            return;
        }
        Objects.requireNonNull(parentCtx);
        ObserverContext parentObserverContext = ObservabilityUtils.populateAndGetParentObserverContext(parentCtx);
        observerContext.setParent(parentObserverContext);
        observerContext.setServer();
        observerContext.setStarted();
        ObserverContext ctx = observerContext;
        observers.forEach(observer -> observer.startServerObservation(ctx));
    }

    public static void continueClientObservation(ObserverContext observerContext, WorkerExecutionContext parentCtx) {
        if (!enabled) {
            return;
        }
        Objects.requireNonNull(parentCtx);
        ObserverContext parentObserverContext = ObservabilityUtils.populateAndGetParentObserverContext(parentCtx);
        observerContext.setParent(parentObserverContext);
        observerContext.setStarted();
        ObserverContext ctx = observerContext;
        observers.forEach(observer -> observer.startClientObservation(ctx));
    }

    public static void stopObservation(ObserverContext observerContext) {
        if (!enabled || observerContext == null) {
            return;
        }
        Objects.requireNonNull(observerContext);
        if (observerContext.isServer()) {
            observers.forEach(observer -> observer.stopServerObservation(observerContext));
        } else {
            observers.forEach(observer -> observer.stopClientObservation(observerContext));
        }
        observerContext.setFinished();
    }

    public static Map<String, String> getContextProperties(ObserverContext observerContext) {
        BSpan bSpan = (BSpan)observerContext.getProperty("_span_");
        if (bSpan != null) {
            return bSpan.getTraceContext();
        }
        return Collections.emptyMap();
    }

    public static void setObserverContextToWorkerExecutionContext(WorkerExecutionContext workerExecutionContext, ObserverContext observerContext) {
        if (!enabled || observerContext == null) {
            return;
        }
        if (workerExecutionContext.localProps == null) {
            workerExecutionContext.localProps = new HashMap<String, Object>();
        }
        workerExecutionContext.localProps.put("__observer_context__", observerContext);
    }

    private static ObserverContext populateAndGetParentObserverContext(WorkerExecutionContext parentCtx) {
        ObserverContext observerContext;
        ArrayList<WorkerExecutionContext> ancestors = new ArrayList<WorkerExecutionContext>();
        Object ctx = null;
        WorkerExecutionContext parent = parentCtx;
        while (parent != null) {
            Object object = ctx = parent.localProps != null ? parent.localProps.get("__observer_context__") : null;
            if (ctx != null) break;
            ancestors.add(parent);
            parent = parent.parent;
        }
        ObserverContext observerContext2 = observerContext = ctx != null ? (ObserverContext)ctx : new ObserverContext();
        while (observerContext.isFinished() && observerContext.getParent() != null) {
            observerContext = observerContext.getParent();
        }
        ObserverContext currentObserverContext = observerContext;
        ancestors.forEach(w -> {
            if (w.localProps == null) {
                w.localProps = new HashMap<String, Object>();
            }
            w.localProps.put("__observer_context__", currentObserverContext);
        });
        return observerContext;
    }

    public static String getFullServiceName(ServiceInfo serviceInfo) {
        BType serviceInfoType = serviceInfo.getType();
        return serviceInfoType.getPackagePath().equals(PACKAGE_SEPARATOR) ? serviceInfoType.getName() : serviceInfoType.getPackagePath() + PACKAGE_SEPARATOR + serviceInfoType.getName();
    }

    public static void logMessageToActiveSpan(Context context, String logLevel, Supplier<String> logMessage, boolean isError) {
        if (tracingEnabled) {
            // empty if block
        }
    }

    static {
        ConfigRegistry configRegistry = ConfigRegistry.getInstance();
        tracingEnabled = configRegistry.getAsBoolean("b7a.observability.tracing.enabled");
        enabled = configRegistry.getAsBoolean("b7a.observability.metrics.enabled") || tracingEnabled;
    }
}

