/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.observability;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.StackFrame;
import org.ballerinalang.bre.bvm.Strand;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.util.FunctionFlags;
import org.ballerinalang.util.codegen.CallableUnitInfo;
import org.ballerinalang.util.codegen.ServiceInfo;
import org.ballerinalang.util.observability.BallerinaObserver;
import org.ballerinalang.util.observability.ObserverContext;
import org.ballerinalang.util.program.BLangVMUtils;
import org.ballerinalang.util.tracer.BSpan;

public class ObserveUtils {
    private static final List<BallerinaObserver> observers = new CopyOnWriteArrayList<BallerinaObserver>();
    private static final boolean enabled;
    private static final boolean tracingEnabled;
    private static final String PACKAGE_SEPARATOR = ".";

    public static void addObserver(BallerinaObserver observer) {
        observers.add(observer);
    }

    public static void startResourceObservation(Strand strand, ObserverContext observerContext) {
        if (!enabled) {
            return;
        }
        ObserverContext newObContext = observerContext;
        if (newObContext == null) {
            CallableUnitInfo callableUnitInfo = strand.currentFrame.callableUnitInfo;
            newObContext = new ObserverContext();
            newObContext.setConnectorName("Unknown");
            newObContext.setServiceName(ObserveUtils.getFullServiceName(callableUnitInfo.attachedToType));
            newObContext.setResourceName(callableUnitInfo.getName());
        }
        strand.respCallback.setObserverContext(newObContext);
        newObContext.setServer();
        newObContext.setStarted();
        strand.currentFrame.observerContext = newObContext;
        observers.forEach(observer -> observer.startServerObservation(strand.currentFrame.observerContext));
    }

    private static String getFullServiceName(BType serviceInfoType) {
        return serviceInfoType.getPackagePath().equals(PACKAGE_SEPARATOR) ? serviceInfoType.getName() : serviceInfoType.getPackagePath() + PACKAGE_SEPARATOR + serviceInfoType.getName();
    }

    public static void stopObservation(ObserverContext observerContext) {
        if (!enabled || observerContext == null) {
            return;
        }
        if (observerContext.isServer()) {
            observers.forEach(observer -> observer.stopServerObservation(observerContext));
        } else {
            observers.forEach(observer -> observer.stopClientObservation(observerContext));
        }
        observerContext.setFinished();
    }

    public static void startCallableObservation(Strand strand, int flags) {
        ObserverContext parentCtx;
        if (!enabled) {
            return;
        }
        StackFrame previousFrame = strand.peekFrame(1);
        ObserverContext observerContext = parentCtx = previousFrame == null ? strand.respCallback.getObserverContext() : previousFrame.observerContext;
        if (!FunctionFlags.isObserved((int)flags)) {
            strand.currentFrame.observerContext = parentCtx;
            return;
        }
        if (parentCtx == null) {
            parentCtx = new ObserverContext();
            parentCtx.addTag("span.kind", "server");
            parentCtx.setConnectorName("Unknown");
            parentCtx.setServiceName("Unknown Service");
            parentCtx.setResourceName(strand.getId());
            parentCtx.setServer();
            parentCtx.setStarted();
            strand.respCallback.setObserverContext(parentCtx);
            observers.forEach(observer -> observer.startServerObservation(strand.respCallback.getObserverContext()));
        }
        ObserverContext newObContext = new ObserverContext();
        newObContext.setParent(parentCtx);
        newObContext.setStarted();
        newObContext.setConnectorName(strand.currentFrame.callableUnitInfo.attachedToType.toString());
        newObContext.setActionName(strand.currentFrame.callableUnitInfo.getName());
        newObContext.setServiceName(ObserveUtils.getServiceName(strand));
        strand.currentFrame.observerContext = newObContext;
        observers.forEach(observer -> observer.startClientObservation(newObContext));
    }

    private static String getServiceName(Strand strand) {
        ServiceInfo serviceInfo = BLangVMUtils.getServiceInfo(strand);
        return serviceInfo != null ? ObserveUtils.getFullServiceName(serviceInfo) : "Unknown Service";
    }

    public static void startCallableObservation(Strand strand, ObserverContext parentCtx) {
        if (!enabled) {
            return;
        }
        ObserverContext newObContext = new ObserverContext();
        newObContext.setParent(parentCtx);
        newObContext.setStarted();
        String connectorName = strand.currentFrame.callableUnitInfo.attachedToType != null ? strand.currentFrame.callableUnitInfo.attachedToType.toString() : "ballerina:worker";
        newObContext.setConnectorName(connectorName);
        newObContext.setActionName(strand.currentFrame.callableUnitInfo.getName());
        newObContext.setServiceName(ObserveUtils.getServiceName(strand));
        strand.currentFrame.observerContext = newObContext;
        strand.respCallback.setObserverContext(newObContext);
        observers.forEach(observer -> observer.startClientObservation(newObContext));
    }

    public static void stopCallableObservation(Strand strand) {
        if (!enabled) {
            return;
        }
        if (!FunctionFlags.isObserved((int)strand.currentFrame.invocationFlags)) {
            strand.peekFrame((int)1).observerContext = strand.currentFrame.observerContext;
            return;
        }
        strand.peekFrame((int)1).observerContext = strand.currentFrame.observerContext.getParent();
        ObserveUtils.stopObservation(strand.currentFrame.observerContext);
    }

    public static String getFullServiceName(ServiceInfo serviceInfo) {
        BType serviceInfoType = serviceInfo.getType();
        return serviceInfoType.getPackagePath().equals(PACKAGE_SEPARATOR) ? serviceInfoType.getName() : serviceInfoType.getPackagePath() + PACKAGE_SEPARATOR + serviceInfoType.getName();
    }

    public static Map<String, String> getContextProperties(ObserverContext observerContext) {
        BSpan bSpan = (BSpan)observerContext.getProperty("_span_");
        if (bSpan != null) {
            return bSpan.getTraceContext();
        }
        return Collections.emptyMap();
    }

    public static void logMessageToActiveSpan(Context context, String logLevel, Supplier<String> logMessage, boolean isError) {
        if (!tracingEnabled) {
            return;
        }
        Optional<ObserverContext> observerContext = ObserveUtils.getObserverContextOfCurrentFrame(context);
        if (!observerContext.isPresent()) {
            return;
        }
        BSpan span = (BSpan)observerContext.get().getProperty("_span_");
        if (span == null) {
            return;
        }
        HashMap<String, Object> logs = new HashMap<String, Object>(1);
        logs.put(logLevel, logMessage.get());
        if (!isError) {
            span.log(logs);
        } else {
            span.logError(logs);
        }
    }

    public static boolean isObservabilityEnabled() {
        return enabled;
    }

    public static Optional<ObserverContext> getObserverContextOfCurrentFrame(Context context) {
        if (!enabled || context.getStrand().currentFrame.observerContext == null) {
            return Optional.empty();
        }
        return Optional.of(context.getStrand().currentFrame.observerContext);
    }

    public static void setObserverContextToCurrentFrame(Strand strand, ObserverContext observerContext) {
        if (!enabled) {
            return;
        }
        strand.currentFrame.observerContext = observerContext;
    }

    static {
        ConfigRegistry configRegistry = ConfigRegistry.getInstance();
        tracingEnabled = configRegistry.getAsBoolean("b7a.observability.tracing.enabled");
        enabled = configRegistry.getAsBoolean("b7a.observability.metrics.enabled") || tracingEnabled;
    }
}

