/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.observability;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ObserverContext {
    private Map<String, Object> properties = new HashMap<String, Object>();
    private Map<String, String> tags = new HashMap<String, String>();
    private String serviceName;
    private String resourceName;
    private String connectorName;
    private String actionName;
    private boolean server;
    private boolean started;
    private boolean finished;
    private ObserverContext parent;
    private boolean isSystemSpan;

    public void addProperty(String key, Object value2) {
        this.properties.put(key, value2);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void addTag(String key, String value2) {
        this.tags.put(key, value2 != null ? value2 : "");
    }

    public Map<String, String> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = Objects.requireNonNull(serviceName);
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = Objects.requireNonNull(resourceName);
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public void setConnectorName(String connectorName) {
        this.connectorName = Objects.requireNonNull(connectorName);
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setActionName(String actionName) {
        this.actionName = Objects.requireNonNull(actionName);
    }

    public boolean isServer() {
        return this.server;
    }

    void setServer() {
        this.server = true;
    }

    public boolean isStarted() {
        return this.started;
    }

    void setStarted() {
        this.started = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished() {
        this.finished = true;
    }

    public ObserverContext getParent() {
        return this.parent;
    }

    public void setParent(ObserverContext parent) {
        this.parent = parent;
    }

    public boolean isSystemSpan() {
        return this.isSystemSpan;
    }

    public void setSystemSpan(boolean userSpan) {
        this.isSystemSpan = userSpan;
    }
}

