/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.program;

import java.io.PrintStream;
import java.math.BigDecimal;
import org.ballerinalang.bre.bvm.StackFrame;
import org.ballerinalang.bre.bvm.Strand;
import org.ballerinalang.bre.old.WorkerData;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BByte;
import org.ballerinalang.model.values.BDecimal;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.util.codegen.ServiceInfo;
import org.ballerinalang.util.program.WorkerDataIndex;

public class BLangVMUtils {
    public static final String SERVICE_INFO_KEY = "SERVICE_INFO";

    public static void populateWorkerDataWithValues(StackFrame data, int regIndex, BValue val, BType retType) {
        switch (retType.getTag()) {
            case 1: {
                if (val == null) {
                    data.longRegs[regIndex] = 0L;
                    break;
                }
                data.longRegs[regIndex] = ((BInteger)val).intValue();
                break;
            }
            case 2: {
                if (val == null) {
                    data.longRegs[regIndex] = 0L;
                    break;
                }
                data.longRegs[regIndex] = ((BByte)val).byteValue();
                break;
            }
            case 3: {
                if (val == null) {
                    data.doubleRegs[regIndex] = 0.0;
                    break;
                }
                data.doubleRegs[regIndex] = ((BFloat)val).floatValue();
                break;
            }
            case 4: {
                if (val == null) {
                    data.refRegs[regIndex] = new BDecimal(BigDecimal.ZERO);
                    break;
                }
                data.refRegs[regIndex] = (BDecimal)val;
                break;
            }
            case 5: {
                if (val == null) {
                    data.stringRegs[regIndex] = "";
                    break;
                }
                data.stringRegs[regIndex] = val.stringValue();
                break;
            }
            case 6: {
                if (val == null) {
                    data.intRegs[regIndex] = 0;
                    break;
                }
                data.intRegs[regIndex] = ((BBoolean)val).booleanValue() ? 1 : 0;
                break;
            }
            default: {
                data.refRegs[regIndex] = (BRefType)val;
            }
        }
    }

    public static WorkerData createWorkerData(WorkerDataIndex wdi) {
        return new WorkerData(wdi);
    }

    public static void mergeResultData(WorkerData sourceData, WorkerData targetData, BType[] types, int[] regIndexes) {
        int longRegCount = 0;
        int doubleRegCount = 0;
        int stringRegCount = 0;
        int intRegCount = 0;
        int refRegCount = 0;
        block6: for (int i = 0; i < types.length; ++i) {
            BType retType = types[i];
            int callersRetRegIndex = regIndexes[i];
            switch (retType.getTag()) {
                case 1: 
                case 2: {
                    targetData.longRegs[callersRetRegIndex] = sourceData.longRegs[longRegCount++];
                    continue block6;
                }
                case 3: {
                    targetData.doubleRegs[callersRetRegIndex] = sourceData.doubleRegs[doubleRegCount++];
                    continue block6;
                }
                case 5: {
                    targetData.stringRegs[callersRetRegIndex] = sourceData.stringRegs[stringRegCount++];
                    continue block6;
                }
                case 6: {
                    targetData.intRegs[callersRetRegIndex] = sourceData.intRegs[intRegCount++];
                    continue block6;
                }
                default: {
                    targetData.refRegs[callersRetRegIndex] = sourceData.refRegs[refRegCount++];
                }
            }
        }
    }

    public static void log(String msg) {
        PrintStream out = System.out;
        out.println(msg);
    }

    public static void setServiceInfo(Strand ctx, ServiceInfo serviceInfo) {
        ctx.globalProps.put(SERVICE_INFO_KEY, serviceInfo);
    }

    public static ServiceInfo getServiceInfo(Strand ctx) {
        return (ServiceInfo)ctx.globalProps.get(SERVICE_INFO_KEY);
    }
}

