/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.utils;

import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.util.exceptions.BLangFreezeException;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.RefValue;
import org.ballerinalang.jvm.values.freeze.State;
import org.ballerinalang.jvm.values.freeze.Status;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="utils", functionName="freeze", args={@Argument(name="value", type=TypeKind.ANYDATA)}, returnType={@ReturnType(type=TypeKind.ANYDATA), @ReturnType(type=TypeKind.ERROR)})
public class Freeze {
    public static Object freeze(Strand strand, Object value2) {
        if (value2 == null) {
            return null;
        }
        if (!(value2 instanceof RefValue)) {
            return value2;
        }
        RefValue refValue = (RefValue)value2;
        if (refValue.getType().getTag() == 29) {
            return BallerinaErrors.createError(BallerinaErrorReasons.FREEZE_ERROR, "'freeze()' not allowed on 'error'");
        }
        Status freezeStatus = new Status(State.MID_FREEZE);
        try {
            refValue.attemptFreeze(freezeStatus);
            freezeStatus.setFrozen();
            return refValue;
        }
        catch (BLangFreezeException e) {
            freezeStatus.setUnfrozen();
            return BallerinaErrors.createError(BallerinaErrorReasons.FREEZE_ERROR, e.getMessage());
        }
        catch (BallerinaException e) {
            freezeStatus.setUnfrozen();
            throw BallerinaErrors.createError(e.getMessage(), e.getDetail());
        }
    }
}

