/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.utils;

import java.util.ArrayList;
import java.util.function.Predicate;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.commons.TypeValuePair;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BUnionType;
import org.ballerinalang.jvm.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.util.exceptions.RuntimeErrors;
import org.ballerinalang.jvm.values.RefValue;
import org.ballerinalang.jvm.values.TypedescValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="utils", functionName="stamp", args={@Argument(name="convertType", type=TypeKind.TYPEDESC), @Argument(name="value", type=TypeKind.ANY)}, returnType={@ReturnType(type=TypeKind.ANYDATA), @ReturnType(type=TypeKind.ERROR)})
public class Stamp {
    public static Object stamp(Strand strand, TypedescValue typedescValue, Object valueToBeStamped) {
        BType targetType;
        BType stampType = typedescValue.getDescribingType();
        if (stampType.getTag() == 21) {
            ArrayList<BType> memberTypes = new ArrayList<BType>(((BUnionType)stampType).getMemberTypes());
            targetType = new BUnionType(memberTypes);
            Predicate<BType> errorPredicate = e -> e.getTag() == 29;
            ((BUnionType)targetType).getMemberTypes().removeIf(errorPredicate);
            if (((BUnionType)targetType).getMemberTypes().size() == 1) {
                targetType = ((BUnionType)stampType).getMemberTypes().get(0);
            }
        } else {
            targetType = stampType;
        }
        if (valueToBeStamped == null) {
            if (targetType.getTag() == 7) {
                return null;
            }
            return BallerinaErrors.createError(BallerinaErrorReasons.STAMP_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.CANNOT_STAMP_NULL, stampType));
        }
        if (!TypeChecker.checkIsLikeType(valueToBeStamped, targetType)) {
            return BallerinaErrors.createError(BallerinaErrorReasons.STAMP_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.INCOMPATIBLE_STAMP_OPERATION, TypeChecker.getType(valueToBeStamped), targetType));
        }
        try {
            if (valueToBeStamped instanceof RefValue) {
                ((RefValue)valueToBeStamped).stamp(targetType, new ArrayList<TypeValuePair>());
            }
        }
        catch (BallerinaException e2) {
            throw BallerinaErrors.createError(BallerinaErrorReasons.STAMP_ERROR, e2.getDetail());
        }
        return valueToBeStamped;
    }
}

