/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger;

import com.uber.jaeger.Tracer;
import com.uber.jaeger.metrics.Metrics;
import com.uber.jaeger.metrics.MetricsFactory;
import com.uber.jaeger.metrics.NoopMetricsFactory;
import com.uber.jaeger.metrics.StatsFactory;
import com.uber.jaeger.propagation.B3TextMapCodec;
import com.uber.jaeger.propagation.Codec;
import com.uber.jaeger.propagation.CompositeCodec;
import com.uber.jaeger.propagation.TextMapCodec;
import com.uber.jaeger.reporters.CompositeReporter;
import com.uber.jaeger.reporters.LoggingReporter;
import com.uber.jaeger.reporters.RemoteReporter;
import com.uber.jaeger.reporters.Reporter;
import com.uber.jaeger.samplers.ConstSampler;
import com.uber.jaeger.samplers.HttpSamplingManager;
import com.uber.jaeger.samplers.ProbabilisticSampler;
import com.uber.jaeger.samplers.RateLimitingSampler;
import com.uber.jaeger.samplers.RemoteControlledSampler;
import com.uber.jaeger.samplers.Sampler;
import com.uber.jaeger.senders.HttpSender;
import com.uber.jaeger.senders.Sender;
import com.uber.jaeger.senders.UdpSender;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class Configuration {
    private static final Logger log = LoggerFactory.getLogger(Configuration.class);
    @Deprecated
    public static final double DEFAULT_SAMPLING_PROBABILITY = 0.001;
    public static final String JAEGER_PREFIX = "JAEGER_";
    public static final String JAEGER_ENDPOINT = "JAEGER_ENDPOINT";
    public static final String JAEGER_AUTH_TOKEN = "JAEGER_AUTH_TOKEN";
    public static final String JAEGER_USER = "JAEGER_USER";
    public static final String JAEGER_PASSWORD = "JAEGER_PASSWORD";
    public static final String JAEGER_AGENT_HOST = "JAEGER_AGENT_HOST";
    public static final String JAEGER_AGENT_PORT = "JAEGER_AGENT_PORT";
    public static final String JAEGER_REPORTER_LOG_SPANS = "JAEGER_REPORTER_LOG_SPANS";
    public static final String JAEGER_REPORTER_MAX_QUEUE_SIZE = "JAEGER_REPORTER_MAX_QUEUE_SIZE";
    public static final String JAEGER_REPORTER_FLUSH_INTERVAL = "JAEGER_REPORTER_FLUSH_INTERVAL";
    public static final String JAEGER_SAMPLER_TYPE = "JAEGER_SAMPLER_TYPE";
    public static final String JAEGER_SAMPLER_PARAM = "JAEGER_SAMPLER_PARAM";
    public static final String JAEGER_SAMPLER_MANAGER_HOST_PORT = "JAEGER_SAMPLER_MANAGER_HOST_PORT";
    public static final String JAEGER_SERVICE_NAME = "JAEGER_SERVICE_NAME";
    public static final String JAEGER_TAGS = "JAEGER_TAGS";
    public static final String JAEGER_PROPAGATION = "JAEGER_PROPAGATION";
    private final String serviceName;
    private SamplerConfiguration samplerConfig;
    private ReporterConfiguration reporterConfig;
    private CodecConfiguration codecConfig;
    private MetricsFactory metricsFactory;
    private Map<String, String> tracerTags;
    private Tracer tracer;

    public Configuration(String serviceName) {
        this.serviceName = Tracer.Builder.checkValidServiceName(serviceName);
    }

    @Deprecated
    public Configuration(String serviceName, SamplerConfiguration samplerConfig, ReporterConfiguration reporterConfig) {
        this(serviceName, samplerConfig, reporterConfig, null);
    }

    @Deprecated
    private Configuration(String serviceName, SamplerConfiguration samplerConfig, ReporterConfiguration reporterConfig, CodecConfiguration codecConfig) {
        this(serviceName);
        this.samplerConfig = samplerConfig;
        this.reporterConfig = reporterConfig;
        this.codecConfig = codecConfig;
        this.metricsFactory = new NoopMetricsFactory();
    }

    public static Configuration fromEnv() {
        return new Configuration(Configuration.getProperty(JAEGER_SERVICE_NAME)).withTracerTags(Configuration.tracerTagsFromEnv()).withReporter(ReporterConfiguration.fromEnv()).withSampler(SamplerConfiguration.fromEnv()).withCodec(CodecConfiguration.fromEnv());
    }

    public Tracer.Builder getTracerBuilder() {
        if (this.reporterConfig == null) {
            this.reporterConfig = new ReporterConfiguration();
        }
        if (this.samplerConfig == null) {
            this.samplerConfig = new SamplerConfiguration();
        }
        if (this.codecConfig == null) {
            this.codecConfig = new CodecConfiguration(Collections.emptyMap());
        }
        if (this.metricsFactory == null) {
            this.metricsFactory = new NoopMetricsFactory();
        }
        Metrics metrics = new Metrics(this.metricsFactory);
        Reporter reporter2 = this.reporterConfig.getReporter(metrics);
        Sampler sampler = this.samplerConfig.createSampler(this.serviceName, metrics);
        Tracer.Builder builder = new Tracer.Builder(this.serviceName).withSampler(sampler).withReporter(reporter2).withMetrics(metrics).withTags(this.tracerTags);
        this.codecConfig.apply(builder);
        return builder;
    }

    public synchronized io.opentracing.Tracer getTracer() {
        if (this.tracer != null) {
            return this.tracer;
        }
        this.tracer = this.getTracerBuilder().build();
        log.info("Initialized tracer={}", (Object)this.tracer);
        return this.tracer;
    }

    public synchronized void closeTracer() {
        if (this.tracer != null) {
            this.tracer.close();
        }
    }

    @Deprecated
    public void setStatsFactor(StatsFactory statsFactory) {
        this.metricsFactory = statsFactory;
    }

    @Deprecated
    public void setStatsFactory(StatsFactory statsFactory) {
        this.metricsFactory = statsFactory;
    }

    public void withMetricsFactory(MetricsFactory metricsFactory) {
        this.metricsFactory = metricsFactory;
    }

    public Configuration withReporter(ReporterConfiguration reporterConfig) {
        this.reporterConfig = reporterConfig;
        return this;
    }

    public Configuration withSampler(SamplerConfiguration samplerConfig) {
        this.samplerConfig = samplerConfig;
        return this;
    }

    public Configuration withCodec(CodecConfiguration codecConfig) {
        this.codecConfig = codecConfig;
        return this;
    }

    public Configuration withTracerTags(Map<String, String> tracerTags) {
        if (tracerTags != null) {
            this.tracerTags = new HashMap<String, String>(tracerTags);
        }
        return this;
    }

    public ReporterConfiguration getReporter() {
        return this.reporterConfig;
    }

    public SamplerConfiguration getSampler() {
        return this.samplerConfig;
    }

    public Map<String, String> getTracerTags() {
        return this.tracerTags == null ? null : Collections.unmodifiableMap(this.tracerTags);
    }

    private static String stringOrDefault(String value2, String defaultValue) {
        return value2 != null && value2.length() > 0 ? value2 : defaultValue;
    }

    private static Number numberOrDefault(Number value2, Number defaultValue) {
        return value2 != null ? (Number)value2 : (Number)defaultValue;
    }

    private static String getProperty(String name) {
        return System.getProperty(name, System.getenv(name));
    }

    private static Integer getPropertyAsInt(String name) {
        String value2 = Configuration.getProperty(name);
        if (value2 != null) {
            try {
                return Integer.parseInt(value2);
            }
            catch (NumberFormatException e) {
                log.error("Failed to parse integer for property '" + name + "' with value '" + value2 + "'", e);
            }
        }
        return null;
    }

    private static Number getPropertyAsNum(String name) {
        String value2 = Configuration.getProperty(name);
        if (value2 != null) {
            try {
                return NumberFormat.getInstance().parse(value2);
            }
            catch (ParseException e) {
                log.error("Failed to parse number for property '" + name + "' with value '" + value2 + "'", e);
            }
        }
        return null;
    }

    private static boolean getPropertyAsBool(String name) {
        return Boolean.valueOf(Configuration.getProperty(name));
    }

    private static Map<String, String> tracerTagsFromEnv() {
        HashMap<String, String> tracerTagMaps = null;
        String tracerTags = Configuration.getProperty(JAEGER_TAGS);
        if (tracerTags != null) {
            String[] tags;
            for (String tag : tags = tracerTags.split("\\s*,\\s*")) {
                String[] tagValue = tag.split("\\s*=\\s*");
                if (tagValue.length == 2) {
                    if (tracerTagMaps == null) {
                        tracerTagMaps = new HashMap<String, String>();
                    }
                    tracerTagMaps.put(tagValue[0], Configuration.resolveValue(tagValue[1]));
                    continue;
                }
                log.error("Tracer tag incorrectly formatted: " + tag);
            }
        }
        return tracerTagMaps;
    }

    private static String resolveValue(String value2) {
        String[] ref;
        if (value2.startsWith("${") && value2.endsWith("}") && (ref = value2.substring(2, value2.length() - 1).split("\\s*:\\s*")).length > 0) {
            String propertyValue = Configuration.getProperty(ref[0]);
            if (propertyValue == null && ref.length > 1) {
                propertyValue = ref[1];
            }
            return propertyValue;
        }
        return value2;
    }

    public static class SenderConfiguration {
        private Sender sender;
        private String agentHost;
        private Integer agentPort;
        private String endpoint;
        private String authToken;
        private String authUsername;
        private String authPassword;

        public SenderConfiguration() {
        }

        private SenderConfiguration(Builder builder) {
            this.sender = builder.sender;
            this.agentHost = builder.agentHost;
            this.agentPort = builder.agentPort;
            this.endpoint = builder.endpoint;
            this.authToken = builder.authToken;
            this.authUsername = builder.authUsername;
            this.authPassword = builder.authPassword;
        }

        public SenderConfiguration withAgentHost(String agentHost) {
            this.agentHost = agentHost;
            return this;
        }

        public SenderConfiguration withAgentPort(Integer agentPort) {
            this.agentPort = agentPort;
            return this;
        }

        public SenderConfiguration withEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public SenderConfiguration withAuthToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        public SenderConfiguration withAuthUsername(String username) {
            this.authUsername = username;
            return this;
        }

        public SenderConfiguration withAuthPassword(String password) {
            this.authPassword = password;
            return this;
        }

        public Sender getSender() {
            if (null != this.sender) {
                return this.sender;
            }
            if (null != this.endpoint && !this.endpoint.isEmpty()) {
                HttpSender.Builder httpSenderBuilder = new HttpSender.Builder(this.endpoint);
                if (null != this.authUsername && !this.authUsername.isEmpty() && null != this.authPassword && !this.authPassword.isEmpty()) {
                    log.debug("Using HTTP Basic authentication with data from the environment variables.");
                    httpSenderBuilder.withAuth(this.authUsername, this.authPassword);
                } else if (null != this.authToken && !this.authToken.isEmpty()) {
                    log.debug("Auth Token environment variable found.");
                    httpSenderBuilder.withAuth(this.authToken);
                }
                log.debug("Using the HTTP Sender to send spans directly to the endpoint.");
                return httpSenderBuilder.build();
            }
            log.debug("Using the UDP Sender to send spans to the agent.");
            return new UdpSender(Configuration.stringOrDefault(this.agentHost, "localhost"), Configuration.numberOrDefault(this.agentPort, 6831).intValue(), 0);
        }

        public static SenderConfiguration fromEnv() {
            String agentHost = Configuration.getProperty(Configuration.JAEGER_AGENT_HOST);
            Integer agentPort = Configuration.getPropertyAsInt(Configuration.JAEGER_AGENT_PORT);
            String collectorEndpoint = Configuration.getProperty(Configuration.JAEGER_ENDPOINT);
            String authToken = Configuration.getProperty(Configuration.JAEGER_AUTH_TOKEN);
            String authUsername = Configuration.getProperty(Configuration.JAEGER_USER);
            String authPassword = Configuration.getProperty(Configuration.JAEGER_PASSWORD);
            return new SenderConfiguration().withAgentHost(agentHost).withAgentPort(agentPort).withEndpoint(collectorEndpoint).withAuthToken(authToken).withAuthUsername(authUsername).withAuthPassword(authPassword);
        }

        public String getAgentHost() {
            return this.agentHost;
        }

        public Integer getAgentPort() {
            return this.agentPort;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public String getAuthToken() {
            return this.authToken;
        }

        public String getAuthUsername() {
            return this.authUsername;
        }

        public String getAuthPassword() {
            return this.authPassword;
        }

        @Deprecated
        public static class Builder {
            private Sender sender;
            private String agentHost = null;
            private Integer agentPort = null;
            private String endpoint = null;
            private String authToken = null;
            private String authUsername = null;
            private String authPassword = null;

            @Deprecated
            public Builder sender(Sender sender) {
                this.sender = sender;
                return this;
            }

            @Deprecated
            public Builder agentHost(String agentHost) {
                this.agentHost = agentHost;
                return this;
            }

            @Deprecated
            public Builder agentPort(Integer agentPort) {
                this.agentPort = agentPort;
                return this;
            }

            @Deprecated
            public Builder endpoint(String endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            @Deprecated
            public Builder authToken(String authToken) {
                this.authToken = authToken;
                return this;
            }

            @Deprecated
            public Builder authUsername(String authUsername) {
                this.authUsername = authUsername;
                return this;
            }

            @Deprecated
            public Builder authPassword(String authPassword) {
                this.authPassword = authPassword;
                return this;
            }

            @Deprecated
            public SenderConfiguration build() {
                return new SenderConfiguration(this);
            }
        }
    }

    public static class ReporterConfiguration {
        private Boolean logSpans;
        private Integer flushIntervalMs;
        private Integer maxQueueSize;
        private SenderConfiguration senderConfiguration = new SenderConfiguration();

        public ReporterConfiguration() {
        }

        @Deprecated
        public ReporterConfiguration(Sender sender) {
            this.senderConfiguration = new SenderConfiguration.Builder().sender(sender).build();
        }

        @Deprecated
        public ReporterConfiguration(Boolean logSpans, String agentHost, Integer agentPort, Integer flushIntervalMs, Integer maxQueueSize) {
            this.logSpans = logSpans;
            this.flushIntervalMs = flushIntervalMs;
            this.maxQueueSize = maxQueueSize;
            this.senderConfiguration.withAgentHost(agentHost).withAgentPort(agentPort);
        }

        @Deprecated
        public ReporterConfiguration(Boolean logSpans, Integer flushIntervalMs, Integer maxQueueSize, SenderConfiguration senderConfiguration) {
            this.logSpans = logSpans;
            this.flushIntervalMs = flushIntervalMs;
            this.maxQueueSize = maxQueueSize;
            this.senderConfiguration = senderConfiguration;
        }

        public static ReporterConfiguration fromEnv() {
            return new ReporterConfiguration().withLogSpans(Configuration.getPropertyAsBool(Configuration.JAEGER_REPORTER_LOG_SPANS)).withFlushInterval(Configuration.getPropertyAsInt(Configuration.JAEGER_REPORTER_FLUSH_INTERVAL)).withMaxQueueSize(Configuration.getPropertyAsInt(Configuration.JAEGER_REPORTER_MAX_QUEUE_SIZE)).withSender(SenderConfiguration.fromEnv());
        }

        public ReporterConfiguration withLogSpans(Boolean logSpans) {
            this.logSpans = logSpans;
            return this;
        }

        public ReporterConfiguration withFlushInterval(Integer flushIntervalMs) {
            this.flushIntervalMs = flushIntervalMs;
            return this;
        }

        public ReporterConfiguration withMaxQueueSize(Integer maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
            return this;
        }

        public ReporterConfiguration withSender(SenderConfiguration senderConfiguration) {
            this.senderConfiguration = senderConfiguration;
            return this;
        }

        private Reporter getReporter(Metrics metrics) {
            Reporter reporter2 = new RemoteReporter.Builder().withMetrics(metrics).withSender(this.senderConfiguration.getSender()).withFlushInterval(Configuration.numberOrDefault(this.flushIntervalMs, 1000).intValue()).withMaxQueueSize(Configuration.numberOrDefault(this.maxQueueSize, 100).intValue()).build();
            if (Boolean.TRUE.equals(this.logSpans)) {
                LoggingReporter loggingReporter = new LoggingReporter();
                reporter2 = new CompositeReporter(reporter2, loggingReporter);
            }
            return reporter2;
        }

        public Boolean getLogSpans() {
            return this.logSpans;
        }

        @Deprecated
        public String getAgentHost() {
            if (null == this.senderConfiguration) {
                return null;
            }
            return this.senderConfiguration.agentHost;
        }

        @Deprecated
        public Integer getAgentPort() {
            if (null == this.senderConfiguration) {
                return null;
            }
            return this.senderConfiguration.agentPort;
        }

        public Integer getFlushIntervalMs() {
            return this.flushIntervalMs;
        }

        public Integer getMaxQueueSize() {
            return this.maxQueueSize;
        }

        public SenderConfiguration getSenderConfiguration() {
            return this.senderConfiguration;
        }
    }

    public static class CodecConfiguration {
        private Map<Format<?>, List<Codec<TextMap>>> codecs;

        private CodecConfiguration(Map<Format<?>, List<Codec<TextMap>>> codecs) {
            this.codecs = codecs;
        }

        public static CodecConfiguration fromEnv() {
            HashMap codecs = new HashMap();
            String propagation = Configuration.getProperty(Configuration.JAEGER_PROPAGATION);
            if (propagation != null) {
                for (String format : Arrays.asList(propagation.split(","))) {
                    try {
                        switch (Propagation.valueOf(format.toUpperCase())) {
                            case JAEGER: {
                                CodecConfiguration.addCodec(codecs, Format.Builtin.HTTP_HEADERS, new TextMapCodec(true));
                                CodecConfiguration.addCodec(codecs, Format.Builtin.TEXT_MAP, new TextMapCodec(false));
                                break;
                            }
                            case B3: {
                                CodecConfiguration.addCodec(codecs, Format.Builtin.HTTP_HEADERS, new B3TextMapCodec());
                                CodecConfiguration.addCodec(codecs, Format.Builtin.TEXT_MAP, new B3TextMapCodec());
                                break;
                            }
                            default: {
                                log.error("Unhandled propagation format '" + format + "'");
                                break;
                            }
                        }
                    }
                    catch (IllegalArgumentException iae) {
                        log.error("Unknown propagation format '" + format + "'");
                    }
                }
            }
            return new CodecConfiguration(codecs);
        }

        private static void addCodec(Map<Format<?>, List<Codec<TextMap>>> codecs, Format<?> format, Codec<TextMap> codec) {
            List<Codec<TextMap>> codecList = codecs.get(format);
            if (codecList == null) {
                codecList = new LinkedList<Codec<TextMap>>();
                codecs.put(format, codecList);
            }
            codecList.add(codec);
        }

        public void apply(Tracer.Builder builder) {
            this.registerCodec(builder, Format.Builtin.HTTP_HEADERS);
            this.registerCodec(builder, Format.Builtin.TEXT_MAP);
        }

        protected void registerCodec(Tracer.Builder builder, Format<TextMap> format) {
            if (this.codecs.containsKey(format)) {
                List codecsForFormat = this.codecs.get(format);
                Codec<Object> codec = codecsForFormat.size() == 1 ? codecsForFormat.get(0) : new CompositeCodec(codecsForFormat);
                builder.registerInjector(format, codec);
                builder.registerExtractor(format, codec);
            }
        }
    }

    public static class SamplerConfiguration {
        private String type;
        private Number param;
        private String managerHostPort;

        public SamplerConfiguration() {
        }

        @Deprecated
        public SamplerConfiguration(String type, Number param) {
            this(type, param, null);
        }

        @Deprecated
        public SamplerConfiguration(String type, Number param, String managerHostPort) {
            this.type = type;
            this.param = param;
            this.managerHostPort = managerHostPort;
        }

        public static SamplerConfiguration fromEnv() {
            return new SamplerConfiguration().withType(Configuration.getProperty(Configuration.JAEGER_SAMPLER_TYPE)).withParam(Configuration.getPropertyAsNum(Configuration.JAEGER_SAMPLER_PARAM)).withManagerHostPort(Configuration.getProperty(Configuration.JAEGER_SAMPLER_MANAGER_HOST_PORT));
        }

        Sampler createSampler(String serviceName, Metrics metrics) {
            String samplerType = Configuration.stringOrDefault(this.getType(), "remote");
            Number samplerParam = Configuration.numberOrDefault(this.getParam(), 0.001);
            String hostPort = Configuration.stringOrDefault(this.getManagerHostPort(), "localhost:5778");
            if (samplerType.equals("const")) {
                return new ConstSampler(samplerParam.intValue() != 0);
            }
            if (samplerType.equals("probabilistic")) {
                return new ProbabilisticSampler(samplerParam.doubleValue());
            }
            if (samplerType.equals("ratelimiting")) {
                return new RateLimitingSampler(samplerParam.intValue());
            }
            if (samplerType.equals("remote")) {
                return new RemoteControlledSampler.Builder(serviceName).withSamplingManager(new HttpSamplingManager(hostPort)).withInitialSampler(new ProbabilisticSampler(samplerParam.doubleValue())).withMetrics(metrics).build();
            }
            throw new IllegalStateException(String.format("Invalid sampling strategy %s", samplerType));
        }

        public String getType() {
            return this.type;
        }

        public Number getParam() {
            return this.param;
        }

        public String getManagerHostPort() {
            return this.managerHostPort;
        }

        public SamplerConfiguration withType(String type) {
            this.type = type;
            return this;
        }

        public SamplerConfiguration withParam(Number param) {
            this.param = param;
            return this;
        }

        public SamplerConfiguration withManagerHostPort(String managerHostPort) {
            this.managerHostPort = managerHostPort;
            return this;
        }
    }

    public static enum Propagation {
        JAEGER,
        B3;

    }
}

