/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger;

import com.uber.jaeger.PropagationRegistry;
import com.uber.jaeger.Reference;
import com.uber.jaeger.Span;
import com.uber.jaeger.SpanContext;
import com.uber.jaeger.baggage.BaggageRestrictionManager;
import com.uber.jaeger.baggage.BaggageSetter;
import com.uber.jaeger.baggage.DefaultBaggageRestrictionManager;
import com.uber.jaeger.exceptions.EmptyIpException;
import com.uber.jaeger.exceptions.NotFourOctetsException;
import com.uber.jaeger.exceptions.UnsupportedFormatException;
import com.uber.jaeger.metrics.Metrics;
import com.uber.jaeger.metrics.MetricsFactory;
import com.uber.jaeger.metrics.NoopMetricsFactory;
import com.uber.jaeger.metrics.StatsFactoryImpl;
import com.uber.jaeger.metrics.StatsReporter;
import com.uber.jaeger.propagation.Extractor;
import com.uber.jaeger.propagation.Injector;
import com.uber.jaeger.propagation.TextMapCodec;
import com.uber.jaeger.reporters.RemoteReporter;
import com.uber.jaeger.reporters.Reporter;
import com.uber.jaeger.samplers.RemoteControlledSampler;
import com.uber.jaeger.samplers.Sampler;
import com.uber.jaeger.samplers.SamplingStatus;
import com.uber.jaeger.utils.Clock;
import com.uber.jaeger.utils.SystemClock;
import com.uber.jaeger.utils.Utils;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import io.opentracing.util.ThreadLocalScopeManager;
import java.io.Closeable;
import java.io.InputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class Tracer
implements io.opentracing.Tracer,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(Tracer.class);
    private final String version;
    private final String serviceName;
    private final Reporter reporter;
    private final Sampler sampler;
    private final PropagationRegistry registry;
    private final Clock clock;
    private final Metrics metrics;
    private final int ipv4;
    private final Map<String, ?> tags;
    private final boolean zipkinSharedRpcSpan;
    private final ScopeManager scopeManager;
    private final BaggageSetter baggageSetter;
    private final boolean expandExceptionLogs;

    private Tracer(String serviceName, Reporter reporter2, Sampler sampler, PropagationRegistry registry, Clock clock, Metrics metrics, Map<String, Object> tags, boolean zipkinSharedRpcSpan, ScopeManager scopeManager, BaggageRestrictionManager baggageRestrictionManager, boolean expandExceptionLogs) {
        int ipv4;
        Object ipTag;
        String hostname;
        this.serviceName = serviceName;
        this.reporter = reporter2;
        this.sampler = sampler;
        this.registry = registry;
        this.clock = clock;
        this.metrics = metrics;
        this.zipkinSharedRpcSpan = zipkinSharedRpcSpan;
        this.scopeManager = scopeManager;
        this.baggageSetter = new BaggageSetter(baggageRestrictionManager, metrics);
        this.expandExceptionLogs = expandExceptionLogs;
        this.version = Tracer.loadVersion();
        tags.put("jaeger.version", this.version);
        if (tags.get("hostname") == null && (hostname = this.getHostName()) != null) {
            tags.put("hostname", hostname);
        }
        if ((ipTag = tags.get("ip")) == null) {
            try {
                tags.put("ip", InetAddress.getLocalHost().getHostAddress());
                ipv4 = Utils.ipToInt(Inet4Address.getLocalHost().getHostAddress());
            }
            catch (UnknownHostException e) {
                ipv4 = 0;
            }
        } else {
            try {
                ipv4 = Utils.ipToInt(ipTag.toString());
            }
            catch (EmptyIpException e) {
                ipv4 = 0;
            }
            catch (NotFourOctetsException e) {
                ipv4 = 0;
            }
        }
        this.ipv4 = ipv4;
        this.tags = Collections.unmodifiableMap(tags);
    }

    public String getVersion() {
        return this.version;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Map<String, ?> tags() {
        return this.tags;
    }

    public int getIpv4() {
        return this.ipv4;
    }

    Clock clock() {
        return this.clock;
    }

    Reporter getReporter() {
        return this.reporter;
    }

    void reportSpan(Span span) {
        this.reporter.report(span);
        this.metrics.spansFinished.inc(1L);
    }

    @Override
    public ScopeManager scopeManager() {
        return this.scopeManager;
    }

    @Override
    public io.opentracing.Span activeSpan() {
        Scope scope = this.scopeManager.active();
        return scope == null ? null : scope.span();
    }

    @Override
    public Tracer.SpanBuilder buildSpan(String operationName) {
        return new SpanBuilder(operationName);
    }

    public <T> void inject(io.opentracing.SpanContext spanContext, Format<T> format, T carrier) {
        Injector<T> injector = this.registry.getInjector(format);
        if (injector == null) {
            throw new UnsupportedFormatException(format);
        }
        injector.inject((SpanContext)spanContext, carrier);
    }

    public <T> io.opentracing.SpanContext extract(Format<T> format, T carrier) {
        Extractor<T> extractor = this.registry.getExtractor(format);
        if (extractor == null) {
            throw new UnsupportedFormatException(format);
        }
        return extractor.extract(carrier);
    }

    @Override
    public void close() {
        this.reporter.close();
        this.sampler.close();
    }

    private static String loadVersion() {
        String version;
        try {
            InputStream is = Tracer.class.getResourceAsStream("jaeger.properties");
            try {
                Properties prop = new Properties();
                prop.load(is);
                version = prop.getProperty("jaeger.version");
            }
            finally {
                is.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot read jaeger.properties", e);
        }
        if (version == null) {
            throw new RuntimeException("Cannot read jaeger.version from jaeger.properties");
        }
        return "Java-" + version;
    }

    String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            log.error("Cannot obtain host name", e);
            return null;
        }
    }

    SpanContext setBaggage(Span span, String key, String value2) {
        return this.baggageSetter.setBaggage(span, key, value2);
    }

    boolean isExpandExceptionLogs() {
        return this.expandExceptionLogs;
    }

    public String toString() {
        return "Tracer(version=" + this.getVersion() + ", serviceName=" + this.getServiceName() + ", reporter=" + this.getReporter() + ", sampler=" + this.sampler + ", ipv4=" + this.getIpv4() + ", tags=" + this.tags + ", zipkinSharedRpcSpan=" + this.zipkinSharedRpcSpan + ", baggageSetter=" + this.baggageSetter + ", expandExceptionLogs=" + this.isExpandExceptionLogs() + ")";
    }

    @Deprecated
    public static final class Builder {
        private Sampler sampler;
        private Reporter reporter;
        private final PropagationRegistry registry = new PropagationRegistry();
        private Metrics metrics = new Metrics(new NoopMetricsFactory());
        private final String serviceName;
        private Clock clock = new SystemClock();
        private Map<String, Object> tags = new HashMap<String, Object>();
        private boolean zipkinSharedRpcSpan;
        private ScopeManager scopeManager = new ThreadLocalScopeManager();
        private BaggageRestrictionManager baggageRestrictionManager = new DefaultBaggageRestrictionManager();
        private boolean expandExceptionLogs;

        public Builder(String serviceName) {
            this.serviceName = Builder.checkValidServiceName(serviceName);
            TextMapCodec textMapCodec = new TextMapCodec(false);
            this.registerInjector(Format.Builtin.TEXT_MAP, textMapCodec);
            this.registerExtractor(Format.Builtin.TEXT_MAP, textMapCodec);
            TextMapCodec httpCodec = new TextMapCodec(true);
            this.registerInjector(Format.Builtin.HTTP_HEADERS, httpCodec);
            this.registerExtractor(Format.Builtin.HTTP_HEADERS, httpCodec);
        }

        @Deprecated
        public Builder(String serviceName, Reporter reporter2, Sampler sampler) {
            this(serviceName);
            this.reporter = reporter2;
            this.sampler = sampler;
        }

        public Builder withReporter(Reporter reporter2) {
            this.reporter = reporter2;
            return this;
        }

        public Builder withSampler(Sampler sampler) {
            this.sampler = sampler;
            return this;
        }

        public <T> Builder registerInjector(Format<T> format, Injector<T> injector) {
            this.registry.register(format, injector);
            return this;
        }

        public <T> Builder registerExtractor(Format<T> format, Extractor<T> extractor) {
            this.registry.register(format, extractor);
            return this;
        }

        @Deprecated
        public Builder withStatsReporter(StatsReporter statsReporter) {
            this.metrics = new Metrics(new StatsFactoryImpl(statsReporter));
            return this;
        }

        public Builder withMetricsFactory(MetricsFactory metricsFactory) {
            this.metrics = new Metrics(metricsFactory);
            return this;
        }

        public Builder withScopeManager(ScopeManager scopeManager) {
            this.scopeManager = scopeManager;
            return this;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder withZipkinSharedRpcSpan() {
            this.zipkinSharedRpcSpan = true;
            return this;
        }

        public Builder withExpandExceptionLogs() {
            this.expandExceptionLogs = true;
            return this;
        }

        public Builder withMetrics(Metrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public Builder withTag(String key, String value2) {
            this.tags.put(key, value2);
            return this;
        }

        public Builder withTag(String key, boolean value2) {
            this.tags.put(key, value2);
            return this;
        }

        public Builder withTag(String key, Number value2) {
            this.tags.put(key, value2);
            return this;
        }

        public Builder withTags(Map<String, String> tags) {
            if (tags != null) {
                this.tags.putAll(tags);
            }
            return this;
        }

        public Builder withBaggageRestrictionManager(BaggageRestrictionManager baggageRestrictionManager) {
            this.baggageRestrictionManager = baggageRestrictionManager;
            return this;
        }

        public Tracer build() {
            if (this.reporter == null) {
                this.reporter = new RemoteReporter.Builder().withMetrics(this.metrics).build();
            }
            if (this.sampler == null) {
                this.sampler = new RemoteControlledSampler.Builder(this.serviceName).withMetrics(this.metrics).build();
            }
            return new Tracer(this.serviceName, this.reporter, this.sampler, this.registry, this.clock, this.metrics, this.tags, this.zipkinSharedRpcSpan, this.scopeManager, this.baggageRestrictionManager, this.expandExceptionLogs);
        }

        public static String checkValidServiceName(String serviceName) {
            if (serviceName == null || serviceName.trim().length() == 0) {
                throw new IllegalArgumentException("Service name must not be null or empty");
            }
            return serviceName;
        }
    }

    class SpanBuilder
    implements Tracer.SpanBuilder {
        private String operationName = null;
        private long startTimeMicroseconds;
        private List<Reference> references = Collections.emptyList();
        private final Map<String, Object> tags = new HashMap<String, Object>();
        private boolean ignoreActiveSpan = false;

        SpanBuilder(String operationName) {
            this.operationName = operationName;
        }

        @Override
        public Tracer.SpanBuilder asChildOf(io.opentracing.SpanContext parent) {
            return this.addReference("child_of", parent);
        }

        @Override
        public Tracer.SpanBuilder asChildOf(io.opentracing.Span parent) {
            return this.addReference("child_of", parent != null ? parent.context() : null);
        }

        @Override
        public Tracer.SpanBuilder addReference(String referenceType, io.opentracing.SpanContext referencedContext) {
            if (!(referencedContext instanceof SpanContext)) {
                return this;
            }
            if (!"child_of".equals(referenceType) && !"follows_from".equals(referenceType)) {
                return this;
            }
            if (this.references.isEmpty()) {
                this.references = Collections.singletonList(new Reference((SpanContext)referencedContext, referenceType));
            } else {
                if (this.references.size() == 1) {
                    this.references = new ArrayList<Reference>(this.references);
                }
                this.references.add(new Reference((SpanContext)referencedContext, referenceType));
            }
            return this;
        }

        @Override
        public Tracer.SpanBuilder withTag(String key, String value2) {
            this.tags.put(key, value2);
            return this;
        }

        @Override
        public Tracer.SpanBuilder withTag(String key, boolean value2) {
            this.tags.put(key, value2);
            return this;
        }

        @Override
        public Tracer.SpanBuilder withTag(String key, Number value2) {
            this.tags.put(key, value2);
            return this;
        }

        @Override
        public Tracer.SpanBuilder withStartTimestamp(long microseconds) {
            this.startTimeMicroseconds = microseconds;
            return this;
        }

        private SpanContext createNewContext(String debugId) {
            long id = Utils.uniqueId();
            byte flags = 0;
            if (debugId != null) {
                flags = (byte)(flags | 1 | 2);
                this.tags.put("jaeger-debug-id", debugId);
                ((Tracer)Tracer.this).metrics.traceStartedSampled.inc(1L);
            } else {
                SamplingStatus samplingStatus = Tracer.this.sampler.sample(this.operationName, id);
                if (samplingStatus.isSampled()) {
                    flags = (byte)(flags | 1);
                    this.tags.putAll(samplingStatus.getTags());
                    ((Tracer)Tracer.this).metrics.traceStartedSampled.inc(1L);
                } else {
                    ((Tracer)Tracer.this).metrics.traceStartedNotSampled.inc(1L);
                }
            }
            return new SpanContext(id, id, 0L, flags);
        }

        private Map<String, String> createChildBaggage() {
            HashMap<String, String> baggage = null;
            if (this.references.size() == 1) {
                return this.references.get(0).getSpanContext().baggage();
            }
            for (Reference reference : this.references) {
                if (reference.getSpanContext().baggage() == null) continue;
                if (baggage == null) {
                    baggage = new HashMap<String, String>();
                }
                baggage.putAll(reference.getSpanContext().baggage());
            }
            return baggage;
        }

        private SpanContext createChildContext() {
            SpanContext preferredReference = this.preferredReference();
            if (this.isRpcServer()) {
                if (this.isSampled()) {
                    ((Tracer)Tracer.this).metrics.tracesJoinedSampled.inc(1L);
                } else {
                    ((Tracer)Tracer.this).metrics.tracesJoinedNotSampled.inc(1L);
                }
                if (Tracer.this.zipkinSharedRpcSpan) {
                    return preferredReference;
                }
            }
            return new SpanContext(preferredReference.getTraceId(), Utils.uniqueId(), preferredReference.getSpanId(), preferredReference.getFlags(), this.createChildBaggage(), null);
        }

        boolean isRpcServer() {
            return "server".equals(this.tags.get(Tags.SPAN_KIND.getKey()));
        }

        private SpanContext preferredReference() {
            Reference preferredReference = this.references.get(0);
            for (Reference reference : this.references) {
                if (!"child_of".equals(reference.getType()) || "child_of".equals(preferredReference.getType())) continue;
                preferredReference = reference;
                break;
            }
            return preferredReference.getSpanContext();
        }

        private boolean isSampled() {
            if (this.references != null) {
                for (Reference reference : this.references) {
                    if (!reference.getSpanContext().isSampled()) continue;
                    return true;
                }
            }
            return false;
        }

        private String debugId() {
            if (this.references.size() == 1 && this.references.get(0).getSpanContext().isDebugIdContainerOnly()) {
                return this.references.get(0).getSpanContext().getDebugId();
            }
            return null;
        }

        @Override
        public io.opentracing.Span start() {
            if (this.references.isEmpty() && !this.ignoreActiveSpan && null != Tracer.this.scopeManager.active()) {
                this.asChildOf(Tracer.this.scopeManager.active().span());
            }
            String debugId = this.debugId();
            SpanContext context = this.references.isEmpty() ? this.createNewContext(null) : (debugId != null ? this.createNewContext(debugId) : this.createChildContext());
            long startTimeNanoTicks = 0L;
            boolean computeDurationViaNanoTicks = false;
            if (this.startTimeMicroseconds == 0L) {
                this.startTimeMicroseconds = Tracer.this.clock.currentTimeMicros();
                if (!Tracer.this.clock.isMicrosAccurate()) {
                    startTimeNanoTicks = Tracer.this.clock.currentNanoTicks();
                    computeDurationViaNanoTicks = true;
                }
            }
            Span span = new Span(Tracer.this, this.operationName, context, this.startTimeMicroseconds, startTimeNanoTicks, computeDurationViaNanoTicks, this.tags, this.references);
            if (context.isSampled()) {
                ((Tracer)Tracer.this).metrics.spansStartedSampled.inc(1L);
            } else {
                ((Tracer)Tracer.this).metrics.spansStartedNotSampled.inc(1L);
            }
            return span;
        }

        @Override
        public Scope startActive(boolean finishSpanOnClose) {
            return Tracer.this.scopeManager.activate(this.start(), finishSpanOnClose);
        }

        @Override
        public Tracer.SpanBuilder ignoreActiveSpan() {
            this.ignoreActiveSpan = true;
            return this;
        }

        @Override
        @Deprecated
        public io.opentracing.Span startManual() {
            return this.start();
        }
    }
}

