/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.utils;

import com.uber.jaeger.utils.Clock;
import com.uber.jaeger.utils.SystemClock;

public class RateLimiter {
    private final double creditsPerNanosecond;
    private final Clock clock;
    private double balance;
    private double maxBalance;
    private long lastTick;

    public RateLimiter(double creditsPerSecond, double maxBalance) {
        this(creditsPerSecond, maxBalance, new SystemClock());
    }

    public RateLimiter(double creditsPerSecond, double maxBalance, Clock clock) {
        this.clock = clock;
        this.balance = maxBalance;
        this.maxBalance = maxBalance;
        this.creditsPerNanosecond = creditsPerSecond / 1.0E9;
    }

    public boolean checkCredit(double itemCost) {
        long currentTime = this.clock.currentNanoTicks();
        double elapsedTime = currentTime - this.lastTick;
        this.lastTick = currentTime;
        this.balance += elapsedTime * this.creditsPerNanosecond;
        if (this.balance > this.maxBalance) {
            this.balance = this.maxBalance;
        }
        if (this.balance >= itemCost) {
            this.balance -= itemCost;
            return true;
        }
        return false;
    }
}

