/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import okio.-Platform;
import okio.-Util;
import okio.Buffer;
import okio.internal.ByteStringKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u001a\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 Z2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001ZB\u000f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0016J\b\u0010\u0018\u001a\u00020\u0010H\u0016J\u0011\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0000H\u0096\u0002J\u0015\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0010H\u0010\u00a2\u0006\u0002\b\u001dJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0004J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0000J\u0013\u0010!\u001a\u00020\u001f2\b\u0010\u001a\u001a\u0004\u0018\u00010\"H\u0096\u0002J\u0016\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\tH\u0087\u0002\u00a2\u0006\u0002\b&J\u0015\u0010&\u001a\u00020$2\u0006\u0010%\u001a\u00020\tH\u0007\u00a2\u0006\u0002\b'J\r\u0010(\u001a\u00020\tH\u0010\u00a2\u0006\u0002\b)J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010*\u001a\u00020\u0010H\u0016J\u001d\u0010+\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u0000H\u0010\u00a2\u0006\u0002\b-J\u0010\u0010.\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0000H\u0016J\u0010\u0010/\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0000H\u0016J\u0010\u00100\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0000H\u0016J\u001a\u00101\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00042\b\b\u0002\u00102\u001a\u00020\tH\u0017J\u001a\u00101\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u00102\u001a\u00020\tH\u0007J\r\u00103\u001a\u00020\u0004H\u0010\u00a2\u0006\u0002\b4J\u0015\u00105\u001a\u00020$2\u0006\u00106\u001a\u00020\tH\u0010\u00a2\u0006\u0002\b7J\u001a\u00108\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00042\b\b\u0002\u00102\u001a\u00020\tH\u0017J\u001a\u00108\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u00102\u001a\u00020\tH\u0007J\b\u00109\u001a\u00020\u0000H\u0016J(\u0010:\u001a\u00020\u001f2\u0006\u0010;\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010<\u001a\u00020\t2\u0006\u0010=\u001a\u00020\tH\u0016J(\u0010:\u001a\u00020\u001f2\u0006\u0010;\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\t2\u0006\u0010=\u001a\u00020\tH\u0016J\u0010\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0002J\b\u0010B\u001a\u00020\u0000H\u0016J\b\u0010C\u001a\u00020\u0000H\u0016J\b\u0010D\u001a\u00020\u0000H\u0016J\r\u0010\u000e\u001a\u00020\tH\u0007\u00a2\u0006\u0002\bEJ\u000e\u0010F\u001a\u00020\u001f2\u0006\u0010G\u001a\u00020\u0004J\u000e\u0010F\u001a\u00020\u001f2\u0006\u0010G\u001a\u00020\u0000J\u0010\u0010H\u001a\u00020\u00102\u0006\u0010I\u001a\u00020JH\u0016J\u001c\u0010K\u001a\u00020\u00002\b\b\u0002\u0010L\u001a\u00020\t2\b\b\u0002\u0010M\u001a\u00020\tH\u0017J\b\u0010N\u001a\u00020\u0000H\u0016J\b\u0010O\u001a\u00020\u0000H\u0016J\b\u0010P\u001a\u00020\u0004H\u0016J\b\u0010Q\u001a\u00020\u0010H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010R\u001a\u00020?2\u0006\u0010S\u001a\u00020TH\u0016J\u0015\u0010R\u001a\u00020?2\u0006\u0010U\u001a\u00020VH\u0010\u00a2\u0006\u0002\bWJ\u0010\u0010X\u001a\u00020?2\u0006\u0010S\u001a\u00020YH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u00020\t8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\t8G\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000bR \u0010\u000f\u001a\u0004\u0018\u00010\u00108\u0000@\u0000X\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006["}, d2={"Lokio/ByteString;", "Ljava/io/Serializable;", "", "data", "", "([B)V", "getData$jvm", "()[B", "hashCode", "", "getHashCode$jvm", "()I", "setHashCode$jvm", "(I)V", "size", "utf8", "", "getUtf8$jvm", "()Ljava/lang/String;", "setUtf8$jvm", "(Ljava/lang/String;)V", "asByteBuffer", "Ljava/nio/ByteBuffer;", "base64", "base64Url", "compareTo", "other", "digest", "algorithm", "digest$jvm", "endsWith", "", "suffix", "equals", "", "get", "", "index", "getByte", "-deprecated_getByte", "getSize", "getSize$jvm", "hex", "hmac", "key", "hmac$jvm", "hmacSha1", "hmacSha256", "hmacSha512", "indexOf", "fromIndex", "internalArray", "internalArray$jvm", "internalGet", "pos", "internalGet$jvm", "lastIndexOf", "md5", "rangeEquals", "offset", "otherOffset", "byteCount", "readObject", "", "in", "Ljava/io/ObjectInputStream;", "sha1", "sha256", "sha512", "-deprecated_size", "startsWith", "prefix", "string", "charset", "Ljava/nio/charset/Charset;", "substring", "beginIndex", "endIndex", "toAsciiLowercase", "toAsciiUppercase", "toByteArray", "toString", "write", "out", "Ljava/io/OutputStream;", "buffer", "Lokio/Buffer;", "write$jvm", "writeObject", "Ljava/io/ObjectOutputStream;", "Companion", "jvm"})
public class ByteString
implements Serializable,
Comparable<ByteString> {
    private transient int hashCode;
    @Nullable
    private transient String utf8;
    @NotNull
    private final byte[] data;
    private static final long serialVersionUID = 1L;
    @JvmField
    @NotNull
    public static final ByteString EMPTY;
    public static final Companion Companion;

    public final int getHashCode$jvm() {
        return this.hashCode;
    }

    public final void setHashCode$jvm(int n) {
        this.hashCode = n;
    }

    @Nullable
    public final String getUtf8$jvm() {
        return this.utf8;
    }

    public final void setUtf8$jvm(@Nullable String string2) {
        this.utf8 = string2;
    }

    @NotNull
    public String utf8() {
        return ByteStringKt.commonUtf8(this);
    }

    @NotNull
    public String string(@NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        byte[] byArray = this.data;
        return new String(byArray, charset);
    }

    @NotNull
    public String base64() {
        return ByteStringKt.commonBase64(this);
    }

    @NotNull
    public ByteString md5() {
        return this.digest$jvm("MD5");
    }

    @NotNull
    public ByteString sha1() {
        return this.digest$jvm("SHA-1");
    }

    @NotNull
    public ByteString sha256() {
        return this.digest$jvm("SHA-256");
    }

    @NotNull
    public ByteString sha512() {
        return this.digest$jvm("SHA-512");
    }

    @NotNull
    public ByteString digest$jvm(@NotNull String algorithm) {
        Intrinsics.checkParameterIsNotNull((Object)algorithm, (String)"algorithm");
        byte[] byArray = MessageDigest.getInstance(algorithm).digest(this.data);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"MessageDigest.getInstance(algorithm).digest(data)");
        return new ByteString(byArray);
    }

    @NotNull
    public ByteString hmacSha1(@NotNull ByteString key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.hmac$jvm("HmacSHA1", key);
    }

    @NotNull
    public ByteString hmacSha256(@NotNull ByteString key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.hmac$jvm("HmacSHA256", key);
    }

    @NotNull
    public ByteString hmacSha512(@NotNull ByteString key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.hmac$jvm("HmacSHA512", key);
    }

    @NotNull
    public ByteString hmac$jvm(@NotNull String algorithm, @NotNull ByteString key) {
        Intrinsics.checkParameterIsNotNull((Object)algorithm, (String)"algorithm");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        try {
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(key.toByteArray(), algorithm));
            byte[] byArray = mac.doFinal(this.data);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"mac.doFinal(data)");
            return new ByteString(byArray);
        }
        catch (InvalidKeyException e) {
            throw (Throwable)new IllegalArgumentException(e);
        }
    }

    @NotNull
    public String base64Url() {
        return ByteStringKt.commonBase64Url(this);
    }

    @NotNull
    public String hex() {
        return ByteStringKt.commonHex(this);
    }

    @NotNull
    public ByteString toAsciiLowercase() {
        return ByteStringKt.commonToAsciiLowercase(this);
    }

    @NotNull
    public ByteString toAsciiUppercase() {
        return ByteStringKt.commonToAsciiUppercase(this);
    }

    @JvmOverloads
    @NotNull
    public ByteString substring(int beginIndex, int endIndex) {
        return ByteStringKt.commonSubstring(this, beginIndex, endIndex);
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ ByteString substring$default(ByteString byteString, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: substring");
        }
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = byteString.size();
        }
        return byteString.substring(n, n2);
    }

    @JvmOverloads
    @NotNull
    public ByteString substring(int beginIndex) {
        return ByteString.substring$default(this, beginIndex, 0, 2, null);
    }

    @JvmOverloads
    @NotNull
    public ByteString substring() {
        return ByteString.substring$default(this, 0, 0, 3, null);
    }

    public byte internalGet$jvm(int pos) {
        return ByteStringKt.commonGetByte(this, pos);
    }

    @JvmName(name="getByte")
    public final byte getByte(int index) {
        return this.internalGet$jvm(index);
    }

    @JvmName(name="size")
    public final int size() {
        return this.getSize$jvm();
    }

    public int getSize$jvm() {
        return ByteStringKt.commonGetSize(this);
    }

    @NotNull
    public byte[] toByteArray() {
        return ByteStringKt.commonToByteArray(this);
    }

    @NotNull
    public byte[] internalArray$jvm() {
        return ByteStringKt.commonInternalArray(this);
    }

    @NotNull
    public ByteBuffer asByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.data).asReadOnlyBuffer();
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"ByteBuffer.wrap(data).asReadOnlyBuffer()");
        return byteBuffer;
    }

    public void write(@NotNull OutputStream out) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        out.write(this.data);
    }

    public void write$jvm(@NotNull Buffer buffer) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        buffer.write(this.data, 0, this.data.length);
    }

    public boolean rangeEquals(int offset, @NotNull ByteString other, int otherOffset, int byteCount) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return ByteStringKt.commonRangeEquals(this, offset, other, otherOffset, byteCount);
    }

    public boolean rangeEquals(int offset, @NotNull byte[] other, int otherOffset, int byteCount) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return ByteStringKt.commonRangeEquals(this, offset, other, otherOffset, byteCount);
    }

    public final boolean startsWith(@NotNull ByteString prefix) {
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        return ByteStringKt.commonStartsWith(this, prefix);
    }

    public final boolean startsWith(@NotNull byte[] prefix) {
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        return ByteStringKt.commonStartsWith(this, prefix);
    }

    public final boolean endsWith(@NotNull ByteString suffix) {
        Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
        return ByteStringKt.commonEndsWith(this, suffix);
    }

    public final boolean endsWith(@NotNull byte[] suffix) {
        Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
        return ByteStringKt.commonEndsWith(this, suffix);
    }

    @JvmOverloads
    public final int indexOf(@NotNull ByteString other, int fromIndex) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.indexOf(other.internalArray$jvm(), fromIndex);
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ int indexOf$default(ByteString byteString, ByteString byteString2, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: indexOf");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return byteString.indexOf(byteString2, n);
    }

    @JvmOverloads
    public final int indexOf(@NotNull ByteString other) {
        return ByteString.indexOf$default(this, other, 0, 2, null);
    }

    @JvmOverloads
    public int indexOf(@NotNull byte[] other, int fromIndex) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return ByteStringKt.commonIndexOf(this, other, fromIndex);
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ int indexOf$default(ByteString byteString, byte[] byArray, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: indexOf");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return byteString.indexOf(byArray, n);
    }

    @JvmOverloads
    public int indexOf(@NotNull byte[] other) {
        return ByteString.indexOf$default(this, other, 0, 2, null);
    }

    @JvmOverloads
    public final int lastIndexOf(@NotNull ByteString other, int fromIndex) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.lastIndexOf(other.internalArray$jvm(), fromIndex);
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ int lastIndexOf$default(ByteString byteString, ByteString byteString2, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: lastIndexOf");
        }
        if ((n2 & 2) != 0) {
            n = byteString.size();
        }
        return byteString.lastIndexOf(byteString2, n);
    }

    @JvmOverloads
    public final int lastIndexOf(@NotNull ByteString other) {
        return ByteString.lastIndexOf$default(this, other, 0, 2, null);
    }

    @JvmOverloads
    public int lastIndexOf(@NotNull byte[] other, int fromIndex) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return ByteStringKt.commonLastIndexOf(this, other, fromIndex);
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ int lastIndexOf$default(ByteString byteString, byte[] byArray, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: lastIndexOf");
        }
        if ((n2 & 2) != 0) {
            n = byteString.size();
        }
        return byteString.lastIndexOf(byArray, n);
    }

    @JvmOverloads
    public int lastIndexOf(@NotNull byte[] other) {
        return ByteString.lastIndexOf$default(this, other, 0, 2, null);
    }

    public boolean equals(@Nullable Object other) {
        return ByteStringKt.commonEquals(this, other);
    }

    public int hashCode() {
        return ByteStringKt.commonHashCode(this);
    }

    @Override
    public int compareTo(@NotNull ByteString other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return ByteStringKt.commonCompareTo(this, other);
    }

    @NotNull
    public String toString() {
        return ByteStringKt.commonToString(this);
    }

    private final void readObject(ObjectInputStream in) throws IOException {
        Field field;
        int dataLength = in.readInt();
        ByteString byteString = Companion.read(in, dataLength);
        Field field2 = field = ByteString.class.getDeclaredField("data");
        Intrinsics.checkExpressionValueIsNotNull((Object)field2, (String)"field");
        field2.setAccessible(true);
        field.set(this, byteString.data);
    }

    private final void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.data.length);
        out.write(this.data);
    }

    @Deprecated(message="moved to operator function", replaceWith=@ReplaceWith(imports={}, expression="this[index]"), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_getByte")
    public final byte -deprecated_getByte(int index) {
        return this.getByte(index);
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(imports={}, expression="size"), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_size")
    public final int -deprecated_size() {
        return this.size();
    }

    @NotNull
    public final byte[] getData$jvm() {
        return this.data;
    }

    public ByteString(@NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        this.data = data;
    }

    static {
        Companion = new Companion(null);
        EMPTY = ByteStringKt.getCOMMON_EMPTY();
    }

    @JvmStatic
    @NotNull
    public static final ByteString of(byte ... data) {
        return Companion.of(data);
    }

    @JvmStatic
    @JvmName(name="of")
    @NotNull
    public static final ByteString of(@NotNull byte[] $receiver, int offset, int byteCount) {
        return Companion.of($receiver, offset, byteCount);
    }

    @JvmStatic
    @JvmName(name="of")
    @NotNull
    public static final ByteString of(@NotNull ByteBuffer $receiver) {
        return Companion.of($receiver);
    }

    @JvmStatic
    @NotNull
    public static final ByteString encodeUtf8(@NotNull String $receiver) {
        return Companion.encodeUtf8($receiver);
    }

    @JvmStatic
    @JvmName(name="encodeString")
    @NotNull
    public static final ByteString encodeString(@NotNull String $receiver, @NotNull Charset charset) {
        return Companion.encodeString($receiver, charset);
    }

    @JvmStatic
    @Nullable
    public static final ByteString decodeBase64(@NotNull String $receiver) {
        return Companion.decodeBase64($receiver);
    }

    @JvmStatic
    @NotNull
    public static final ByteString decodeHex(@NotNull String $receiver) {
        return Companion.decodeHex($receiver);
    }

    @JvmStatic
    @JvmName(name="read")
    @NotNull
    public static final ByteString read(@NotNull InputStream $receiver, int byteCount) throws IOException {
        return Companion.read($receiver, byteCount);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tH\u0007\u00a2\u0006\u0002\b\nJ\u0015\u0010\u000b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007\u00a2\u0006\u0002\b\fJ\u001d\u0010\r\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u00a2\u0006\u0002\b\u0010J\u0015\u0010\u0011\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007\u00a2\u0006\u0002\b\u0012J\u0015\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0007\u00a2\u0006\u0002\b\u0016J\u0014\u0010\u0013\u001a\u00020\u00042\n\u0010\u0017\u001a\u00020\u0018\"\u00020\u0019H\u0007J%\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0007\u00a2\u0006\u0002\b\u0016J\u001d\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001cH\u0007\u00a2\u0006\u0002\b!J\u000e\u0010\u0007\u001a\u0004\u0018\u00010\u0004*\u00020\tH\u0007J\f\u0010\u000b\u001a\u00020\u0004*\u00020\tH\u0007J\u001b\u0010\"\u001a\u00020\u0004*\u00020\t2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0007\u00a2\u0006\u0002\b\rJ\f\u0010\u0011\u001a\u00020\u0004*\u00020\tH\u0007J\u0019\u0010#\u001a\u00020\u0004*\u00020 2\u0006\u0010\u001d\u001a\u00020\u001cH\u0007\u00a2\u0006\u0002\b\u001eJ\u0011\u0010$\u001a\u00020\u0004*\u00020\u0015H\u0007\u00a2\u0006\u0002\b\u0013J%\u0010$\u001a\u00020\u0004*\u00020\u00182\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001cH\u0007\u00a2\u0006\u0002\b\u0013R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lokio/ByteString$Companion;", "", "()V", "EMPTY", "Lokio/ByteString;", "serialVersionUID", "", "decodeBase64", "string", "", "-deprecated_decodeBase64", "decodeHex", "-deprecated_decodeHex", "encodeString", "charset", "Ljava/nio/charset/Charset;", "-deprecated_encodeString", "encodeUtf8", "-deprecated_encodeUtf8", "of", "buffer", "Ljava/nio/ByteBuffer;", "-deprecated_of", "data", "", "", "array", "offset", "", "byteCount", "read", "inputstream", "Ljava/io/InputStream;", "-deprecated_read", "encode", "readByteString", "toByteString", "jvm"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ByteString of(byte ... data) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return ByteStringKt.commonOf(data);
        }

        @JvmStatic
        @JvmName(name="of")
        @NotNull
        public final ByteString of(@NotNull byte[] $receiver, int offset, int byteCount) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            -Util.checkOffsetAndCount($receiver.length, offset, byteCount);
            byte[] copy = new byte[byteCount];
            -Platform.arraycopy($receiver, offset, copy, 0, byteCount);
            return new ByteString(copy);
        }

        @JvmStatic
        @JvmName(name="of")
        @NotNull
        public static /* bridge */ /* synthetic */ ByteString of$default(Companion companion, byte[] byArray, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = 0;
            }
            if ((n3 & 2) != 0) {
                n2 = byArray.length;
            }
            return companion.of(byArray, n, n2);
        }

        @JvmStatic
        @JvmName(name="of")
        @NotNull
        public final ByteString of(@NotNull ByteBuffer $receiver) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            byte[] copy = new byte[$receiver.remaining()];
            $receiver.get(copy);
            return new ByteString(copy);
        }

        @JvmStatic
        @NotNull
        public final ByteString encodeUtf8(@NotNull String $receiver) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            return ByteStringKt.commonEncodeUtf8($receiver);
        }

        @JvmStatic
        @JvmName(name="encodeString")
        @NotNull
        public final ByteString encodeString(@NotNull String $receiver, @NotNull Charset charset) {
            ByteString byteString;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
            String string2 = $receiver;
            ByteString byteString2 = byteString;
            ByteString byteString3 = byteString;
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            byteString2(byArray2);
            return byteString3;
        }

        @JvmStatic
        @JvmName(name="encodeString")
        @NotNull
        public static /* bridge */ /* synthetic */ ByteString encodeString$default(Companion companion, String string2, Charset charset, int n, Object object) {
            if ((n & 1) != 0) {
                charset = Charsets.UTF_8;
            }
            return companion.encodeString(string2, charset);
        }

        @JvmStatic
        @Nullable
        public final ByteString decodeBase64(@NotNull String $receiver) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            return ByteStringKt.commonDecodeBase64($receiver);
        }

        @JvmStatic
        @NotNull
        public final ByteString decodeHex(@NotNull String $receiver) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            return ByteStringKt.commonDecodeHex($receiver);
        }

        @JvmStatic
        @JvmName(name="read")
        @NotNull
        public final ByteString read(@NotNull InputStream $receiver, int byteCount) throws IOException {
            int read;
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            boolean bl2 = bl = byteCount >= 0;
            if (!bl) {
                String string2 = "byteCount < 0: " + byteCount;
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            byte[] result = new byte[byteCount];
            for (int offset = 0; offset < byteCount; offset += read) {
                read = $receiver.read(result, offset, byteCount - offset);
                if (read != -1) continue;
                throw (Throwable)new EOFException();
            }
            return new ByteString(result);
        }

        @Deprecated(message="moved to extension function", replaceWith=@ReplaceWith(imports={"okio.ByteString.Companion.decodeBase64"}, expression="string.decodeBase64()"), level=DeprecationLevel.ERROR)
        @JvmName(name="-deprecated_decodeBase64")
        @Nullable
        public final ByteString -deprecated_decodeBase64(@NotNull String string2) {
            Intrinsics.checkParameterIsNotNull((Object)string2, (String)"string");
            return this.decodeBase64(string2);
        }

        @Deprecated(message="moved to extension function", replaceWith=@ReplaceWith(imports={"okio.ByteString.Companion.decodeHex"}, expression="string.decodeHex()"), level=DeprecationLevel.ERROR)
        @JvmName(name="-deprecated_decodeHex")
        @NotNull
        public final ByteString -deprecated_decodeHex(@NotNull String string2) {
            Intrinsics.checkParameterIsNotNull((Object)string2, (String)"string");
            return this.decodeHex(string2);
        }

        @Deprecated(message="moved to extension function", replaceWith=@ReplaceWith(imports={"okio.ByteString.Companion.encode"}, expression="string.encode(charset)"), level=DeprecationLevel.ERROR)
        @JvmName(name="-deprecated_encodeString")
        @NotNull
        public final ByteString -deprecated_encodeString(@NotNull String string2, @NotNull Charset charset) {
            Intrinsics.checkParameterIsNotNull((Object)string2, (String)"string");
            Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
            return this.encodeString(string2, charset);
        }

        @Deprecated(message="moved to extension function", replaceWith=@ReplaceWith(imports={"okio.ByteString.Companion.encodeUtf8"}, expression="string.encodeUtf8()"), level=DeprecationLevel.ERROR)
        @JvmName(name="-deprecated_encodeUtf8")
        @NotNull
        public final ByteString -deprecated_encodeUtf8(@NotNull String string2) {
            Intrinsics.checkParameterIsNotNull((Object)string2, (String)"string");
            return this.encodeUtf8(string2);
        }

        @Deprecated(message="moved to extension function", replaceWith=@ReplaceWith(imports={"okio.ByteString.Companion.toByteString"}, expression="buffer.toByteString()"), level=DeprecationLevel.ERROR)
        @JvmName(name="-deprecated_of")
        @NotNull
        public final ByteString -deprecated_of(@NotNull ByteBuffer buffer) {
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            return this.of(buffer);
        }

        @Deprecated(message="moved to extension function", replaceWith=@ReplaceWith(imports={"okio.ByteString.Companion.toByteString"}, expression="array.toByteString(offset, byteCount)"), level=DeprecationLevel.ERROR)
        @JvmName(name="-deprecated_of")
        @NotNull
        public final ByteString -deprecated_of(@NotNull byte[] array2, int offset, int byteCount) {
            Intrinsics.checkParameterIsNotNull((Object)array2, (String)"array");
            return this.of(array2, offset, byteCount);
        }

        @Deprecated(message="moved to extension function", replaceWith=@ReplaceWith(imports={"okio.ByteString.Companion.readByteString"}, expression="inputstream.readByteString(byteCount)"), level=DeprecationLevel.ERROR)
        @JvmName(name="-deprecated_read")
        @NotNull
        public final ByteString -deprecated_read(@NotNull InputStream inputstream, int byteCount) {
            Intrinsics.checkParameterIsNotNull((Object)inputstream, (String)"inputstream");
            return this.read(inputstream, byteCount);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

