/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.InflaterSource;
import okio.RealBufferedSource;
import okio.Segment;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u000eH\u0016J\b\u0010\u0015\u001a\u00020\u000eH\u0002J\b\u0010\u0016\u001a\u00020\u000eH\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0018H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lokio/GzipSource;", "Lokio/Source;", "source", "(Lokio/Source;)V", "crc", "Ljava/util/zip/CRC32;", "inflater", "Ljava/util/zip/Inflater;", "inflaterSource", "Lokio/InflaterSource;", "section", "", "Lokio/RealBufferedSource;", "checkEqual", "", "name", "", "expected", "", "actual", "close", "consumeHeader", "consumeTrailer", "read", "", "sink", "Lokio/Buffer;", "byteCount", "timeout", "Lokio/Timeout;", "updateCrc", "buffer", "offset", "jvm"})
public final class GzipSource
implements Source {
    private byte section;
    private final RealBufferedSource source;
    private final Inflater inflater;
    private final InflaterSource inflaterSource;
    private final CRC32 crc;

    @Override
    public long read(@NotNull Buffer sink2, long byteCount) throws IOException {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)sink2, (String)"sink");
        boolean bl2 = bl = byteCount >= 0L;
        if (!bl) {
            String string2 = "byteCount < 0: " + byteCount;
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        if (byteCount == 0L) {
            return 0L;
        }
        if (this.section == 0) {
            this.consumeHeader();
            this.section = 1;
        }
        if (this.section == 1) {
            long offset = sink2.size();
            long result = this.inflaterSource.read(sink2, byteCount);
            if (result != -1L) {
                this.updateCrc(sink2, offset, result);
                return result;
            }
            this.section = (byte)2;
        }
        if (this.section == 2) {
            this.consumeTrailer();
            this.section = (byte)3;
            if (!this.source.exhausted()) {
                throw (Throwable)new IOException("gzip finished without exhausting source");
            }
        }
        return -1L;
    }

    /*
     * WARNING - void declaration
     */
    private final void consumeHeader() throws IOException {
        RealBufferedSource $i$f$getBit;
        void $receiver$iv;
        RealBufferedSource this_$iv;
        void $receiver$iv22;
        Buffer buffer;
        GzipSource gzipSource;
        void $receiver$iv32;
        boolean fhcrc;
        byte flags;
        this.source.require(10L);
        RealBufferedSource this_$iv2 = this.source;
        byte $i$f$getBuffer = flags = this_$iv2.bufferField.getByte(3L);
        int bit$iv = 1;
        boolean bl = fhcrc = ($receiver$iv32 >> bit$iv & 1) == 1;
        if (fhcrc) {
            void this_$iv3;
            RealBufferedSource $receiver$iv32 = this.source;
            gzipSource = this;
            buffer = this_$iv3.bufferField;
            gzipSource.updateCrc(buffer, 0L, 10L);
        }
        short id1id2 = this.source.readShort();
        this.checkEqual("ID1ID2", 8075, id1id2);
        this.source.skip(8L);
        byte $i$f$getBuffer2 = flags;
        int bit$iv2 = 2;
        if (($receiver$iv22 >> bit$iv2 & 1) == 1) {
            this.source.require(2L);
            if (fhcrc) {
                void this_$iv4;
                RealBufferedSource $receiver$iv22 = this.source;
                gzipSource = this;
                buffer = this_$iv4.bufferField;
                gzipSource.updateCrc(buffer, 0L, 2L);
            }
            this_$iv = this.source;
            long xlen = this_$iv.bufferField.readShortLe();
            this.source.require(xlen);
            if (fhcrc) {
                this_$iv = this.source;
                gzipSource = this;
                buffer = this_$iv.bufferField;
                gzipSource.updateCrc(buffer, 0L, xlen);
            }
            this.source.skip(xlen);
        }
        byte xlen = flags;
        bit$iv2 = 3;
        if (($receiver$iv >> bit$iv2 & 1) == 1) {
            long index = this.source.indexOf((byte)0);
            if (index == -1L) {
                throw (Throwable)new EOFException();
            }
            if (fhcrc) {
                $i$f$getBit = this.source;
                gzipSource = this;
                buffer = this_$iv.bufferField;
                gzipSource.updateCrc(buffer, 0L, index + 1L);
            }
            this.source.skip(index + 1L);
        }
        byte index = flags;
        bit$iv2 = 4;
        if (($receiver$iv >> bit$iv2 & 1) == 1) {
            long index2 = this.source.indexOf((byte)0);
            if (index2 == -1L) {
                throw (Throwable)new EOFException();
            }
            if (fhcrc) {
                $i$f$getBit = this.source;
                gzipSource = this;
                buffer = this_$iv.bufferField;
                gzipSource.updateCrc(buffer, 0L, index2 + 1L);
            }
            this.source.skip(index2 + 1L);
        }
        if (fhcrc) {
            this.checkEqual("FHCRC", this.source.readShortLe(), (short)this.crc.getValue());
            this.crc.reset();
        }
    }

    private final void consumeTrailer() throws IOException {
        this.checkEqual("CRC", this.source.readIntLe(), (int)this.crc.getValue());
        this.checkEqual("ISIZE", this.source.readIntLe(), (int)this.inflater.getBytesWritten());
    }

    @Override
    @NotNull
    public Timeout timeout() {
        return this.source.timeout();
    }

    @Override
    public void close() throws IOException {
        this.inflaterSource.close();
    }

    private final void updateCrc(Buffer buffer, long offset, long byteCount) {
        long offset2 = offset;
        long byteCount2 = byteCount;
        Segment segment = buffer.head;
        if (segment == null) {
            Intrinsics.throwNpe();
        }
        Segment s = segment;
        while (offset2 >= (long)(s.limit - s.pos)) {
            offset2 -= (long)(s.limit - s.pos);
            if (s.next != null) continue;
            Intrinsics.throwNpe();
        }
        while (byteCount2 > 0L) {
            int pos = (int)((long)s.pos + offset2);
            int a$iv = s.limit - pos;
            long l = a$iv;
            int toUpdate = (int)Math.min(l, byteCount2);
            this.crc.update(s.data, pos, toUpdate);
            byteCount2 -= (long)toUpdate;
            offset2 = 0L;
            if (s.next != null) continue;
            Intrinsics.throwNpe();
        }
    }

    private final void checkEqual(String name, int expected, int actual) {
        if (actual != expected) {
            IOException iOException;
            String string2 = "%s: actual 0x%08x != expected 0x%08x";
            Object[] objectArray = new Object[]{name, actual, expected};
            IOException iOException2 = iOException;
            IOException iOException3 = iOException;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(this, *args)");
            String string4 = string3;
            iOException2(string4);
            throw (Throwable)iOException3;
        }
    }

    public GzipSource(@NotNull Source source2) {
        Intrinsics.checkParameterIsNotNull((Object)source2, (String)"source");
        this.source = new RealBufferedSource(source2);
        this.inflater = new Inflater(true);
        this.inflaterSource = new InflaterSource(this.source, this.inflater);
        this.crc = new CRC32();
    }
}

