/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.axiom.attachments.DebugInputStream;
import org.apache.axiom.attachments.LegacyTempFileBlob;
import org.apache.axiom.attachments.Part;
import org.apache.axiom.attachments.PartDataHandler;
import org.apache.axiom.attachments.QuotedPrintableInputStream;
import org.apache.axiom.attachments.ReadOnceInputStreamWrapper;
import org.apache.axiom.blob.MemoryBlob;
import org.apache.axiom.blob.OverflowableBlob;
import org.apache.axiom.blob.WritableBlob;
import org.apache.axiom.blob.WritableBlobFactory;
import org.apache.axiom.ext.io.StreamCopyException;
import org.apache.axiom.mime.Header;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.util.DetachableInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.stream.EntityState;
import org.apache.james.mime4j.stream.MimeTokenStream;

final class PartImpl
implements Part {
    private static final int STATE_UNREAD = 0;
    private static final int STATE_BUFFERED = 1;
    private static final int STATE_STREAMING = 2;
    private static final int STATE_DISCARDED = 3;
    private static final Log log = LogFactory.getLog(PartImpl.class);
    private final WritableBlobFactory blobFactory;
    private List headers;
    private int state = 0;
    private MimeTokenStream parser;
    private WritableBlob content;
    private final DataHandler dataHandler;
    private DetachableInputStream detachableInputStream;

    PartImpl(WritableBlobFactory blobFactory, List headers, MimeTokenStream parser) {
        this.blobFactory = blobFactory;
        this.headers = headers;
        this.parser = parser;
        this.dataHandler = new PartDataHandler(this);
    }

    public String getHeader(String name) {
        String value2 = null;
        int l = this.headers.size();
        for (int i = 0; i < l; ++i) {
            Header header = (Header)this.headers.get(i);
            if (!header.getName().equalsIgnoreCase(name)) continue;
            value2 = header.getValue();
            break;
        }
        if (log.isDebugEnabled()) {
            log.debug("getHeader name=(" + name + ") value=(" + value2 + ")");
        }
        return value2;
    }

    public String getContentID() {
        return this.getHeader("content-id");
    }

    public String getContentType() {
        return this.getHeader("content-type");
    }

    String getDataSourceContentType() {
        String ct = this.getContentType();
        return ct == null ? "application/octet-stream" : ct;
    }

    public DataHandler getDataHandler() {
        return this.dataHandler;
    }

    public long getSize() {
        return this.getContent().getSize();
    }

    private WritableBlob getContent() {
        switch (this.state) {
            case 0: {
                this.fetch();
            }
            case 1: {
                return this.content;
            }
        }
        throw new IllegalStateException("The content of the MIME part has already been consumed");
    }

    private static void checkParserState(EntityState state, EntityState expected) throws IllegalStateException {
        if (expected != state) {
            throw new IllegalStateException("Internal error: expected parser to be in state " + expected + ", but got " + state);
        }
    }

    private InputStream getDecodedInputStream() {
        InputStream in = "quoted-printable".equalsIgnoreCase(this.getHeader("Content-Transfer-Encoding")) ? new QuotedPrintableInputStream(this.parser.getInputStream(), true) : this.parser.getDecodedInputStream();
        if (log.isDebugEnabled()) {
            in = new DebugInputStream(in, log);
        }
        return in;
    }

    void fetch() {
        switch (this.state) {
            case 0: {
                PartImpl.checkParserState(this.parser.getState(), EntityState.T_BODY);
                this.content = this.blobFactory.createBlob();
                if (log.isDebugEnabled()) {
                    log.debug("Using blob of type " + this.content.getClass().getName());
                }
                try {
                    this.content.readFrom(this.getDecodedInputStream());
                }
                catch (StreamCopyException ex) {
                    if (ex.getOperation() == 1) {
                        throw new OMException("Failed to fetch the MIME part content", ex.getCause());
                    }
                    throw new OMException("Failed to write the MIME part content to temporary storage", ex.getCause());
                }
                this.moveToNextPart();
                this.state = 1;
                break;
            }
            case 2: {
                try {
                    this.detachableInputStream.detach();
                }
                catch (IOException ex) {
                    throw new OMException(ex);
                }
                this.detachableInputStream = null;
                this.moveToNextPart();
                this.state = 3;
            }
        }
    }

    private void moveToNextPart() {
        try {
            PartImpl.checkParserState(this.parser.next(), EntityState.T_END_BODYPART);
            EntityState state = this.parser.next();
            if (state == EntityState.T_EPILOGUE) {
                while (this.parser.next() != EntityState.T_END_MULTIPART) {
                }
            } else if (state != EntityState.T_START_BODYPART && state != EntityState.T_END_MULTIPART) {
                throw new IllegalStateException("Internal error: unexpected parser state " + state);
            }
        }
        catch (IOException ex) {
            throw new OMException(ex);
        }
        catch (MimeException ex) {
            throw new OMException(ex);
        }
        this.parser = null;
    }

    InputStream getInputStream(boolean preserve) throws IOException {
        if (!preserve && this.state == 0) {
            PartImpl.checkParserState(this.parser.getState(), EntityState.T_BODY);
            this.state = 2;
            this.detachableInputStream = new DetachableInputStream(this.getDecodedInputStream());
            return this.detachableInputStream;
        }
        WritableBlob content = this.getContent();
        if (preserve) {
            return content.getInputStream();
        }
        if (content instanceof MemoryBlob) {
            return ((MemoryBlob)content).readOnce();
        }
        return new ReadOnceInputStreamWrapper(this, content.getInputStream());
    }

    DataSource getDataSource() {
        WritableBlob overflowBlob;
        WritableBlob blob = this.getContent();
        if (blob instanceof OverflowableBlob && (overflowBlob = ((OverflowableBlob)blob).getOverflowBlob()) != null) {
            blob = overflowBlob;
        }
        if (blob instanceof LegacyTempFileBlob) {
            return ((LegacyTempFileBlob)blob).getDataSource(this.getDataSourceContentType());
        }
        return null;
    }

    void writeTo(OutputStream out) throws IOException {
        this.getContent().writeTo(out);
    }

    void releaseContent() throws IOException {
        switch (this.state) {
            case 0: {
                try {
                    EntityState state;
                    while ((state = this.parser.next()) != EntityState.T_START_BODYPART && state != EntityState.T_END_MULTIPART) {
                    }
                }
                catch (MimeException ex) {
                    throw new OMException(ex);
                }
                this.state = 3;
                break;
            }
            case 1: {
                this.content.release();
            }
        }
    }
}

