/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.mime;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import org.apache.axiom.mime.ContentTypeTokenizer;
import org.apache.axiom.mime.MediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContentType {
    private final MediaType mediaType;
    private final String[] parameters;

    public ContentType(MediaType mediaType, String[] parameters) {
        this.mediaType = mediaType;
        this.parameters = (String[])parameters.clone();
    }

    public ContentType(String type) throws ParseException {
        String name;
        ContentTypeTokenizer tokenizer = new ContentTypeTokenizer(type);
        String primaryType = tokenizer.requireToken();
        tokenizer.require('/');
        String subType = tokenizer.requireToken();
        this.mediaType = new MediaType(primaryType, subType);
        ArrayList<String> parameters = new ArrayList<String>();
        while (tokenizer.expect(';') && (name = tokenizer.expectToken()) != null) {
            parameters.add(name);
            tokenizer.require('=');
            parameters.add(tokenizer.requireTokenOrQuotedString());
        }
        this.parameters = parameters.toArray(new String[parameters.size()]);
    }

    ContentType(MediaType mediaType, Map<String, String> parameters) {
        this.mediaType = mediaType;
        this.parameters = new String[parameters.size() * 2];
        int i = 0;
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            this.parameters[i++] = entry.getKey();
            this.parameters[i++] = entry.getValue();
        }
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public String getParameter(String name) {
        for (int i = 0; i < this.parameters.length; i += 2) {
            if (!name.equalsIgnoreCase(this.parameters[i])) continue;
            return this.parameters[i + 1];
        }
        return null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.mediaType.getPrimaryType());
        buffer.append('/');
        buffer.append(this.mediaType.getSubType());
        int i = 0;
        while (i < this.parameters.length) {
            buffer.append("; ");
            buffer.append(this.parameters[i++]);
            buffer.append("=\"");
            String value2 = this.parameters[i++];
            int l = value2.length();
            for (int j = 0; j < l; ++j) {
                char c = value2.charAt(j);
                if (c == '\"' || c == '\\') {
                    buffer.append('\\');
                }
                buffer.append(c);
            }
            buffer.append('\"');
        }
        return buffer.toString();
    }

    void getParameters(Map<String, String> map2) {
        for (int i = 0; i < this.parameters.length; i += 2) {
            map2.put(this.parameters[i].toLowerCase(Locale.ENGLISH), this.parameters[i + 1]);
        }
    }
}

