/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.mime;

import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.apache.axiom.mime.ContentType;
import org.apache.axiom.mime.MediaType;

public final class ContentTypeBuilder {
    private MediaType mediaType;
    private final LinkedHashMap<String, String> parameters = new LinkedHashMap();

    public ContentTypeBuilder(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public ContentTypeBuilder(ContentType type) {
        this(type.getMediaType());
        type.getParameters(this.parameters);
    }

    public ContentTypeBuilder(String type) throws ParseException {
        this(new ContentType(type));
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public String getParameter(String name) {
        return this.parameters.get(name.toLowerCase(Locale.ENGLISH));
    }

    public void setParameter(String name, String value2) {
        this.parameters.put(name.toLowerCase(Locale.ENGLISH), value2);
    }

    public void clearParameters() {
        this.parameters.clear();
    }

    public ContentType build() {
        return new ContentType(this.mediaType, this.parameters);
    }

    public String toString() {
        return this.build().toString();
    }
}

