/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.common.serializer.pull;

import java.io.IOException;
import java.io.Writer;
import javax.activation.DataHandler;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.core.CoreParentNode;
import org.apache.axiom.ext.stax.CharacterDataReader;
import org.apache.axiom.ext.stax.DTDReader;
import org.apache.axiom.ext.stax.datahandler.DataHandlerProvider;
import org.apache.axiom.ext.stax.datahandler.DataHandlerReader;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.impl.common.serializer.pull.ClosedState;
import org.apache.axiom.om.impl.common.serializer.pull.Navigator;
import org.apache.axiom.om.impl.common.serializer.pull.PullSerializerState;
import org.apache.axiom.util.stax.AbstractXMLStreamReader;
import org.apache.axiom.util.stax.XMLStreamReaderUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class PullSerializer
extends AbstractXMLStreamReader
implements DataHandlerReader,
DTDReader,
CharacterDataReader {
    private static final Log log = LogFactory.getLog(PullSerializer.class);
    private PullSerializerState state;
    private PullSerializerState savedState;
    private boolean isDataSourceALeaf;

    public PullSerializer(CoreParentNode startNode, boolean cache, boolean preserveNamespaceContext) {
        this.state = new Navigator(this, startNode, cache, preserveNamespaceContext);
        if (log.isDebugEnabled()) {
            log.debug("Pull serializer created; initial state is " + this.state);
        }
    }

    void switchState(PullSerializerState newState) throws XMLStreamException {
        if (log.isDebugEnabled()) {
            log.debug("Switching to state " + newState);
        }
        this.internalSwitchState(newState);
    }

    private void internalSwitchState(PullSerializerState newState) throws XMLStreamException {
        PullSerializerState oldState = this.state;
        PullSerializerState savedState = this.savedState;
        this.state = newState;
        this.savedState = null;
        if (savedState != null) {
            savedState.released();
        }
        oldState.released();
    }

    void pushState(PullSerializerState newState) {
        if (this.savedState != null) {
            throw new IllegalStateException();
        }
        if (log.isDebugEnabled()) {
            log.debug("Switching to state " + newState);
        }
        this.savedState = this.state;
        this.state = newState;
    }

    void popState() throws XMLStreamException {
        PullSerializerState savedState = this.savedState;
        if (savedState == null) {
            throw new IllegalStateException();
        }
        if (log.isDebugEnabled()) {
            log.debug("Restoring state " + savedState);
        }
        this.savedState = null;
        this.internalSwitchState(savedState);
        savedState.restored();
    }

    OMDataSource getDataSource() {
        return this.state.getDataSource();
    }

    void enableDataSourceEvents(boolean value2) {
        this.isDataSourceALeaf = true;
    }

    boolean isDataSourceALeaf() {
        return this.isDataSourceALeaf;
    }

    public int getEventType() {
        return this.state.getEventType();
    }

    public boolean hasNext() throws XMLStreamException {
        return this.state.hasNext();
    }

    public int next() throws XMLStreamException {
        this.state.next();
        return this.state.getEventType();
    }

    public int nextTag() throws XMLStreamException {
        int eventType = this.state.nextTag();
        return eventType == -1 ? super.nextTag() : eventType;
    }

    public void close() throws XMLStreamException {
        this.switchState(ClosedState.INSTANCE);
    }

    public Object getProperty(String name) {
        Object value2 = XMLStreamReaderUtils.processGetProperty(this, name);
        if (value2 != null) {
            return value2;
        }
        if (DTDReader.PROPERTY.equals(name) || CharacterDataReader.PROPERTY.equals(name)) {
            return this;
        }
        return this.state.getProperty(name);
    }

    public String getVersion() {
        return this.state.getVersion();
    }

    public String getCharacterEncodingScheme() {
        return this.state.getCharacterEncodingScheme();
    }

    public String getEncoding() {
        return this.state.getEncoding();
    }

    public boolean isStandalone() {
        return this.state.isStandalone();
    }

    public boolean standaloneSet() {
        return this.state.standaloneSet();
    }

    public String getPrefix() {
        return this.state.getPrefix();
    }

    public String getNamespaceURI() {
        return this.state.getNamespaceURI();
    }

    public String getLocalName() {
        return this.state.getLocalName();
    }

    public QName getName() {
        return this.state.getName();
    }

    public int getNamespaceCount() {
        return this.state.getNamespaceCount();
    }

    public String getNamespacePrefix(int index) {
        return this.state.getNamespacePrefix(index);
    }

    public String getNamespaceURI(int index) {
        return this.state.getNamespaceURI(index);
    }

    public int getAttributeCount() {
        return this.state.getAttributeCount();
    }

    public String getAttributePrefix(int index) {
        return this.state.getAttributePrefix(index);
    }

    public String getAttributeNamespace(int index) {
        return this.state.getAttributeNamespace(index);
    }

    public String getAttributeLocalName(int index) {
        return this.state.getAttributeLocalName(index);
    }

    public QName getAttributeName(int index) {
        return this.state.getAttributeName(index);
    }

    public boolean isAttributeSpecified(int index) {
        return this.state.isAttributeSpecified(index);
    }

    public String getAttributeType(int index) {
        return this.state.getAttributeType(index);
    }

    public String getAttributeValue(int index) {
        return this.state.getAttributeValue(index);
    }

    public String getAttributeValue(String namespaceURI, String localName) {
        return this.state.getAttributeValue(namespaceURI, localName);
    }

    public NamespaceContext getNamespaceContext() {
        return this.state.getNamespaceContext();
    }

    public String getNamespaceURI(String prefix) {
        return this.state.getNamespaceURI(prefix);
    }

    public String getElementText() throws XMLStreamException {
        String text = this.state.getElementText();
        return text == null ? super.getElementText() : text;
    }

    public String getText() {
        return this.state.getText();
    }

    public char[] getTextCharacters() {
        return this.state.getTextCharacters();
    }

    public int getTextStart() {
        return this.state.getTextStart();
    }

    public int getTextLength() {
        return this.state.getTextLength();
    }

    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        return this.state.getTextCharacters(sourceStart, target, targetStart, length);
    }

    public boolean isWhiteSpace() {
        Boolean isWhiteSpace = this.state.isWhiteSpace();
        return isWhiteSpace == null ? super.isWhiteSpace() : isWhiteSpace.booleanValue();
    }

    public String getPIData() {
        return this.state.getPIData();
    }

    public String getPITarget() {
        return this.state.getPITarget();
    }

    public boolean isBinary() {
        return this.state.getDataHandlerReader().isBinary();
    }

    public boolean isOptimized() {
        return this.state.getDataHandlerReader().isOptimized();
    }

    public boolean isDeferred() {
        return this.state.getDataHandlerReader().isDeferred();
    }

    public String getContentID() {
        return this.state.getDataHandlerReader().getContentID();
    }

    public DataHandler getDataHandler() throws XMLStreamException {
        return this.state.getDataHandlerReader().getDataHandler();
    }

    public DataHandlerProvider getDataHandlerProvider() {
        return this.state.getDataHandlerReader().getDataHandlerProvider();
    }

    public String getRootName() {
        return this.state.getDTDReader().getRootName();
    }

    public String getPublicId() {
        return this.state.getDTDReader().getPublicId();
    }

    public String getSystemId() {
        return this.state.getDTDReader().getSystemId();
    }

    public void writeTextTo(Writer writer) throws XMLStreamException, IOException {
        this.state.getCharacterDataReader().writeTextTo(writer);
    }
}

