/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.config;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ballerinalang.bcl.parser.BConfig;
import org.ballerinalang.config.ConfigProcessor;
import org.ballerinalang.config.cipher.AESCipherTool;
import org.ballerinalang.config.cipher.AESCipherToolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigRegistry {
    private static final Logger log = LoggerFactory.getLogger(ConfigRegistry.class);
    private static final ConfigRegistry configRegistry = new ConfigRegistry();
    private static final Pattern encryptedFieldPattern = Pattern.compile("@encrypted:\\{(.*)\\}");
    private static final String ENV_VAR_FORMAT = "[a-zA-Z_]+[a-zA-Z0-9_]*";
    private Map<String, Object> configEntries = new HashMap<String, Object>();
    private AESCipherTool cipherTool;
    private PrintStream stderr = System.err;
    private boolean isInitialized;

    private ConfigRegistry() {
    }

    public static ConfigRegistry getInstance() {
        return configRegistry;
    }

    public void initRegistry(Map<String, String> runtimeParams, String configFilePath, Path ballerinaConfPath) throws IOException {
        BConfig resolvedConfigs = ConfigProcessor.processConfiguration(runtimeParams, configFilePath, ballerinaConfPath);
        this.configEntries = resolvedConfigs.getConfigurations();
        if (resolvedConfigs.hasEncryptedValues()) {
            String customSecretFilePath = runtimeParams != null ? runtimeParams.get("b7a.config.secret") : null;
            Path userSecretFile = this.getUserSecretFile(customSecretFilePath);
            try {
                if (Files.exists(userSecretFile, new LinkOption[0])) {
                    this.cipherTool = new AESCipherTool(userSecretFile);
                } else {
                    this.stderr.println("ballerina: enter secret for config value decryption:");
                    this.cipherTool = new AESCipherTool(new String(System.console().readPassword()));
                }
            }
            catch (AESCipherToolException e) {
                String msg = "failed to initialize the cipher tool: " + e.getMessage();
                throw new RuntimeException(msg, e);
            }
        }
        this.addConfiguration("ballerina.source.root", System.getProperty("ballerina.source.root"));
        this.isInitialized = true;
    }

    public void addConfiguration(String key, Object value2) {
        this.configEntries.put(key, value2);
    }

    public void addConfiguration(String tableHeader, String tableField, Object value2) {
        this.addConfiguration(this.getConfigKey(tableHeader, tableField), value2);
    }

    public void addEncryptedConfiguration(String key, String value2) {
        if (this.cipherTool == null) {
            throw new RuntimeException("cipher tool is not initialized.");
        }
        this.addConfiguration(key, String.format("@encrypted:{%s}", value2));
    }

    public void addEncryptedConfiguration(String tableHeader, String tableField, String value2) {
        this.addEncryptedConfiguration(this.getConfigKey(tableHeader, tableField), value2);
    }

    public boolean contains(String key) {
        return this.configEntries.containsKey(key);
    }

    public boolean contains(String tableHeader, String tableField) {
        return this.contains(this.getConfigKey(tableHeader, tableField));
    }

    public Object getConfiguration(String key) {
        if (this.contains(key)) {
            Object value2 = this.configEntries.get(key);
            if (value2 instanceof String) {
                return this.resolveStringValue((String)value2);
            }
            return value2;
        }
        return null;
    }

    public Object getConfiguration(String sectionHeader, String field) {
        return this.getConfiguration(this.getConfigKey(sectionHeader, field));
    }

    public boolean getAsBoolean(String key) {
        if (this.contains(key)) {
            try {
                Object value2 = this.configEntries.get(key);
                if (value2 instanceof String) {
                    return Boolean.parseBoolean(this.resolveStringValue((String)value2));
                }
                return (Boolean)value2;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(key + " does not map to a valid boolean");
            }
        }
        return Boolean.parseBoolean(this.lookupEnvVars(key));
    }

    public boolean getAsBoolean(String sectionHeader, String field) {
        return this.getAsBoolean(this.getConfigKey(sectionHeader, field));
    }

    public long getAsInt(String key) {
        if (this.contains(key)) {
            try {
                Object value2 = this.configEntries.get(key);
                if (value2 instanceof String) {
                    return Long.parseLong(this.resolveStringValue((String)value2));
                }
                return (Long)value2;
            }
            catch (ClassCastException | NumberFormatException e) {
                throw new IllegalArgumentException(key + " does not map to a valid int");
            }
        }
        return Long.parseLong(this.lookupEnvVars(key));
    }

    public long getAsInt(String sectionHeader, String field) {
        return this.getAsInt(this.getConfigKey(sectionHeader, field));
    }

    public double getAsFloat(String key) {
        if (this.contains(key)) {
            try {
                Object value2 = this.configEntries.get(key);
                if (value2 instanceof String) {
                    return Double.parseDouble(this.resolveStringValue((String)value2));
                }
                if (value2 instanceof Long) {
                    return ((Long)value2).longValue();
                }
                return (Double)value2;
            }
            catch (ClassCastException | NumberFormatException e) {
                throw new IllegalArgumentException(key + " does not map to a valid float");
            }
        }
        return Double.parseDouble(this.lookupEnvVars(key));
    }

    public double getAsFloat(String sectionHeader, String field) {
        return this.getAsFloat(this.getConfigKey(sectionHeader, field));
    }

    public Map<String, Object> getAsMap(String key) {
        HashMap<String, Object> section = new HashMap<String, Object>();
        int subStringIndex = key.length() + 1;
        this.configEntries.entrySet().forEach(entry -> {
            if (((String)entry.getKey()).startsWith(key)) {
                section.put(((String)entry.getKey()).substring(subStringIndex), entry.getValue());
            }
        });
        return section;
    }

    public Map<String, Object> getAsMap(String sectionHeader, String field) {
        return this.getAsMap(this.getConfigKey(sectionHeader, field));
    }

    public String getAsString(String key) {
        if (key == null) {
            return null;
        }
        if (this.contains(key)) {
            String value2 = String.valueOf(this.configEntries.get(key));
            return this.resolveStringValue(value2);
        }
        return this.lookupEnvVars(key);
    }

    public String getAsString(String tableHeader, String tableField) {
        return this.getAsString(this.getConfigKey(tableHeader, tableField));
    }

    public String getConfigOrDefault(String key, String defaultValue) {
        String value2 = this.getAsString(key);
        return value2 != null ? value2 : defaultValue;
    }

    public Iterator<String> keySetIterator() {
        return this.configEntries.keySet().iterator();
    }

    public Object removeConfiguration(String key) {
        return this.configEntries.remove(key);
    }

    public void resetRegistry() {
        this.configEntries.clear();
    }

    private String getConfigKey(String tableHeader, String tableField) {
        return tableHeader + "." + tableField;
    }

    private Path getUserSecretFile(String path) {
        if (path == null) {
            return Paths.get(System.getProperty("ballerina.source.root"), "secret.txt");
        }
        Path userConfiguredPath = Paths.get(path, new String[0]);
        if (Files.notExists(userConfiguredPath, new LinkOption[0])) {
            throw new RuntimeException("file not found: " + path);
        }
        return userConfiguredPath;
    }

    private String resolveStringValue(String value2) {
        Matcher base64Matcher = null;
        try {
            if (value2 != null && (base64Matcher = encryptedFieldPattern.matcher(value2)).find()) {
                return this.cipherTool.decrypt(base64Matcher.group(1));
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("invalid base 64 value: " + base64Matcher.group(1));
        }
        catch (AESCipherToolException e) {
            throw new RuntimeException("failed to retrieve encrypted value: " + e.getMessage(), e);
        }
        return value2;
    }

    private String lookupEnvVars(String key) {
        String convertedKey = this.getEnvVarKey(key);
        return convertedKey.matches(ENV_VAR_FORMAT) ? System.getenv(convertedKey) : null;
    }

    private String getEnvVarKey(String configKey) {
        return configKey.replace('.', '_');
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void setInitialized(boolean initialized) {
        this.isInitialized = initialized;
    }
}

