/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm;

import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.AnnotatableType;
import org.ballerinalang.jvm.types.AttachedFunction;
import org.ballerinalang.jvm.types.BObjectType;
import org.ballerinalang.jvm.types.BServiceType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.FPValue;
import org.ballerinalang.jvm.values.MapValue;

public class AnnotationUtils {
    public static void processAnnotations(MapValue globalAnnotMap, BType bType) {
        if (!(bType instanceof AnnotatableType)) {
            return;
        }
        AnnotatableType type = (AnnotatableType)bType;
        String annotationKey = type.getAnnotationKey();
        if (globalAnnotMap.containsKey(annotationKey)) {
            type.setAnnotations((MapValue)globalAnnotMap.get(annotationKey));
        }
        if (type.getTag() == 35) {
            BObjectType objectType = (BObjectType)type;
            for (AttachedFunction attachedFunction : objectType.getAttachedFunctions()) {
                annotationKey = attachedFunction.getAnnotationKey();
                if (!globalAnnotMap.containsKey(annotationKey)) continue;
                attachedFunction.setAnnotations((MapValue)globalAnnotMap.get(annotationKey));
            }
        }
    }

    public static void processServiceAnnotations(MapValue globalAnnotMap, BServiceType bType, Strand strand) {
        String annotationKey = bType.getAnnotationKey();
        if (globalAnnotMap.containsKey(annotationKey)) {
            bType.setAnnotations((MapValue)((FPValue)globalAnnotMap.get(annotationKey)).apply(new Object[]{strand}));
        }
        for (AttachedFunction attachedFunction : bType.getAttachedFunctions()) {
            annotationKey = attachedFunction.getAnnotationKey();
            if (!globalAnnotMap.containsKey(annotationKey)) continue;
            attachedFunction.setAnnotations((MapValue)((FPValue)globalAnnotMap.get(annotationKey)).apply(new Object[]{strand}));
        }
    }

    public static void processFPValueAnnotations(FPValue fpValue, MapValue globalAnnotMap, String name) {
        AnnotatableType type = (AnnotatableType)fpValue.getType();
        if (globalAnnotMap.containsKey(name)) {
            type.setAnnotations((MapValue)globalAnnotMap.get(name));
        }
    }
}

