/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMText;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.XMLFactory;
import org.ballerinalang.jvm.XMLValidator;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.RefValue;
import org.ballerinalang.jvm.values.XMLItem;
import org.ballerinalang.jvm.values.XMLSequence;
import org.ballerinalang.jvm.values.XMLValue;

public class JSONToXMLConverter {
    private static final OMFactory OM_FACTORY = OMAbstractFactory.getOMFactory();
    private static final String XSI_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String XSI_PREFIX = "xsi";
    private static final String NIL = "nil";
    public static final String OBJECT = "object";
    public static final String ARRAY = "array";

    public static XMLValue convertToXML(Object json, String attributePrefix, String arrayEntryTag) {
        XMLValue xml2;
        if (json == null) {
            return new XMLSequence();
        }
        List<XMLValue> omElementArrayList = JSONToXMLConverter.traverseTree(json, attributePrefix, arrayEntryTag);
        if (omElementArrayList.size() == 1) {
            xml2 = omElementArrayList.get(0);
        } else {
            ArrayValue elementsSeq = new ArrayValue(new BArrayType(BTypes.typeXML));
            int count = omElementArrayList.size();
            for (int i = 0; i < count; ++i) {
                elementsSeq.add((long)i, omElementArrayList.get(i));
            }
            xml2 = new XMLSequence(elementsSeq);
        }
        return xml2;
    }

    private static List<XMLValue> traverseTree(Object json, String attributePrefix, String arrayEntryTag) {
        ArrayList<XMLValue> xmlArray = new ArrayList<XMLValue>();
        if (!(json instanceof RefValue)) {
            XMLValue<?> xml2 = XMLFactory.parse(json.toString());
            xmlArray.add(xml2);
        } else {
            JSONToXMLConverter.traverseJsonNode(json, null, null, xmlArray, attributePrefix, arrayEntryTag);
        }
        return xmlArray;
    }

    private static OMElement traverseJsonNode(Object json, String nodeName, OMElement parentElement, List<XMLValue> omElementArrayList, String attributePrefix, String arrayEntryTag) {
        OMElement currentRoot = null;
        if (nodeName != null) {
            if (nodeName.startsWith(attributePrefix)) {
                if (json instanceof RefValue) {
                    throw new BallerinaException("attribute cannot be an object or array");
                }
                if (parentElement != null) {
                    String attributeKey = nodeName.substring(1);
                    XMLValidator.validateXMLName(attributeKey);
                    parentElement.addAttribute(attributeKey, json.toString(), null);
                }
                return parentElement;
            }
            XMLValidator.validateXMLName(nodeName);
            currentRoot = OM_FACTORY.createOMElement(nodeName, null);
        }
        if (json == null) {
            OMNamespace xsiNameSpace = OM_FACTORY.createOMNamespace(XSI_NAMESPACE, XSI_PREFIX);
            currentRoot.addAttribute(NIL, "true", xsiNameSpace);
        } else {
            switch (TypeChecker.getType(json).getTag()) {
                case 7: {
                    MapValueImpl map2 = (MapValueImpl)json;
                    for (Map.Entry entry : map2.entrySet()) {
                        currentRoot = JSONToXMLConverter.traverseJsonNode(entry.getValue(), (String)entry.getKey(), currentRoot, omElementArrayList, attributePrefix, arrayEntryTag);
                        if (nodeName != null) continue;
                        omElementArrayList.add(new XMLItem(currentRoot));
                        currentRoot = null;
                    }
                    break;
                }
                case 20: {
                    ArrayValue array2 = (ArrayValue)json;
                    for (int i = 0; i < array2.size(); ++i) {
                        currentRoot = JSONToXMLConverter.traverseJsonNode(array2.getRefValue(i), arrayEntryTag, currentRoot, omElementArrayList, attributePrefix, arrayEntryTag);
                        if (nodeName != null) continue;
                        omElementArrayList.add(new XMLItem(currentRoot));
                        currentRoot = null;
                    }
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    if (currentRoot == null) {
                        throw new BallerinaException("error in converting json to xml");
                    }
                    OMText txt1 = OM_FACTORY.createOMText((OMContainer)currentRoot, json.toString());
                    currentRoot.addChild(txt1);
                    break;
                }
                default: {
                    throw new BallerinaException("error in converting json to xml");
                }
            }
        }
        if (parentElement != null) {
            parentElement.addChild(currentRoot);
            currentRoot = parentElement;
        }
        return currentRoot;
    }
}

