/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm;

import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BField;
import org.ballerinalang.jvm.types.BStructureType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BUnionType;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.DecimalValue;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.utils.StringUtils;

public class TableUtils {
    private static final String DEFAULT_ERROR_DETAIL_MESSAGE = "Error occurred during table manipulation";

    public static String generateInsertDataStatement(String tableName, MapValueImpl<?, ?> constrainedType) {
        StringBuilder sbSql = new StringBuilder();
        StringBuilder sbValues = new StringBuilder();
        sbSql.append("INSERT INTO ").append(tableName).append(" (");
        Collection<BField> structFields = ((BStructureType)constrainedType.getType()).getFields().values();
        String sep = "";
        for (BField sf : structFields) {
            String name = sf.getFieldName();
            sbSql.append(sep).append(name).append(" ");
            sbValues.append(sep).append("?");
            sep = ",";
        }
        sbSql.append(") values (").append((CharSequence)sbValues).append(")");
        return sbSql.toString();
    }

    public static String generateDeleteDataStatment(String tableName, MapValueImpl<?, ?> constrainedType) {
        StringBuilder sbSql = new StringBuilder();
        sbSql.append("DELETE FROM ").append(tableName).append(" WHERE ");
        Collection<BField> structFields = ((BStructureType)constrainedType.getType()).getFields().values();
        String sep = "";
        for (BField sf : structFields) {
            String name = sf.getFieldName();
            sbSql.append(sep).append(name).append(" = ? ");
            sep = " AND ";
        }
        return sbSql.toString();
    }

    public static void prepareAndExecuteStatement(PreparedStatement stmt, MapValueImpl<?, ?> data) {
        try {
            Collection<BField> structFields = ((BStructureType)data.getType()).getFields().values();
            int index = 1;
            for (BField sf : structFields) {
                int type = sf.getFieldType().getTag();
                String fieldName = sf.getFieldName();
                switch (type) {
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 20: {
                        TableUtils.prepareAndExecuteStatement(stmt, data, index, sf, type, fieldName);
                        break;
                    }
                    case 21: {
                        List<BType> members = ((BUnionType)sf.getFieldType()).getMemberTypes();
                        if (members.size() != 2) {
                            throw TableUtils.createTableOperationError("Corresponding Union type in the record is not an assignable nillable type");
                        }
                        if (members.get(0).getTag() == 10) {
                            TableUtils.prepareAndExecuteStatement(stmt, data, index, sf, members.get(1).getTag(), fieldName);
                            break;
                        }
                        if (members.get(1).getTag() == 10) {
                            TableUtils.prepareAndExecuteStatement(stmt, data, index, sf, members.get(0).getTag(), fieldName);
                            break;
                        }
                        throw TableUtils.createTableOperationError("Corresponding Union type in the record is not an assignable nillable type");
                    }
                }
                ++index;
            }
            stmt.execute();
        }
        catch (SQLException e) {
            throw TableUtils.createTableOperationError("execute update failed: " + e.getMessage());
        }
    }

    private static void prepareAndExecuteStatement(PreparedStatement stmt, MapValueImpl<?, ?> data, int index, BField sf, int type, String fieldName) throws SQLException {
        Object value2 = data.get(fieldName);
        switch (type) {
            case 1: {
                if (value2 == null) {
                    stmt.setNull(index, -5);
                    break;
                }
                stmt.setLong(index, data.getIntValue(fieldName));
                break;
            }
            case 5: {
                if (value2 == null) {
                    stmt.setNull(index, 12);
                    break;
                }
                stmt.setString(index, data.getStringValue(fieldName));
                break;
            }
            case 3: {
                if (value2 == null) {
                    stmt.setNull(index, 8);
                    break;
                }
                stmt.setDouble(index, data.getFloatValue(fieldName));
                break;
            }
            case 4: {
                if (value2 == null) {
                    stmt.setNull(index, 3);
                    break;
                }
                stmt.setBigDecimal(index, ((DecimalValue)data.get(fieldName)).decimalValue());
                break;
            }
            case 6: {
                if (value2 == null) {
                    stmt.setNull(index, 16);
                    break;
                }
                stmt.setBoolean(index, data.getBooleanValue(fieldName));
                break;
            }
            case 8: {
                stmt.setString(index, data.get(fieldName).toString());
                break;
            }
            case 7: {
                if (value2 == null) {
                    stmt.setNull(index, 12);
                    break;
                }
                stmt.setString(index, StringUtils.getJsonString(data.get(fieldName)));
                break;
            }
            case 20: {
                boolean isBlobType;
                boolean bl = isBlobType = ((BArrayType)sf.getFieldType()).getElementType().getTag() == 2;
                if (isBlobType) {
                    if (value2 != null) {
                        byte[] blobData = ((ArrayValue)data.get(fieldName)).getBytes();
                        stmt.setBlob(index, new ByteArrayInputStream(blobData), blobData.length);
                        break;
                    }
                    stmt.setNull(index, 2004);
                    break;
                }
                Object[] arrayData = TableUtils.getArrayData((ArrayValue)data.get(fieldName));
                stmt.setObject(index, arrayData);
            }
        }
    }

    static Object[] getArrayData(ArrayValue value2) {
        Object[] arrayData;
        if (value2 == null) {
            return new Object[]{null};
        }
        int typeTag = value2.elementType.getTag();
        switch (typeTag) {
            case 1: {
                int arrayLength = value2.size();
                arrayData = new Long[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    arrayData[i] = value2.getInt(i);
                }
                break;
            }
            case 3: {
                int arrayLength = value2.size();
                arrayData = new Double[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    arrayData[i] = value2.getFloat(i);
                }
                break;
            }
            case 5: {
                int arrayLength = value2.size();
                arrayData = new String[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    arrayData[i] = value2.getString(i);
                }
                break;
            }
            case 6: {
                int arrayLength = value2.size();
                arrayData = new Boolean[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    arrayData[i] = value2.getBoolean(i);
                }
                break;
            }
            case 4: {
                int arrayLength = value2.size();
                arrayData = new BigDecimal[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    arrayData[i] = ((DecimalValue)value2.getRefValue(i)).value();
                }
                break;
            }
            default: {
                throw TableUtils.createTableOperationError("unsupported data type for array parameter");
            }
        }
        return arrayData;
    }

    public static ErrorValue createTableOperationError(Throwable throwable, String errorSuffix) {
        String detail = throwable.getMessage() != null ? errorSuffix + ": " + throwable.getMessage() : DEFAULT_ERROR_DETAIL_MESSAGE;
        return BallerinaErrors.createError(BallerinaErrorReasons.TABLE_OPERATION_ERROR, detail);
    }

    public static ErrorValue createTableOperationError(Throwable throwable) {
        String detail = throwable.getMessage() != null ? throwable.getMessage() : DEFAULT_ERROR_DETAIL_MESSAGE;
        return BallerinaErrors.createError(BallerinaErrorReasons.TABLE_OPERATION_ERROR, detail);
    }

    public static ErrorValue createTableOperationError(String detail) {
        return BallerinaErrors.createError(BallerinaErrorReasons.TABLE_OPERATION_ERROR, detail);
    }
}

