/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.DecimalValueKind;
import org.ballerinalang.jvm.TypeConverter;
import org.ballerinalang.jvm.XMLFactory;
import org.ballerinalang.jvm.commons.ArrayState;
import org.ballerinalang.jvm.commons.TypeValuePair;
import org.ballerinalang.jvm.types.AnnotatableType;
import org.ballerinalang.jvm.types.AttachedFunction;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BErrorType;
import org.ballerinalang.jvm.types.BField;
import org.ballerinalang.jvm.types.BFiniteType;
import org.ballerinalang.jvm.types.BFunctionType;
import org.ballerinalang.jvm.types.BFutureType;
import org.ballerinalang.jvm.types.BJSONType;
import org.ballerinalang.jvm.types.BMapType;
import org.ballerinalang.jvm.types.BObjectType;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BRecordType;
import org.ballerinalang.jvm.types.BStreamType;
import org.ballerinalang.jvm.types.BTableType;
import org.ballerinalang.jvm.types.BTupleType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.types.BUnionType;
import org.ballerinalang.jvm.util.BLangConstants;
import org.ballerinalang.jvm.util.Flags;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.DecimalValue;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.HandleValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.RefValue;
import org.ballerinalang.jvm.values.StreamValue;
import org.ballerinalang.jvm.values.TableValue;
import org.ballerinalang.jvm.values.TypedescValue;
import org.ballerinalang.jvm.values.XMLValue;

public class TypeChecker {
    public static Object checkCast(Object sourceVal, BType targetType) {
        if (TypeChecker.checkIsType(sourceVal, targetType)) {
            return sourceVal;
        }
        BType sourceType = TypeChecker.getType(sourceVal);
        if (sourceType.getTag() <= 6 && targetType.getTag() <= 6) {
            return TypeConverter.castValues(targetType, sourceVal);
        }
        if (sourceType.getTag() <= 6 && targetType.getTag() == 21) {
            for (BType memberType : ((BUnionType)targetType).getMemberTypes()) {
                try {
                    return TypeConverter.castValues(memberType, sourceVal);
                }
                catch (Exception exception) {
                }
            }
        }
        throw BallerinaErrors.createTypeCastError(sourceVal, targetType);
    }

    public static long anyToInt(Object sourceVal) {
        return TypeConverter.anyToIntCast(sourceVal, () -> BallerinaErrors.createTypeCastError(sourceVal, BTypes.typeInt));
    }

    public static double anyToFloat(Object sourceVal) {
        return TypeConverter.anyToFloatCast(sourceVal, () -> BallerinaErrors.createTypeCastError(sourceVal, BTypes.typeFloat));
    }

    public static boolean anyToBoolean(Object sourceVal) {
        return TypeConverter.anyToBooleanCast(sourceVal, () -> BallerinaErrors.createTypeCastError(sourceVal, BTypes.typeBoolean));
    }

    public static int anyToByte(Object sourceVal) {
        return TypeConverter.anyToByteCast(sourceVal, () -> BallerinaErrors.createTypeCastError(sourceVal, BTypes.typeByte));
    }

    public static DecimalValue anyToDecimal(Object sourceVal) {
        return TypeConverter.anyToDecimal(sourceVal, () -> BallerinaErrors.createTypeCastError(sourceVal, BTypes.typeDecimal));
    }

    public static boolean checkIsType(Object sourceVal, BType targetType) {
        BType sourceType = TypeChecker.getType(sourceVal);
        if (TypeChecker.isMutable(sourceVal, sourceType)) {
            return TypeChecker.checkIsType(sourceType, targetType, new ArrayList<TypePair>());
        }
        return TypeChecker.checkIsLikeType(sourceVal, targetType);
    }

    public static boolean checkIsLikeType(Object sourceValue, BType targetType) {
        return TypeChecker.checkIsLikeType(sourceValue, targetType, false);
    }

    public static boolean checkIsLikeType(Object sourceValue, BType targetType, boolean allowNumericConversion) {
        return TypeChecker.checkIsLikeType(sourceValue, targetType, new ArrayList<TypeValuePair>(), allowNumericConversion);
    }

    public static boolean isSameType(BType sourceType, BType targetType) {
        if (sourceType == targetType || sourceType.equals(targetType)) {
            return true;
        }
        if (sourceType.getTag() == targetType.getTag() && sourceType.getTag() == 20) {
            return TypeChecker.checkArrayEquivalent(sourceType, targetType);
        }
        if (sourceType.getTag() == 15 && targetType.getTag() == 15) {
            return targetType.equals(sourceType);
        }
        if (sourceType.getTag() == 9 && targetType.getTag() == 9) {
            return targetType.equals(sourceType);
        }
        if (sourceType.getTag() == 14 && targetType.getTag() == 14) {
            return targetType.equals(sourceType);
        }
        return false;
    }

    public static BType getType(Object value2) {
        if (value2 == null) {
            return BTypes.typeNull;
        }
        if (value2 instanceof Long) {
            return BTypes.typeInt;
        }
        if (value2 instanceof Double) {
            return BTypes.typeFloat;
        }
        if (value2 instanceof DecimalValue) {
            return BTypes.typeDecimal;
        }
        if (value2 instanceof String) {
            return BTypes.typeString;
        }
        if (value2 instanceof Boolean) {
            return BTypes.typeBoolean;
        }
        if (value2 instanceof Byte || value2 instanceof Integer) {
            return BTypes.typeByte;
        }
        return ((RefValue)value2).getType();
    }

    public static boolean isEqual(Object lhsValue, Object rhsValue) {
        return TypeChecker.isEqual(lhsValue, rhsValue, new ArrayList<ValuePair>());
    }

    public static boolean checkDecimalEqual(DecimalValue lhsValue, DecimalValue rhsValue) {
        return TypeChecker.isDecimalRealNumber(lhsValue) && TypeChecker.isDecimalRealNumber(rhsValue) && lhsValue.decimalValue().compareTo(rhsValue.decimalValue()) == 0;
    }

    public static boolean checkDecimalLessThan(DecimalValue lhsValue, DecimalValue rhsValue) {
        return TypeChecker.checkDecimalGreaterThanOrEqual(rhsValue, lhsValue);
    }

    public static boolean checkDecimalLessThanOrEqual(DecimalValue lhsValue, DecimalValue rhsValue) {
        return TypeChecker.checkDecimalGreaterThan(rhsValue, lhsValue);
    }

    public static boolean checkDecimalGreaterThan(DecimalValue lhsValue, DecimalValue rhsValue) {
        switch (lhsValue.valueKind) {
            case POSITIVE_INFINITY: {
                return TypeChecker.isDecimalRealNumber(rhsValue) || rhsValue.valueKind == DecimalValueKind.NEGATIVE_INFINITY;
            }
            case ZERO: 
            case OTHER: {
                return rhsValue.valueKind == DecimalValueKind.NEGATIVE_INFINITY || TypeChecker.isDecimalRealNumber(rhsValue) && lhsValue.decimalValue().compareTo(rhsValue.decimalValue()) > 0;
            }
        }
        return false;
    }

    public static boolean checkDecimalGreaterThanOrEqual(DecimalValue lhsValue, DecimalValue rhsValue) {
        return TypeChecker.checkDecimalGreaterThan(lhsValue, rhsValue) || TypeChecker.isDecimalRealNumber(lhsValue) && TypeChecker.isDecimalRealNumber(rhsValue) && lhsValue.decimalValue().compareTo(rhsValue.decimalValue()) == 0;
    }

    private static boolean isDecimalRealNumber(DecimalValue decimalValue) {
        return decimalValue.valueKind == DecimalValueKind.ZERO || decimalValue.valueKind == DecimalValueKind.OTHER;
    }

    public static boolean isReferenceEqual(Object lhsValue, Object rhsValue) {
        if (lhsValue == rhsValue) {
            return true;
        }
        if (lhsValue == null || rhsValue == null) {
            return false;
        }
        BType lhsType = TypeChecker.getType(lhsValue);
        BType rhsType = TypeChecker.getType(rhsValue);
        if (TypeChecker.isSimpleBasicType(lhsType) && TypeChecker.isSimpleBasicType(rhsType)) {
            return TypeChecker.isEqual(lhsValue, rhsValue);
        }
        if (TypeChecker.isHandleType(lhsType) && TypeChecker.isHandleType(rhsType)) {
            return TypeChecker.isHandleValueRefEqual(lhsValue, rhsValue);
        }
        return false;
    }

    public static TypedescValue getTypedesc(Object value2) {
        BType type = TypeChecker.getType(value2);
        if (type == null) {
            return null;
        }
        return new TypedescValue(type);
    }

    public static Object getAnnotValue(TypedescValue typedescValue, String annotTag) {
        BType describingType = typedescValue.getDescribingType();
        if (!(describingType instanceof AnnotatableType)) {
            return null;
        }
        return ((AnnotatableType)describingType).getAnnotation(annotTag);
    }

    public static boolean checkIsType(BType sourceType, BType targetType, List<TypePair> unresolvedTypes) {
        if (sourceType == targetType || sourceType.equals(targetType)) {
            return true;
        }
        switch (targetType.getTag()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                if (sourceType.getTag() == 34) {
                    return TypeChecker.isFiniteTypeMatch((BFiniteType)sourceType, targetType);
                }
                return sourceType.getTag() == targetType.getTag();
            }
            case 1: {
                if (sourceType.getTag() == 34) {
                    return ((BFiniteType)sourceType).valueSpace.stream().allMatch(bValue -> TypeChecker.checkIsType(bValue, targetType));
                }
                return sourceType.getTag() == 2 || sourceType.getTag() == 1;
            }
            case 15: {
                return TypeChecker.checkIsMapType(sourceType, (BMapType)targetType, unresolvedTypes);
            }
            case 9: {
                return TypeChecker.checkIsTableType(sourceType, (BTableType)targetType, unresolvedTypes);
            }
            case 14: {
                return TypeChecker.checkIsStreamType(sourceType, (BStreamType)targetType, unresolvedTypes);
            }
            case 7: {
                return TypeChecker.checkIsJSONType(sourceType, (BJSONType)targetType, unresolvedTypes);
            }
            case 12: {
                return TypeChecker.checkIsRecordType(sourceType, (BRecordType)targetType, unresolvedTypes);
            }
            case 37: {
                return TypeChecker.checkIsFunctionType(sourceType, (BFunctionType)targetType);
            }
            case 20: {
                return TypeChecker.checkIsArrayType(sourceType, (BArrayType)targetType, unresolvedTypes);
            }
            case 31: {
                return TypeChecker.checkIsTupleType(sourceType, (BTupleType)targetType, unresolvedTypes);
            }
            case 21: {
                return TypeChecker.checkIsUnionType(sourceType, (BUnionType)targetType, unresolvedTypes);
            }
            case 17: {
                return TypeChecker.checkIsAnyType(sourceType);
            }
            case 11: {
                return TypeChecker.isAnydata(sourceType);
            }
            case 35: {
                return TypeChecker.checkObjectEquivalency(sourceType, (BObjectType)targetType, unresolvedTypes);
            }
            case 34: {
                return TypeChecker.checkIsFiniteType(sourceType, (BFiniteType)targetType, unresolvedTypes);
            }
            case 32: {
                return TypeChecker.checkIsFutureType(sourceType, (BFutureType)targetType, unresolvedTypes);
            }
            case 29: {
                return TypeChecker.checkIsErrorType(sourceType, (BErrorType)targetType, unresolvedTypes);
            }
            case 19: {
                return TypeChecker.checkIsServiceType(sourceType);
            }
            case 38: {
                return sourceType.getTag() == 38;
            }
        }
        return false;
    }

    private static boolean isFiniteTypeMatch(BFiniteType sourceType, BType targetType) {
        for (Object bValue : sourceType.valueSpace) {
            if (TypeChecker.checkIsType(bValue, targetType)) continue;
            return false;
        }
        return true;
    }

    private static boolean isUnionTypeMatch(BUnionType sourceType, BType targetType, List<TypePair> unresolvedTypes) {
        for (BType type : sourceType.getMemberTypes()) {
            if (TypeChecker.checkIsType(type, targetType, unresolvedTypes)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkIsUnionType(BType sourceType, BUnionType targetType, List<TypePair> unresolvedTypes) {
        switch (sourceType.getTag()) {
            case 21: {
                return TypeChecker.isUnionTypeMatch((BUnionType)sourceType, targetType, unresolvedTypes);
            }
            case 34: {
                return TypeChecker.isFiniteTypeMatch((BFiniteType)sourceType, targetType);
            }
        }
        for (BType type : targetType.getMemberTypes()) {
            if (!TypeChecker.checkIsType(sourceType, type, unresolvedTypes)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkIsMapType(BType sourceType, BMapType targetType, List<TypePair> unresolvedTypes) {
        switch (sourceType.getTag()) {
            case 15: {
                return TypeChecker.checkContraints(((BMapType)sourceType).getConstrainedType(), targetType.getConstrainedType(), unresolvedTypes);
            }
            case 12: {
                BRecordType recType = (BRecordType)sourceType;
                ArrayList<BType> types = new ArrayList<BType>();
                for (BField f : recType.getFields().values()) {
                    types.add(f.type);
                }
                if (!recType.sealed) {
                    types.add(recType.restFieldType);
                }
                BUnionType fieldType = new BUnionType(types);
                return TypeChecker.checkContraints(fieldType, targetType.getConstrainedType(), unresolvedTypes);
            }
            case 7: {
                return targetType.getConstrainedType().getTag() == 7;
            }
        }
        return false;
    }

    private static boolean checkIsTableType(BType sourceType, BTableType targetType, List<TypePair> unresolvedTypes) {
        if (sourceType.getTag() != 9) {
            return false;
        }
        return TypeChecker.checkContraints(((BTableType)sourceType).getConstrainedType(), targetType.getConstrainedType(), unresolvedTypes);
    }

    private static boolean checkIsStreamType(BType sourceType, BStreamType targetType, List<TypePair> unresolvedTypes) {
        if (sourceType.getTag() != 14) {
            return false;
        }
        return TypeChecker.checkContraints(((BStreamType)sourceType).getConstrainedType(), targetType.getConstrainedType(), unresolvedTypes);
    }

    private static boolean checkIsJSONType(BType sourceType, BJSONType targetType, List<TypePair> unresolvedTypes) {
        switch (sourceType.getTag()) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                return true;
            }
            case 20: {
                return TypeChecker.checkIsType(((BArrayType)sourceType).getElementType(), targetType, unresolvedTypes);
            }
            case 34: {
                return TypeChecker.isFiniteTypeMatch((BFiniteType)sourceType, targetType);
            }
            case 15: {
                return TypeChecker.checkIsType(((BMapType)sourceType).getConstrainedType(), targetType, unresolvedTypes);
            }
        }
        return false;
    }

    private static boolean checkIsRecordType(BType sourceType, BRecordType targetType, List<TypePair> unresolvedTypes) {
        if (sourceType.getTag() != 12) {
            return false;
        }
        TypePair pair = new TypePair(sourceType, targetType);
        if (unresolvedTypes.contains(pair)) {
            return true;
        }
        unresolvedTypes.add(pair);
        BRecordType sourceRecordType = (BRecordType)sourceType;
        if (targetType.sealed && !sourceRecordType.sealed) {
            return false;
        }
        if (!sourceRecordType.sealed && !TypeChecker.checkIsType(sourceRecordType.restFieldType, targetType.restFieldType, unresolvedTypes)) {
            return false;
        }
        Map<String, BField> sourceFields = sourceRecordType.getFields();
        Set<String> targetFieldNames = targetType.getFields().keySet();
        for (BField targetField : targetType.getFields().values()) {
            BField sourceField = sourceFields.get(targetField.getFieldName());
            if (sourceField == null) {
                return false;
            }
            if (!Flags.isFlagOn(targetField.flags, 8192) && Flags.isFlagOn(sourceField.flags, 8192)) {
                return false;
            }
            if (TypeChecker.checkIsType(sourceField.type, targetField.type, unresolvedTypes)) continue;
            return false;
        }
        if (targetType.sealed) {
            return targetFieldNames.containsAll(sourceFields.keySet());
        }
        for (BField field : sourceFields.values()) {
            if (targetFieldNames.contains(field.name) || TypeChecker.checkIsType(field.getFieldType(), targetType.restFieldType, unresolvedTypes)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkIsArrayType(BType sourceType, BArrayType targetType, List<TypePair> unresolvedTypes) {
        BArrayType sourceArrayType;
        if (sourceType.getTag() == 21) {
            for (BType memberType : ((BUnionType)sourceType).getMemberTypes()) {
                if (TypeChecker.checkIsArrayType(memberType, targetType, unresolvedTypes)) continue;
                return false;
            }
            return true;
        }
        if (sourceType.getTag() != 20 && sourceType.getTag() != 31) {
            return false;
        }
        if (sourceType.getTag() == 20) {
            sourceArrayType = (BArrayType)sourceType;
        } else {
            BTupleType sourceTupleType = (BTupleType)sourceType;
            HashSet<BType> tupleTypes = new HashSet<BType>(sourceTupleType.getTupleTypes());
            if (sourceTupleType.getRestType() != null) {
                tupleTypes.add(sourceTupleType.getRestType());
            }
            sourceArrayType = new BArrayType(new BUnionType(new ArrayList<BType>(tupleTypes)));
        }
        switch (sourceArrayType.getState()) {
            case UNSEALED: {
                if (targetType.getState() == ArrayState.UNSEALED) break;
                return false;
            }
            case CLOSED_SEALED: {
                if (targetType.getState() != ArrayState.CLOSED_SEALED || sourceArrayType.getSize() == targetType.getSize()) break;
                return false;
            }
        }
        if (targetType.getElementType().getTag() <= 6) {
            return sourceArrayType.getElementType().getTag() == targetType.getElementType().getTag();
        }
        return TypeChecker.checkIsType(sourceArrayType.getElementType(), targetType.getElementType(), unresolvedTypes);
    }

    private static boolean checkIsTupleType(BType sourceType, BTupleType targetType, List<TypePair> unresolvedTypes) {
        if (sourceType.getTag() != 31) {
            return false;
        }
        ArrayList<BType> sourceTypes = new ArrayList<BType>(((BTupleType)sourceType).getTupleTypes());
        BType sourceRestType = ((BTupleType)sourceType).getRestType();
        if (sourceRestType != null) {
            sourceTypes.add(sourceRestType);
        }
        ArrayList<BType> targetTypes = new ArrayList<BType>(targetType.getTupleTypes());
        BType targetRestType = targetType.getRestType();
        if (targetRestType != null) {
            targetTypes.add(targetRestType);
        }
        if (sourceTypes.size() != targetTypes.size()) {
            return false;
        }
        for (int i = 0; i < sourceTypes.size(); ++i) {
            if (TypeChecker.checkIsType((BType)sourceTypes.get(i), (BType)targetTypes.get(i), unresolvedTypes)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkIsAnyType(BType sourceType) {
        switch (sourceType.getTag()) {
            case 29: {
                return false;
            }
            case 21: {
                for (BType memberType : ((BUnionType)sourceType).getMemberTypes()) {
                    if (TypeChecker.checkIsAnyType(memberType)) continue;
                    return false;
                }
                return true;
            }
        }
        return true;
    }

    private static boolean checkIsFiniteType(BType sourceType, BFiniteType targetType, List<TypePair> unresolvedTypes) {
        if (sourceType.getTag() != 34) {
            return false;
        }
        BFiniteType sourceFiniteType = (BFiniteType)sourceType;
        if (sourceFiniteType.valueSpace.size() != targetType.valueSpace.size()) {
            return false;
        }
        return targetType.valueSpace.containsAll(sourceFiniteType.valueSpace);
    }

    private static boolean checkIsFutureType(BType sourceType, BFutureType targetType, List<TypePair> unresolvedTypes) {
        if (sourceType.getTag() != 32) {
            return false;
        }
        return TypeChecker.checkContraints(((BFutureType)sourceType).getConstrainedType(), targetType.getConstrainedType(), unresolvedTypes);
    }

    private static boolean checkObjectEquivalency(BType sourceType, BObjectType targetType, List<TypePair> unresolvedTypes) {
        if (sourceType.getTag() != 35) {
            return false;
        }
        TypePair pair = new TypePair(sourceType, targetType);
        if (unresolvedTypes.contains(pair)) {
            return true;
        }
        unresolvedTypes.add(pair);
        BObjectType sourceObjectType = (BObjectType)sourceType;
        Map<String, BField> targetFields = targetType.getFields();
        Map<String, BField> sourceFields = sourceObjectType.getFields();
        AttachedFunction[] targetFuncs = targetType.getAttachedFunctions();
        AttachedFunction[] sourceFuncs = sourceObjectType.getAttachedFunctions();
        if (targetType.getFields().values().stream().anyMatch(field -> Flags.isFlagOn(field.flags, 1024)) || Stream.of(targetFuncs).anyMatch(func -> Flags.isFlagOn(func.flags, 1024))) {
            return false;
        }
        if (targetFields.size() > sourceFields.size() || targetFuncs.length > sourceFuncs.length) {
            return false;
        }
        for (BField lhsField : targetFields.values()) {
            BField rhsField = sourceFields.get(lhsField.name);
            if (rhsField != null && TypeChecker.isInSameVisibilityRegion(Optional.ofNullable(lhsField.type.getPackage()).map(BPackage::getName).orElse(""), Optional.ofNullable(rhsField.type.getPackage()).map(BPackage::getName).orElse(""), lhsField.flags, rhsField.flags) && TypeChecker.checkIsType(rhsField.type, lhsField.type, new ArrayList<TypePair>())) continue;
            return false;
        }
        for (AttachedFunction lhsFunc : targetFuncs) {
            AttachedFunction rhsFunc;
            if (lhsFunc == targetType.initializer || lhsFunc == targetType.defaultsValuesInitFunc || (rhsFunc = TypeChecker.getMatchingInvokableType(sourceFuncs, lhsFunc, unresolvedTypes)) != null && TypeChecker.isInSameVisibilityRegion(Optional.ofNullable(lhsFunc.type.getPackage()).map(BPackage::getName).orElse(""), Optional.ofNullable(rhsFunc.type.getPackage()).map(BPackage::getName).orElse(""), lhsFunc.flags, rhsFunc.flags)) continue;
            return false;
        }
        return true;
    }

    private static boolean isInSameVisibilityRegion(String lhsTypePkg, String rhsTypePkg, int lhsFlags, int rhsFlags) {
        if (Flags.isFlagOn(lhsFlags, 1024)) {
            return lhsTypePkg.equals(rhsTypePkg);
        }
        if (Flags.isFlagOn(lhsFlags, 1)) {
            return Flags.isFlagOn(rhsFlags, 1);
        }
        return !Flags.isFlagOn(rhsFlags, 1024) && !Flags.isFlagOn(rhsFlags, 1) && lhsTypePkg.equals(rhsTypePkg);
    }

    private static AttachedFunction getMatchingInvokableType(AttachedFunction[] rhsFuncs, AttachedFunction lhsFunc, List<TypePair> unresolvedTypes) {
        return Arrays.stream(rhsFuncs).filter(rhsFunc -> lhsFunc.funcName.equals(rhsFunc.funcName)).filter(rhsFunc -> TypeChecker.checkFunctionTypeEqualityForObjectType(rhsFunc.type, lhsFunc.type, unresolvedTypes)).findFirst().orElse(null);
    }

    private static boolean checkFunctionTypeEqualityForObjectType(BFunctionType source2, BFunctionType target, List<TypePair> unresolvedTypes) {
        if (source2.paramTypes.length != target.paramTypes.length) {
            return false;
        }
        for (int i = 0; i < source2.paramTypes.length; ++i) {
            if (TypeChecker.checkIsType(target.paramTypes[i], source2.paramTypes[i], unresolvedTypes)) continue;
            return false;
        }
        if (source2.retType == null && target.retType == null) {
            return true;
        }
        if (source2.retType == null || target.retType == null) {
            return false;
        }
        return TypeChecker.checkIsType(source2.retType, target.retType, unresolvedTypes);
    }

    private static boolean checkIsFunctionType(BType sourceType, BFunctionType targetType) {
        if (sourceType.getTag() != 37) {
            return false;
        }
        BFunctionType source2 = (BFunctionType)sourceType;
        if (source2.paramTypes.length != targetType.paramTypes.length) {
            return false;
        }
        for (int i = 0; i < source2.paramTypes.length; ++i) {
            if (TypeChecker.checkIsType(targetType.paramTypes[i], source2.paramTypes[i], new ArrayList<TypePair>())) continue;
            return false;
        }
        return TypeChecker.checkIsType(source2.retType, targetType.retType, new ArrayList<TypePair>());
    }

    private static boolean checkIsServiceType(BType sourceType) {
        if (sourceType.getTag() == 19) {
            return true;
        }
        if (sourceType.getTag() == 35) {
            int flags = ((BObjectType)sourceType).flags;
            return (flags & 0x80000) == 524288;
        }
        return false;
    }

    private static boolean checkContraints(BType sourceConstraint, BType targetConstraint, List<TypePair> unresolvedTypes) {
        if (sourceConstraint == null) {
            sourceConstraint = BTypes.typeAny;
        }
        if (targetConstraint == null) {
            targetConstraint = BTypes.typeAny;
        }
        return TypeChecker.checkIsType(sourceConstraint, targetConstraint, unresolvedTypes);
    }

    private static boolean isMutable(Object value2, BType sourceType) {
        if (value2 == null || sourceType.getTag() < 7 || sourceType.getTag() == 34) {
            return false;
        }
        return !((RefValue)value2).isFrozen();
    }

    private static boolean checkArrayEquivalent(BType actualType, BType expType) {
        if (expType.getTag() == 20 && actualType.getTag() == 20) {
            BArrayType lhrArrayType = (BArrayType)expType;
            BArrayType rhsArrayType = (BArrayType)actualType;
            return TypeChecker.checkIsArrayType(rhsArrayType, lhrArrayType, new ArrayList<TypePair>());
        }
        return expType == actualType;
    }

    static boolean checkIsLikeType(Object sourceValue, BType targetType, List<TypeValuePair> unresolvedValues, boolean allowNumericConversion) {
        BType sourceType = TypeChecker.getType(sourceValue);
        if (sourceType.getTag() == 1 && targetType.getTag() == 2) {
            return TypeChecker.isByteLiteral((Long)sourceValue);
        }
        if (TypeChecker.checkIsType(sourceType, targetType, new ArrayList<TypePair>())) {
            return true;
        }
        switch (targetType.getTag()) {
            case 2: {
                return allowNumericConversion && TypeConverter.isConvertibleToByte(sourceValue);
            }
            case 1: {
                return allowNumericConversion && TypeConverter.isConvertibleToInt(sourceValue);
            }
            case 3: 
            case 4: {
                return allowNumericConversion && TypeConverter.isConvertibleToFloatingPointTypes(sourceValue);
            }
            case 12: {
                return TypeChecker.checkIsLikeRecordType(sourceValue, (BRecordType)targetType, unresolvedValues, allowNumericConversion);
            }
            case 7: {
                return TypeChecker.checkIsLikeJSONType(sourceValue, sourceType, (BJSONType)targetType, unresolvedValues, allowNumericConversion);
            }
            case 15: {
                return TypeChecker.checkIsLikeMapType(sourceValue, (BMapType)targetType, unresolvedValues, allowNumericConversion);
            }
            case 9: {
                return TypeChecker.checkIsLikeTableType(sourceValue, (BTableType)targetType, unresolvedValues);
            }
            case 14: {
                return TypeChecker.checkIsLikeStreamType(sourceValue, (BStreamType)targetType);
            }
            case 20: {
                return TypeChecker.checkIsLikeArrayType(sourceValue, (BArrayType)targetType, unresolvedValues, allowNumericConversion);
            }
            case 31: {
                return TypeChecker.checkIsLikeTupleType(sourceValue, (BTupleType)targetType, unresolvedValues, allowNumericConversion);
            }
            case 29: {
                return TypeChecker.checkIsLikeErrorType(sourceValue, (BErrorType)targetType, unresolvedValues, allowNumericConversion);
            }
            case 11: {
                return TypeChecker.checkIsLikeAnydataType(sourceValue, sourceType, unresolvedValues, allowNumericConversion);
            }
            case 34: {
                return TypeChecker.checkFiniteTypeAssignable(sourceValue, sourceType, (BFiniteType)targetType);
            }
            case 21: {
                if (allowNumericConversion) {
                    ArrayList<BType> compatibleTypesWithNumConversion = new ArrayList<BType>();
                    ArrayList<BType> compatibleTypesWithoutNumConversion = new ArrayList<BType>();
                    for (BType type : ((BUnionType)targetType).getMemberTypes()) {
                        if (TypeChecker.checkIsLikeType(sourceValue, type, unresolvedValues, false)) {
                            compatibleTypesWithoutNumConversion.add(type);
                        }
                        if (!TypeChecker.checkIsLikeType(sourceValue, type, unresolvedValues, true)) continue;
                        compatibleTypesWithNumConversion.add(type);
                    }
                    return compatibleTypesWithNumConversion.size() != 0 && compatibleTypesWithNumConversion.size() - compatibleTypesWithoutNumConversion.size() <= 1;
                }
                for (BType type : ((BUnionType)targetType).getMemberTypes()) {
                    if (!TypeChecker.checkIsLikeType(sourceValue, type, unresolvedValues, false)) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public static boolean isNumericType(BType type) {
        return type.getTag() < 5;
    }

    private static boolean checkIsLikeAnydataType(Object sourceValue, BType sourceType, List<TypeValuePair> unresolvedValues, boolean allowNumericConversion) {
        switch (sourceType.getTag()) {
            case 7: 
            case 12: 
            case 15: {
                return TypeChecker.isLikeType(((MapValueImpl)sourceValue).values().toArray(), BTypes.typeAnydata, unresolvedValues, allowNumericConversion);
            }
            case 20: {
                ArrayValue arr = (ArrayValue)sourceValue;
                BArrayType arrayType = (BArrayType)arr.getType();
                switch (arrayType.getElementType().getTag()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        return true;
                    }
                }
                return TypeChecker.isLikeType(arr.getValues(), BTypes.typeAnydata, unresolvedValues, allowNumericConversion);
            }
            case 31: {
                return TypeChecker.isLikeType(((ArrayValue)sourceValue).getValues(), BTypes.typeAnydata, unresolvedValues, allowNumericConversion);
            }
            case 11: {
                return true;
            }
            case 21: 
            case 34: {
                return TypeChecker.checkIsLikeType(sourceValue, BTypes.typeAnydata, unresolvedValues, allowNumericConversion);
            }
        }
        return false;
    }

    private static boolean isLikeType(Object[] objects, BType targetType, List<TypeValuePair> unresolvedValues, boolean allowNumericConversion) {
        for (Object value2 : objects) {
            if (TypeChecker.checkIsLikeType(value2, targetType, unresolvedValues, allowNumericConversion)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkIsLikeTupleType(Object sourceValue, BTupleType targetType, List<TypeValuePair> unresolvedValues, boolean allowNumericConversion) {
        if (!(sourceValue instanceof ArrayValue)) {
            return false;
        }
        ArrayValue source2 = (ArrayValue)sourceValue;
        if (source2.size() != targetType.getTupleTypes().size()) {
            return false;
        }
        if (BTypes.isValueType(source2.elementType)) {
            int bound = source2.size();
            for (int i = 0; i < bound; ++i) {
                if (TypeChecker.checkIsType(source2.elementType, targetType.getTupleTypes().get(i), new ArrayList<TypePair>())) continue;
                return false;
            }
            return true;
        }
        int bound = source2.size();
        for (int i = 0; i < bound; ++i) {
            if (TypeChecker.checkIsLikeType(source2.getRefValue(i), targetType.getTupleTypes().get(i), unresolvedValues, allowNumericConversion)) continue;
            return false;
        }
        return true;
    }

    private static boolean isByteLiteral(long longValue) {
        return longValue >= (long)BLangConstants.BBYTE_MIN_VALUE.intValue() && longValue <= (long)BLangConstants.BBYTE_MAX_VALUE.intValue();
    }

    private static boolean checkIsLikeArrayType(Object sourceValue, BArrayType targetType, List<TypeValuePair> unresolvedValues, boolean allowNumericConversion) {
        if (!(sourceValue instanceof ArrayValue)) {
            return false;
        }
        ArrayValue source2 = (ArrayValue)sourceValue;
        BType targetTypeElementType = targetType.getElementType();
        if (BTypes.isValueType(source2.elementType)) {
            boolean isType = TypeChecker.checkIsType(source2.elementType, targetTypeElementType, new ArrayList<TypePair>());
            if (isType || !allowNumericConversion || !TypeChecker.isNumericType(source2.elementType)) {
                return isType;
            }
            if (TypeChecker.isNumericType(targetTypeElementType)) {
                return true;
            }
            if (targetTypeElementType.getTag() != 21) {
                return false;
            }
            ArrayList<BType> targetNumericTypes = new ArrayList<BType>();
            for (BType memType : ((BUnionType)targetTypeElementType).getMemberTypes()) {
                if (!TypeChecker.isNumericType(memType) || targetNumericTypes.contains(memType)) continue;
                targetNumericTypes.add(memType);
            }
            return targetNumericTypes.size() == 1;
        }
        Object[] arrayValues = source2.getValues();
        for (int i = 0; i < ((ArrayValue)sourceValue).size(); ++i) {
            if (TypeChecker.checkIsLikeType(arrayValues[i], targetTypeElementType, unresolvedValues, allowNumericConversion)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkIsLikeMapType(Object sourceValue, BMapType targetType, List<TypeValuePair> unresolvedValues, boolean allowNumericConversion) {
        if (!(sourceValue instanceof MapValueImpl)) {
            return false;
        }
        for (Object mapEntry : ((MapValueImpl)sourceValue).values()) {
            if (TypeChecker.checkIsLikeType(mapEntry, targetType.getConstrainedType(), unresolvedValues, allowNumericConversion)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkIsLikeTableType(Object sourceValue, BTableType targetType, List<TypeValuePair> unresolvedValues) {
        if (!(sourceValue instanceof TableValue)) {
            return false;
        }
        BTableType tableType = (BTableType)((TableValue)sourceValue).getType();
        return tableType.getConstrainedType() == targetType.getConstrainedType();
    }

    private static boolean checkIsLikeStreamType(Object sourceValue, BStreamType targetType) {
        if (!(sourceValue instanceof StreamValue)) {
            return false;
        }
        BStreamType streamType = (BStreamType)((StreamValue)sourceValue).getType();
        return streamType.getConstrainedType() == targetType.getConstrainedType();
    }

    private static boolean checkIsLikeJSONType(Object sourceValue, BType sourceType, BJSONType targetType, List<TypeValuePair> unresolvedValues, boolean allowNumericConversion) {
        if (sourceType.getTag() == 20) {
            ArrayValue source2 = (ArrayValue)sourceValue;
            if (BTypes.isValueType(source2.elementType)) {
                return TypeChecker.checkIsType(source2.elementType, targetType, new ArrayList<TypePair>());
            }
            Object[] arrayValues = source2.getValues();
            for (int i = 0; i < ((ArrayValue)sourceValue).size(); ++i) {
                if (TypeChecker.checkIsLikeType(arrayValues[i], targetType, unresolvedValues, allowNumericConversion)) continue;
                return false;
            }
            return true;
        }
        if (sourceType.getTag() == 15) {
            for (Object value2 : ((MapValueImpl)sourceValue).values()) {
                if (TypeChecker.checkIsLikeType(value2, targetType, unresolvedValues, allowNumericConversion)) continue;
                return false;
            }
            return true;
        }
        if (sourceType.getTag() == 12) {
            TypeValuePair typeValuePair = new TypeValuePair(sourceValue, targetType);
            if (unresolvedValues.contains(typeValuePair)) {
                return true;
            }
            unresolvedValues.add(typeValuePair);
            for (Object object : ((MapValueImpl)sourceValue).values()) {
                if (TypeChecker.checkIsLikeType(object, targetType, unresolvedValues, allowNumericConversion)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean checkIsLikeRecordType(Object sourceValue, BRecordType targetType, List<TypeValuePair> unresolvedValues, boolean allowNumericConversion) {
        if (!(sourceValue instanceof MapValueImpl)) {
            return false;
        }
        TypeValuePair typeValuePair = new TypeValuePair(sourceValue, targetType);
        if (unresolvedValues.contains(typeValuePair)) {
            return true;
        }
        unresolvedValues.add(typeValuePair);
        HashMap<String, BType> targetTypeField = new HashMap<String, BType>();
        BType restFieldType = targetType.restFieldType;
        for (BField bField : targetType.getFields().values()) {
            targetTypeField.put(bField.getFieldName(), bField.type);
        }
        for (Map.Entry entry : targetTypeField.entrySet()) {
            String fieldName = entry.getKey().toString();
            if (((MapValueImpl)sourceValue).containsKey(fieldName) || Flags.isFlagOn(targetType.getFields().get((Object)fieldName).flags, 8192)) continue;
            return false;
        }
        for (Object object : ((MapValueImpl)sourceValue).entrySet()) {
            Map.Entry valueEntry = (Map.Entry)object;
            String fieldName = valueEntry.getKey().toString();
            if (targetTypeField.containsKey(fieldName)) {
                if (TypeChecker.checkIsLikeType(valueEntry.getValue(), (BType)targetTypeField.get(fieldName), unresolvedValues, allowNumericConversion)) continue;
                return false;
            }
            if (!targetType.sealed) {
                if (TypeChecker.checkIsLikeType(valueEntry.getValue(), restFieldType, unresolvedValues, allowNumericConversion)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static boolean checkFiniteTypeAssignable(Object bRefTypeValue, BType sourceType, BFiniteType lhsType) {
        if (bRefTypeValue == null) {
            return false;
        }
        for (Object valueSpaceItem : lhsType.valueSpace) {
            if (TypeChecker.getType(valueSpaceItem).getTag() != sourceType.getTag() || !valueSpaceItem.equals(bRefTypeValue)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkIsErrorType(BType sourceType, BErrorType targetType, List<TypePair> unresolvedTypes) {
        if (sourceType.getTag() != 29) {
            return false;
        }
        TypePair pair = new TypePair(sourceType, targetType);
        if (unresolvedTypes.contains(pair)) {
            return true;
        }
        unresolvedTypes.add(pair);
        BErrorType bErrorType = (BErrorType)sourceType;
        boolean reasonTypeMatched = TypeChecker.checkIsType(bErrorType.reasonType, targetType.reasonType, unresolvedTypes);
        return reasonTypeMatched && TypeChecker.checkIsType(bErrorType.detailType, targetType.detailType, unresolvedTypes);
    }

    private static boolean checkIsLikeErrorType(Object sourceValue, BErrorType targetType, List<TypeValuePair> unresolvedValues, boolean allowNumericConversion) {
        BType sourceType = TypeChecker.getType(sourceValue);
        if (sourceValue == null || sourceType.getTag() != 29) {
            return false;
        }
        return TypeChecker.checkIsLikeType(((ErrorValue)sourceValue).getReason(), targetType.reasonType, unresolvedValues, allowNumericConversion) && TypeChecker.checkIsLikeType(((ErrorValue)sourceValue).getDetails(), targetType.detailType, unresolvedValues, allowNumericConversion);
    }

    private static boolean isAnydata(BType type) {
        return TypeChecker.isAnydata(type, new HashSet<BType>());
    }

    private static boolean isAnydata(BType type, Set<BType> unresolvedTypes) {
        if (type.getTag() <= 11) {
            return true;
        }
        switch (type.getTag()) {
            case 15: {
                return TypeChecker.isPureType(((BMapType)type).getConstrainedType(), unresolvedTypes);
            }
            case 12: {
                if (unresolvedTypes.contains(type)) {
                    return true;
                }
                unresolvedTypes.add(type);
                BRecordType recordType = (BRecordType)type;
                for (BField field : recordType.getFields().values()) {
                    if (TypeChecker.isPureType(field.getFieldType(), unresolvedTypes)) continue;
                    return false;
                }
                return recordType.sealed || TypeChecker.isPureType(recordType.restFieldType, unresolvedTypes);
            }
            case 21: {
                return TypeChecker.isAnydata(((BUnionType)type).getMemberTypes(), unresolvedTypes);
            }
            case 31: {
                return TypeChecker.isPureType(((BTupleType)type).getTupleTypes(), unresolvedTypes);
            }
            case 20: {
                return TypeChecker.isPureType(((BArrayType)type).getElementType(), unresolvedTypes);
            }
            case 34: {
                for (Object value2 : ((BFiniteType)type).valueSpace) {
                    if (TypeChecker.isAnydata(TypeChecker.getType(value2))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private static boolean isAnydata(Collection<BType> types, Set<BType> unresolvedTypes) {
        for (BType type : types) {
            if (TypeChecker.isAnydata(type, unresolvedTypes)) continue;
            return false;
        }
        return true;
    }

    private static boolean isPureType(BType type, Set<BType> unresolvedTypes) {
        switch (type.getTag()) {
            case 21: {
                return TypeChecker.isPureType(((BUnionType)type).getMemberTypes(), unresolvedTypes);
            }
            case 29: {
                return true;
            }
        }
        return TypeChecker.isAnydata(type, unresolvedTypes);
    }

    private static boolean isPureType(Collection<BType> types, Set<BType> unresolvedTypes) {
        for (BType type : types) {
            if (TypeChecker.isPureType(type, unresolvedTypes)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSimpleBasicType(BType type) {
        return type.getTag() < 7;
    }

    private static boolean isHandleType(BType type) {
        return type.getTag() == 38;
    }

    private static boolean isEqual(Object lhsValue, Object rhsValue, List<ValuePair> checkedValues) {
        if (lhsValue == rhsValue) {
            return true;
        }
        if (null == lhsValue || null == rhsValue) {
            return false;
        }
        int lhsValTypeTag = TypeChecker.getType(lhsValue).getTag();
        int rhsValTypeTag = TypeChecker.getType(rhsValue).getTag();
        switch (lhsValTypeTag) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return lhsValue.equals(rhsValue);
            }
            case 1: {
                if (rhsValTypeTag <= 3) {
                    return lhsValue.equals(((Number)rhsValue).longValue());
                }
                if (rhsValTypeTag == 4) {
                    return DecimalValue.valueOf((Long)lhsValue).equals(rhsValue);
                }
                return false;
            }
            case 2: {
                if (rhsValTypeTag <= 3) {
                    return ((Number)lhsValue).byteValue() == ((Number)rhsValue).byteValue();
                }
                if (rhsValTypeTag == 4) {
                    return DecimalValue.valueOf((Integer)lhsValue).equals(rhsValue);
                }
                return false;
            }
            case 8: {
                return XMLFactory.isEqual((XMLValue)lhsValue, (XMLValue)rhsValue);
            }
            case 9: {
                break;
            }
            case 7: 
            case 12: 
            case 15: {
                return TypeChecker.isMappingType(rhsValTypeTag) && TypeChecker.isEqual((MapValueImpl)lhsValue, (MapValueImpl)rhsValue, checkedValues);
            }
            case 20: 
            case 31: {
                return TypeChecker.isListType(rhsValTypeTag) && TypeChecker.isEqual((ArrayValue)lhsValue, (ArrayValue)rhsValue, checkedValues);
            }
            case 29: {
                return rhsValTypeTag == 29 && TypeChecker.isEqual((ErrorValue)lhsValue, (ErrorValue)rhsValue, checkedValues);
            }
        }
        return false;
    }

    private static boolean isListType(int typeTag) {
        return typeTag == 20 || typeTag == 31;
    }

    private static boolean isMappingType(int typeTag) {
        return typeTag == 15 || typeTag == 12 || typeTag == 7;
    }

    private static boolean isEqual(ArrayValue lhsList, ArrayValue rhsList, List<ValuePair> checkedValues) {
        ValuePair compValuePair = new ValuePair(lhsList, rhsList);
        if (checkedValues.contains(compValuePair)) {
            return true;
        }
        checkedValues.add(compValuePair);
        if (lhsList.size() != rhsList.size()) {
            return false;
        }
        for (int i = 0; i < lhsList.size(); ++i) {
            if (TypeChecker.isEqual(lhsList.getValue(i), rhsList.getValue(i), checkedValues)) continue;
            return false;
        }
        return true;
    }

    private static boolean isEqual(MapValueImpl lhsMap, MapValueImpl rhsMap, List<ValuePair> checkedValues) {
        ValuePair compValuePair = new ValuePair(lhsMap, rhsMap);
        if (checkedValues.contains(compValuePair)) {
            return true;
        }
        checkedValues.add(compValuePair);
        if (lhsMap.size() != rhsMap.size()) {
            return false;
        }
        if (!lhsMap.keySet().containsAll(rhsMap.keySet())) {
            return false;
        }
        for (Map.Entry lhsMapEntry : lhsMap.entrySet()) {
            if (TypeChecker.isEqual(lhsMapEntry.getValue(), rhsMap.get(lhsMapEntry.getKey()), checkedValues)) continue;
            return false;
        }
        return true;
    }

    private static boolean isEqual(ErrorValue lhsError, ErrorValue rhsError, List<ValuePair> checkedValues) {
        ValuePair compValuePair = new ValuePair(lhsError, rhsError);
        if (checkedValues.contains(compValuePair)) {
            return true;
        }
        checkedValues.add(compValuePair);
        return TypeChecker.isEqual(lhsError.getReason(), rhsError.getReason(), checkedValues) && TypeChecker.isEqual((MapValueImpl)lhsError.getDetails(), (MapValueImpl)rhsError.getDetails(), checkedValues);
    }

    private static boolean isHandleValueRefEqual(Object lhsValue, Object rhsValue) {
        HandleValue lhsHandle = (HandleValue)lhsValue;
        HandleValue rhsHandle = (HandleValue)rhsValue;
        return lhsHandle.getValue() == rhsHandle.getValue();
    }

    public static boolean hasFillerValue(BType type) {
        return TypeChecker.hasFillerValue(type, new ArrayList<BType>());
    }

    private static boolean hasFillerValue(BType type, List<BType> unanalyzedTypes) {
        if (type == null) {
            return true;
        }
        if (type.getTag() < 12) {
            return true;
        }
        switch (type.getTag()) {
            case 14: 
            case 15: 
            case 17: {
                return true;
            }
            case 20: {
                return TypeChecker.checkFillerValue((BArrayType)type);
            }
            case 34: {
                return TypeChecker.checkFillerValue((BFiniteType)type);
            }
            case 35: {
                return TypeChecker.checkFillerValue((BObjectType)type);
            }
            case 12: {
                return TypeChecker.checkFillerValue((BRecordType)type, unanalyzedTypes);
            }
            case 31: {
                BTupleType tupleType = (BTupleType)type;
                return tupleType.getTupleTypes().stream().allMatch(TypeChecker::hasFillerValue);
            }
            case 21: {
                return TypeChecker.checkFillerValue((BUnionType)type);
            }
        }
        return false;
    }

    private static boolean checkFillerValue(BUnionType type) {
        if (type.isNullable()) {
            return true;
        }
        Iterator<BType> iterator = type.getMemberTypes().iterator();
        BType firstMember = iterator.next();
        while (iterator.hasNext()) {
            if (TypeChecker.isSameType(firstMember, iterator.next())) continue;
            return false;
        }
        return BTypes.isValueType(firstMember) && TypeChecker.hasFillerValue(firstMember);
    }

    private static boolean checkFillerValue(BRecordType type, List<BType> unAnalyzedTypes) {
        if (unAnalyzedTypes.contains(type)) {
            return true;
        }
        unAnalyzedTypes.add(type);
        for (BField field : type.getFields().values()) {
            if (Flags.isFlagOn(field.flags, 8192) || !Flags.isFlagOn(field.flags, 8192) && !Flags.isFlagOn(field.flags, 256)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkFillerValue(BArrayType type) {
        return type.getState() != ArrayState.CLOSED_SEALED && type.getState() != ArrayState.OPEN_SEALED;
    }

    private static boolean checkFillerValue(BObjectType type) {
        if (type.getTag() == 19) {
            return false;
        }
        AttachedFunction initializerFunc = type.initializer;
        if (initializerFunc == null) {
            return false;
        }
        BFunctionType initFuncType = initializerFunc.type;
        boolean noParams = initFuncType.paramTypes.length == 0;
        boolean nilReturn = initFuncType.retType.getTag() == 10;
        return noParams && nilReturn;
    }

    private static boolean checkFillerValue(BFiniteType type) {
        for (Object value2 : type.valueSpace) {
            if (value2 != null) continue;
            return true;
        }
        if (type.valueSpace.size() == 1) {
            return true;
        }
        Object firstElement = type.valueSpace.iterator().next();
        for (Object value3 : type.valueSpace) {
            if (value3.getClass() == firstElement.getClass()) continue;
            return false;
        }
        if (firstElement instanceof String) {
            return TypeChecker.containsElement(type.valueSpace, "\"\"");
        }
        if (firstElement instanceof Byte || firstElement instanceof Integer || firstElement instanceof Long) {
            return TypeChecker.containsElement(type.valueSpace, "0");
        }
        if (firstElement instanceof Float || firstElement instanceof Double || firstElement instanceof BigDecimal) {
            return TypeChecker.containsElement(type.valueSpace, "0.0");
        }
        if (firstElement instanceof Boolean) {
            return TypeChecker.containsElement(type.valueSpace, "false");
        }
        return false;
    }

    private static boolean containsElement(Set<Object> valueSpace, String e) {
        for (Object value2 : valueSpace) {
            if (value2 == null || !value2.toString().equals(e)) continue;
            return true;
        }
        return false;
    }

    private static class ValuePair {
        ArrayList<Object> valueList = new ArrayList(2);

        ValuePair(Object valueOne, Object valueTwo) {
            this.valueList.add(valueOne);
            this.valueList.add(valueTwo);
        }

        public boolean equals(Object otherPair) {
            if (!(otherPair instanceof ValuePair)) {
                return false;
            }
            ArrayList<Object> otherList = ((ValuePair)otherPair).valueList;
            ArrayList<Object> currentList = this.valueList;
            if (otherList.size() != currentList.size()) {
                return false;
            }
            for (int i = 0; i < otherList.size(); ++i) {
                if (otherList.get(i).equals(currentList.get(i))) continue;
                return false;
            }
            return true;
        }
    }

    private static class TypePair {
        BType sourceType;
        BType targetType;

        public TypePair(BType sourceType, BType targetType) {
            this.sourceType = sourceType;
            this.targetType = targetType;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TypePair)) {
                return false;
            }
            TypePair other = (TypePair)obj;
            return this.sourceType.equals(other.sourceType) && this.targetType.equals(other.targetType);
        }
    }
}

