/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.launch;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.LogManager;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.jvm.launch.LaunchListener;
import org.ballerinalang.jvm.util.BLangConstants;
import org.ballerinalang.jvm.util.RuntimeUtils;
import org.ballerinalang.logging.BLogManager;

public class LaunchUtils {
    private static PrintStream errStream;

    public static String[] initConfigurations(String[] args) {
        if (ConfigRegistry.getInstance().isInitialized()) {
            return args;
        }
        HashMap<String, String> configArgs = new HashMap<String, String>();
        ArrayList<String> userProgramArgs = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String configString;
            String[] keyValuePair;
            if (args[i].equals("--")) {
                userProgramArgs.addAll(Arrays.asList(Arrays.copyOfRange(args, i + 1, args.length)));
                break;
            }
            if (args[i].toLowerCase().startsWith("--") && (keyValuePair = (configString = args[i].substring(BLangConstants.BALLERINA_ARGS_INIT_PREFIX_LENGTH)).split("=")).length >= 2) {
                configArgs.put(keyValuePair[0], configString.substring(keyValuePair[0].length() + 1));
                continue;
            }
            userProgramArgs.add(args[i]);
        }
        String observeFlag = (String)configArgs.get("b7a.observability.enabled");
        LaunchUtils.loadConfigurations(configArgs, (String)configArgs.get("b7a.config.file"), Boolean.parseBoolean(observeFlag));
        return userProgramArgs.toArray(new String[0]);
    }

    public static void startListeners(boolean isService) {
        ServiceLoader<LaunchListener> listeners = ServiceLoader.load(LaunchListener.class);
        listeners.forEach(listener -> listener.beforeRunProgram(isService));
    }

    public static void stopListeners(boolean isService) {
        ServiceLoader<LaunchListener> listeners = ServiceLoader.load(LaunchListener.class);
        listeners.forEach(listener -> listener.afterRunProgram(isService));
    }

    private static void loadConfigurations(Map<String, String> configArgs, String configFilePath, boolean observeFlag) {
        Path ballerinaConfPath = Paths.get(System.getProperty("user.dir"), new String[0]).resolve("ballerina.conf");
        try {
            ConfigRegistry.getInstance().initRegistry(configArgs, configFilePath, ballerinaConfPath);
            LogManager logManager = LogManager.getLogManager();
            if (logManager instanceof BLogManager) {
                ((BLogManager)logManager).loadUserProvidedLogConfiguration();
            }
            if (observeFlag) {
                ConfigRegistry.getInstance().addConfiguration("b7a.observability.metrics.enabled", Boolean.TRUE);
                ConfigRegistry.getInstance().addConfiguration("b7a.observability.tracing.enabled", Boolean.TRUE);
            }
        }
        catch (IOException e) {
            RuntimeUtils.handleUsageError("failed to read the specified configuration file: " + configFilePath);
        }
        catch (RuntimeException e) {
            RuntimeUtils.handleUsageError(e.getMessage());
        }
    }

    static {
        System.setProperty("java.util.logging.config.class", "org.ballerinalang.logging.util.LogConfigReader");
        System.setProperty("java.util.logging.manager", "org.ballerinalang.logging.BLogManager");
        errStream = System.err;
    }
}

