/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.observability.metrics;

import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ServiceLoader;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.jvm.launch.LaunchListener;
import org.ballerinalang.jvm.observability.ObserveUtils;
import org.ballerinalang.jvm.observability.metrics.BallerinaMetricsObserver;
import org.ballerinalang.jvm.observability.metrics.DefaultMetricRegistry;
import org.ballerinalang.jvm.observability.metrics.Gauge;
import org.ballerinalang.jvm.observability.metrics.MetricRegistry;
import org.ballerinalang.jvm.observability.metrics.noop.NoOpMetricProvider;
import org.ballerinalang.jvm.observability.metrics.noop.NoOpMetricReporter;
import org.ballerinalang.jvm.observability.metrics.spi.MetricProvider;
import org.ballerinalang.jvm.observability.metrics.spi.MetricReporter;
import org.ballerinalang.jvm.observability.tracer.InvalidConfigurationException;

public class MetricsLaunchListener
implements LaunchListener {
    private static final PrintStream consoleError = System.err;
    private static final String METRIC_PROVIDER_NAME = "b7a.observability.metrics.provider";
    private static final String METRIC_REPORTER_NAME = "b7a.observability.metrics.reporter";
    private static final String DEFAULT_METRIC_PROVIDER_NAME = "default";
    private static final String DEFAULT_METRIC_REPORTER_NAME = "prometheus";

    @Override
    public void beforeRunProgram(boolean service) {
        if (DefaultMetricRegistry.getInstance() == null || DefaultMetricRegistry.isNoOp) {
            ConfigRegistry configRegistry = ConfigRegistry.getInstance();
            if (!configRegistry.isInitialized()) {
                return;
            }
            if (!configRegistry.getAsBoolean("b7a.observability.metrics.enabled")) {
                DefaultMetricRegistry.setInstance(new MetricRegistry(new NoOpMetricProvider()));
                DefaultMetricRegistry.isNoOp = true;
                return;
            }
            MetricProvider metricProvider = this.loadMetricProvider(configRegistry);
            metricProvider.init();
            DefaultMetricRegistry.setInstance(new MetricRegistry(metricProvider));
            DefaultMetricRegistry.isNoOp = false;
            this.registerBallerinaMetrics();
            MetricReporter reporter2 = this.loadMetricReporter(configRegistry);
            try {
                reporter2.init();
            }
            catch (InvalidConfigurationException e) {
                consoleError.println("Invalid configuration error when initializing metrics reporter. " + e.getMessage());
            }
            ObserveUtils.addObserver(new BallerinaMetricsObserver());
        }
    }

    private MetricProvider loadMetricProvider(ConfigRegistry configRegistry) {
        String providerName = configRegistry.getConfigOrDefault(METRIC_PROVIDER_NAME, DEFAULT_METRIC_PROVIDER_NAME);
        for (MetricProvider temp : ServiceLoader.load(MetricProvider.class)) {
            if (providerName == null || !providerName.equalsIgnoreCase(temp.getName())) continue;
            return temp;
        }
        return new NoOpMetricProvider();
    }

    private MetricReporter loadMetricReporter(ConfigRegistry configRegistry) {
        String reporterName = configRegistry.getConfigOrDefault(METRIC_REPORTER_NAME, DEFAULT_METRIC_REPORTER_NAME);
        for (MetricReporter temp : ServiceLoader.load(MetricReporter.class)) {
            if (reporterName == null || !reporterName.equalsIgnoreCase(temp.getName())) continue;
            return temp;
        }
        return new NoOpMetricReporter();
    }

    private void registerBallerinaMetrics() {
    }

    @Override
    public void afterRunProgram(boolean service) {
        if (service) {
            Gauge gauge = Gauge.builder("startup_time_milliseconds").description("Startup time in milliseconds").register();
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            gauge.setValue(System.currentTimeMillis() - runtimeMXBean.getStartTime());
        }
    }
}

