/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.scheduling;

import java.util.function.Consumer;
import java.util.function.Function;
import org.ballerinalang.jvm.scheduling.State;
import org.ballerinalang.jvm.values.FutureValue;

class SchedulerItem {
    private Function function;
    private Consumer consumer;
    private boolean isVoid;
    private Object[] params;
    final FutureValue future;
    boolean parked;
    public static final SchedulerItem POISON_PILL = new SchedulerItem();

    public SchedulerItem(Function function, Object[] params, FutureValue future2) {
        this.future = future2;
        this.function = function;
        this.params = params;
        this.isVoid = false;
    }

    public SchedulerItem(Consumer consumer, Object[] params, FutureValue future2) {
        this.future = future2;
        this.consumer = consumer;
        this.params = params;
        this.isVoid = true;
    }

    private SchedulerItem() {
        this.future = null;
    }

    public Object execute() {
        if (this.isVoid) {
            this.consumer.accept(this.params);
            return null;
        }
        return this.function.apply(this.params);
    }

    public boolean isYielded() {
        return this.future.strand.isYielded();
    }

    public State getState() {
        return this.future.strand.getState();
    }

    public void setState(State state) {
        this.future.strand.setState(state);
    }

    public String toString() {
        return this.future == null ? "POISON_PILL" : String.valueOf(this.future.strand.hashCode());
    }
}

