/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.types;

import java.util.StringJoiner;
import org.ballerinalang.jvm.types.BFunctionType;
import org.ballerinalang.jvm.types.BObjectType;
import org.ballerinalang.jvm.types.BType;

public class AttachedFunction
extends BFunctionType {
    public String funcName;
    public BFunctionType type;
    public int flags;
    public BObjectType parent;

    public AttachedFunction(String funcName, BObjectType parent, BFunctionType type, int flags) {
        this.funcName = funcName;
        this.type = type;
        this.parent = parent;
        this.flags = flags;
    }

    @Override
    public String toString() {
        StringJoiner sj = new StringJoiner(",", "function " + this.funcName + "(", ") returns (" + this.type.retType + ")");
        for (BType type : this.type.paramTypes) {
            sj.add(type.getName());
        }
        return sj.toString();
    }

    @Override
    public BType[] getParameterType() {
        return this.type.paramTypes;
    }

    @Override
    public String getName() {
        return this.funcName;
    }

    @Override
    public String getAnnotationKey() {
        return this.parent.getAnnotationKey() + "." + this.funcName;
    }
}

