/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.types;

import java.util.Map;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.types.BField;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BStructureType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.util.Flags;
import org.ballerinalang.jvm.values.MapValueImpl;

public class BRecordType
extends BStructureType {
    public boolean sealed;
    public BType restFieldType;

    public BRecordType(String typeName, BPackage pkg, int flags, boolean sealed) {
        super(typeName, pkg, flags, MapValueImpl.class);
        this.sealed = sealed;
    }

    public BRecordType(String typeName, BPackage pkg, int flags, Map<String, BField> fields, BType restFieldType, boolean sealed) {
        super(typeName, pkg, flags, MapValueImpl.class, fields);
        this.restFieldType = restFieldType;
        this.sealed = sealed;
    }

    @Override
    public <V> V getZeroValue() {
        return (V)BallerinaValues.createRecordValue(this.pkg, this.typeName);
    }

    @Override
    public <V> V getEmptyValue() {
        MapValueImpl implicitInitValue = new MapValueImpl(this);
        this.fields.entrySet().stream().filter(entry -> !Flags.isFlagOn(((BField)entry.getValue()).flags, 8192)).forEach(entry -> {
            Object value2 = ((BField)entry.getValue()).getFieldType().getEmptyValue();
            implicitInitValue.put(entry.getKey(), value2);
        });
        return (V)implicitInitValue;
    }

    @Override
    public int getTag() {
        return 12;
    }

    @Override
    public String getAnnotationKey() {
        return this.typeName;
    }
}

