/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.types;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.ballerinalang.jvm.types.BType;

public class BUnionType
extends BType {
    public static final char PIPE = '|';
    private List<BType> memberTypes;
    private Boolean nullable;
    private String cachedToString;

    public BUnionType() {
        super(null, null, Object.class);
    }

    public BUnionType(List<BType> memberTypes) {
        super(null, null, Object.class);
        this.memberTypes = memberTypes;
    }

    public BUnionType(BType[] memberTypes) {
        this(Arrays.asList(memberTypes));
    }

    public List<BType> getMemberTypes() {
        return this.memberTypes;
    }

    public boolean isNullable() {
        return this.isNilable();
    }

    @Override
    public <V> V getZeroValue() {
        if (this.isNilable() || this.memberTypes.stream().anyMatch(BType::isNilable)) {
            return null;
        }
        return this.memberTypes.get(0).getZeroValue();
    }

    @Override
    public <V> V getEmptyValue() {
        if (this.isNilable() || this.memberTypes.stream().anyMatch(BType::isNilable)) {
            return null;
        }
        return this.memberTypes.get(0).getEmptyValue();
    }

    @Override
    public int getTag() {
        return 21;
    }

    @Override
    public String toString() {
        if (this.cachedToString == null) {
            StringBuilder sb = new StringBuilder();
            int size = this.memberTypes.size();
            int i = 0;
            while (i < size) {
                sb.append(this.memberTypes.get(i).toString());
                if (++i >= size) continue;
                sb.append('|');
            }
            this.cachedToString = sb.toString();
        }
        return this.cachedToString;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BUnionType)) {
            return false;
        }
        BUnionType that = (BUnionType)o;
        return this.memberTypes.containsAll(that.memberTypes) && that.memberTypes.containsAll(this.memberTypes);
    }

    @Override
    public String getName() {
        return this.toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.memberTypes);
    }

    @Override
    public boolean isNilable() {
        if (this.nullable == null) {
            this.nullable = this.checkNillable(this.memberTypes);
        }
        return this.nullable;
    }

    private boolean checkNillable(List<BType> memberTypes) {
        for (BType t : memberTypes) {
            if (!t.isNilable()) continue;
            return true;
        }
        return false;
    }
}

