/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.JSONParser;
import org.ballerinalang.jvm.JSONUtils;
import org.ballerinalang.jvm.XMLFactory;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BMapType;
import org.ballerinalang.jvm.types.BStructureType;
import org.ballerinalang.jvm.types.BTupleType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.types.BUnionType;
import org.ballerinalang.jvm.util.RuntimeUtils;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.DecimalValue;
import org.ballerinalang.jvm.values.ErrorValue;

public class ArgumentParser {
    private static final String DEFAULT_PARAM_PREFIX = "-";
    private static final String NAMED_ARG_DELIMITER = "=";
    private static final String INVALID_ARG = "invalid argument: ";
    private static final String INVALID_ARG_AS_REST_ARG = "invalid argument as rest argument: ";
    private static final String UNSUPPORTED_TYPE_PREFIX = "unsupported type expected with entry function";
    private static final String JSON_PARSER_ERROR = "at line: ";
    private static final String COMMA = ",";
    private static final String NIL = "()";
    private static final String TRUE = "TRUE";
    private static final String FALSE = "FALSE";
    private static final String HEX_PREFIX = "0X";

    public static Object[] extractEntryFuncArgs(RuntimeUtils.ParamInfo[] funcInfo, String[] args, boolean hasRestParam) {
        Object[] bValueArgs = null;
        try {
            bValueArgs = ArgumentParser.getEntryFuncArgs(funcInfo, args, hasRestParam);
        }
        catch (ErrorValue e) {
            RuntimeUtils.handleUsageError(e.getReason());
        }
        return bValueArgs;
    }

    private static Object[] getEntryFuncArgs(RuntimeUtils.ParamInfo[] funcInfo, String[] args, boolean hasRestParam) {
        int i;
        Object[] bValueArgs = new Object[funcInfo.length * 2 + 1];
        HashMap<String, RuntimeUtils.ParamInfo> namedArgs = new HashMap<String, RuntimeUtils.ParamInfo>();
        boolean isNamedArgFound = false;
        int defaultableCount = 0;
        for (int i2 = 0; i2 < funcInfo.length; ++i2) {
            RuntimeUtils.ParamInfo info = funcInfo[i2];
            info.index = i2;
            namedArgs.put(info.name, info);
            if (!info.hasDefaultable) continue;
            ++defaultableCount;
        }
        int argsCountExceptRestArgs = hasRestParam ? funcInfo.length - 1 : funcInfo.length;
        int requiredParamsCount = hasRestParam ? argsCountExceptRestArgs - defaultableCount : argsCountExceptRestArgs - defaultableCount;
        ArrayList<String> restArgs = new ArrayList<String>();
        int providedRequiredArgsCount = 0;
        for (i = 0; i < args.length; ++i) {
            RuntimeUtils.ParamInfo info;
            String arg = args[i];
            boolean isNameArg = ArgumentParser.isNameArg(arg);
            if (isNameArg) {
                isNamedArgFound = true;
                info = (RuntimeUtils.ParamInfo)namedArgs.get(ArgumentParser.getParamName(arg));
                bValueArgs[info.index * 2 + 1] = ArgumentParser.getBValue(info.type, ArgumentParser.getValueString(arg));
                bValueArgs[info.index * 2 + 2] = true;
                if (info.hasDefaultable) continue;
                ++providedRequiredArgsCount;
                continue;
            }
            if (isNamedArgFound) {
                throw BallerinaErrors.createError("positional argument not allowed after named arguments when calling the 'main' function");
            }
            if (i < argsCountExceptRestArgs) {
                info = funcInfo[i];
                bValueArgs[2 * i + 1] = ArgumentParser.getBValue(info.type, arg);
                bValueArgs[2 * i + 2] = true;
                if (info.hasDefaultable) continue;
                ++providedRequiredArgsCount;
                continue;
            }
            restArgs.add(arg);
        }
        if (providedRequiredArgsCount < requiredParamsCount) {
            throw BallerinaErrors.createError("insufficient arguments to call the 'main' function");
        }
        if (!hasRestParam && !restArgs.isEmpty()) {
            throw BallerinaErrors.createError("too many arguments to call the 'main' function");
        }
        if (hasRestParam) {
            bValueArgs[funcInfo.length * 2 - 1] = ArgumentParser.getRestArgArray(funcInfo[funcInfo.length - 1].type, restArgs);
            bValueArgs[funcInfo.length * 2] = true;
        }
        for (i = requiredParamsCount; i < argsCountExceptRestArgs; ++i) {
            int defaultableArgIndex = i * 2 + 1;
            if (bValueArgs[defaultableArgIndex + 1] != null) continue;
            bValueArgs[defaultableArgIndex + 1] = false;
            bValueArgs[defaultableArgIndex] = ArgumentParser.getDefaultBValue(funcInfo[i].type);
        }
        return bValueArgs;
    }

    private static boolean isNameArg(String arg) {
        return arg.startsWith(DEFAULT_PARAM_PREFIX) && arg.contains(NAMED_ARG_DELIMITER);
    }

    private static String getParamName(String arg) {
        return arg.split(NAMED_ARG_DELIMITER, 2)[0].substring(1).trim();
    }

    private static String getValueString(String arg) {
        return arg.split(NAMED_ARG_DELIMITER, 2)[1];
    }

    private static Object getBValue(BType type, String value2) {
        switch (type.getTag()) {
            case 5: 
            case 17: {
                return value2;
            }
            case 1: {
                return ArgumentParser.getIntegerValue(value2);
            }
            case 3: {
                return ArgumentParser.getFloatValue(value2);
            }
            case 4: {
                return ArgumentParser.getDecimalValue(value2);
            }
            case 6: {
                return ArgumentParser.getBooleanValue(value2);
            }
            case 2: {
                return ArgumentParser.getByteValue(value2);
            }
            case 8: {
                try {
                    return XMLFactory.parse(value2);
                }
                catch (RuntimeException e) {
                    throw BallerinaErrors.createError("invalid argument '" + value2 + "', expected XML value");
                }
            }
            case 7: {
                try {
                    return JSONParser.parse(value2);
                }
                catch (BallerinaException e) {
                    throw BallerinaErrors.createError("invalid argument '" + value2 + "', expected JSON value");
                }
            }
            case 12: {
                try {
                    return JSONUtils.convertJSONToRecord(JSONParser.parse(value2), (BStructureType)type);
                }
                catch (BallerinaException e) {
                    throw BallerinaErrors.createError("invalid argument '" + value2 + "', error constructing record of type: " + type + ": " + e.getLocalizedMessage().split(JSON_PARSER_ERROR)[0]);
                }
            }
            case 31: {
                if (!value2.startsWith("[") || !value2.endsWith("]")) {
                    throw BallerinaErrors.createError("invalid argument '" + value2 + "', expected tuple notation [\"[]\"] with tuple arg");
                }
                return ArgumentParser.parseTupleArg((BTupleType)type, value2.substring(1, value2.length() - 1));
            }
            case 20: {
                try {
                    return JSONUtils.convertJSONToBArray(JSONParser.parse(value2), (BArrayType)type);
                }
                catch (BallerinaException | ErrorValue e) {
                    throw BallerinaErrors.createError("invalid argument '" + value2 + "', expected array elements of type: " + ((BArrayType)type).getElementType());
                }
            }
            case 15: {
                try {
                    return JSONUtils.jsonToMap(JSONParser.parse(value2), (BMapType)type);
                }
                catch (BallerinaException | ErrorValue e) {
                    throw BallerinaErrors.createError("invalid argument '" + value2 + "', expected map argument of element type: " + ((BMapType)type).getConstrainedType());
                }
            }
            case 21: {
                return ArgumentParser.parseUnionArg((BUnionType)type, value2);
            }
        }
        throw BallerinaErrors.createError("unsupported type expected with entry function '" + type + "'");
    }

    private static Object getDefaultBValue(BType type) {
        switch (type.getTag()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return 0;
            }
            case 6: {
                return false;
            }
        }
        return null;
    }

    private static long getIntegerValue(String argument) {
        try {
            if (argument.toUpperCase().startsWith(HEX_PREFIX)) {
                return Long.parseLong(argument.toUpperCase().replace(HEX_PREFIX, ""), 16);
            }
            return Long.parseLong(argument);
        }
        catch (NumberFormatException e) {
            throw BallerinaErrors.createError("invalid argument '" + argument + "', expected integer value");
        }
    }

    private static double getFloatValue(String argument) {
        try {
            return Double.parseDouble(argument);
        }
        catch (NumberFormatException e) {
            throw BallerinaErrors.createError("invalid argument '" + argument + "', expected float value");
        }
    }

    private static DecimalValue getDecimalValue(String argument) {
        try {
            return new DecimalValue(argument);
        }
        catch (NumberFormatException e) {
            throw BallerinaErrors.createError("invalid argument '" + argument + "', expected decimal value");
        }
    }

    private static boolean getBooleanValue(String argument) {
        if (!TRUE.equalsIgnoreCase(argument) && !FALSE.equalsIgnoreCase(argument)) {
            throw BallerinaErrors.createError("invalid argument '" + argument + "', expected boolean value 'true' or 'false'");
        }
        return Boolean.parseBoolean(argument);
    }

    private static int getByteValue(String argument) {
        int byteValue;
        try {
            byteValue = Integer.parseInt(argument);
        }
        catch (NumberFormatException e) {
            throw BallerinaErrors.createError("invalid argument '" + argument + "', expected byte value");
        }
        if (!RuntimeUtils.isByteLiteral(byteValue)) {
            throw BallerinaErrors.createError("invalid argument '" + argument + "', expected byte value, found int");
        }
        return byteValue;
    }

    private static ArrayValue getRestArgArray(BType type, List<String> args) {
        BType elementType = ((BArrayType)type).getElementType();
        try {
            switch (elementType.getTag()) {
                case 5: 
                case 17: {
                    ArrayValue stringArrayArgs = new ArrayValue(BTypes.typeString);
                    for (int i = 0; i < args.size(); ++i) {
                        stringArrayArgs.add((long)i, args.get(i));
                    }
                    return stringArrayArgs;
                }
                case 1: {
                    ArrayValue intArrayArgs = new ArrayValue(BTypes.typeInt);
                    for (int i = 0; i < args.size(); ++i) {
                        intArrayArgs.add((long)i, ArgumentParser.getIntegerValue(args.get(i)));
                    }
                    return intArrayArgs;
                }
                case 3: {
                    ArrayValue floatArrayArgs = new ArrayValue(BTypes.typeFloat);
                    for (int i = 0; i < args.size(); ++i) {
                        floatArrayArgs.add((long)i, ArgumentParser.getFloatValue(args.get(i)));
                    }
                    return floatArrayArgs;
                }
                case 6: {
                    ArrayValue booleanArrayArgs = new ArrayValue(BTypes.typeBoolean);
                    for (int i = 0; i < args.size(); ++i) {
                        booleanArrayArgs.add((long)i, ArgumentParser.getBooleanValue(args.get(i)) ? 1L : 0L);
                    }
                    return booleanArrayArgs;
                }
                case 2: {
                    ArrayValue byteArrayArgs = new ArrayValue(BTypes.typeByte);
                    for (int i = 0; i < args.size(); ++i) {
                        byteArrayArgs.add((long)i, (byte)ArgumentParser.getByteValue(args.get(i)));
                    }
                    return byteArrayArgs;
                }
            }
            ArrayValue refValueArray = new ArrayValue();
            for (int i = 0; i < args.size(); ++i) {
                refValueArray.add((long)i, ArgumentParser.getBValue(elementType, args.get(i)));
            }
            return refValueArray;
        }
        catch (BallerinaException e) {
            throw BallerinaErrors.createError(e.getLocalizedMessage().replace(INVALID_ARG, INVALID_ARG_AS_REST_ARG));
        }
        catch (Exception e) {
            throw BallerinaErrors.createError("error parsing rest arg: " + e.getLocalizedMessage());
        }
    }

    private static ArrayValue parseTupleArg(BTupleType type, String tupleArg) {
        String stringSpecificationErrorSuffix = "', expected argument in the format \\\"str\\\" for tuple element of type 'string'";
        String[] tupleElements = tupleArg.split(COMMA);
        if (tupleElements.length != type.getTupleTypes().size()) {
            throw BallerinaErrors.createError("invalid argument '[" + tupleArg + "]', element count mismatch for tuple type: '" + type + "'");
        }
        ArrayValue tupleValues = new ArrayValue(type);
        int index = 0;
        for (BType elementType : type.getTupleTypes()) {
            String tupleElement = tupleElements[index].trim();
            try {
                if (elementType.getTag() == 5) {
                    if (!tupleElement.startsWith("\"") || !tupleElement.endsWith("\"")) {
                        throw BallerinaErrors.createError("invalid tuple element argument '" + tupleElement + stringSpecificationErrorSuffix);
                    }
                    tupleElement = tupleElement.substring(1, tupleElement.length() - 1);
                }
                tupleValues.add((long)index, ArgumentParser.getBValue(elementType, tupleElement));
                ++index;
            }
            catch (BallerinaException | ErrorValue e) {
                String localizedMessage = e.getLocalizedMessage();
                if (localizedMessage.startsWith(UNSUPPORTED_TYPE_PREFIX)) {
                    throw BallerinaErrors.createError("unsupported element type for tuple as entry function argument: " + elementType);
                }
                if (!localizedMessage.endsWith(stringSpecificationErrorSuffix)) {
                    throw BallerinaErrors.createError("invalid tuple member argument '" + tupleElement + "', expected value of type '" + elementType + "'");
                }
                throw e;
            }
        }
        return tupleValues;
    }

    private static Object parseUnionArg(BUnionType type, String unionArg) {
        List<BType> unionMemberTypes = type.getMemberTypes();
        if (unionMemberTypes.contains(BTypes.typeNull) && NIL.equals(unionArg)) {
            return null;
        }
        if (unionMemberTypes.contains(BTypes.typeString)) {
            return unionArg;
        }
        int memberTypeIndex = 0;
        while (memberTypeIndex < unionMemberTypes.size()) {
            try {
                BType memberType = unionMemberTypes.get(memberTypeIndex);
                if (memberType.getTag() == 10) {
                    ++memberTypeIndex;
                    continue;
                }
                return ArgumentParser.getBValue(memberType, unionArg);
            }
            catch (ErrorValue e) {
                ++memberTypeIndex;
            }
        }
        throw BallerinaErrors.createError("invalid argument '" + unionArg + "' specified for union type: " + (type.isNilable() ? type.toString().replace("|null", "|()") : type));
    }
}

