/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values;

import java.util.Map;
import java.util.StringJoiner;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.transactions.TransactionLocalContext;
import org.ballerinalang.jvm.types.BFutureType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.RefValue;
import org.ballerinalang.jvm.values.connector.CallableUnitCallback;

public class FutureValue
implements RefValue {
    public Strand strand;
    public Object result;
    public boolean isDone;
    public Throwable panic;
    public CallableUnitCallback callback;
    public TransactionLocalContext transactionLocalContext;
    BType type;

    public FutureValue(Strand strand, CallableUnitCallback callback, BType constraint) {
        this.strand = strand;
        this.callback = callback;
        this.type = new BFutureType(constraint);
    }

    @Override
    public String stringValue(Strand strand) {
        StringJoiner sj = new StringJoiner(",", "{", "}");
        sj.add("isDone:" + this.isDone);
        if (this.isDone) {
            sj.add("result:" + this.result.toString());
        }
        if (this.panic != null) {
            sj.add("panic:" + this.panic.getLocalizedMessage());
        }
        return "future " + sj.toString();
    }

    @Override
    public BType getType() {
        return this.type;
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        throw new UnsupportedOperationException();
    }

    public void cancel() {
        this.strand.cancel = true;
    }
}

