/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.ballerinalang.jvm.commons.TypeValuePair;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.util.exceptions.BLangFreezeException;
import org.ballerinalang.jvm.util.exceptions.BLangRuntimeException;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.freeze.State;
import org.ballerinalang.jvm.values.freeze.Status;
import org.ballerinalang.jvm.values.utils.StringUtils;

public interface RefValue {
    default public String stringValue() {
        return this.stringValue(null);
    }

    default public String stringValue(Strand strand) {
        throw new BallerinaException("'stringValue(Strand strand)' not allowed on '" + this.getType() + "'");
    }

    public BType getType();

    default public void stamp(BType type, List<TypeValuePair> unresolvedValues) {
        throw new BLangRuntimeException("'constructFrom()' not allowed on '" + this.getType() + "'");
    }

    public Object copy(Map<Object, Object> var1);

    public Object frozenCopy(Map<Object, Object> var1);

    default public int size() {
        return -1;
    }

    default public boolean isFrozen() {
        return false;
    }

    default public void attemptFreeze(Status freezeStatus) {
        throw new BLangFreezeException("'freeze()' not allowed on '" + this.getType() + "'");
    }

    default public void freezeDirect() {
        throw new BLangFreezeException("'freezeDirect()' not allowed on '" + this.getType() + "'");
    }

    default public Object freeze() {
        Status freezeStatus = new Status(State.MID_FREEZE);
        try {
            this.attemptFreeze(freezeStatus);
            freezeStatus.setFrozen();
            return this;
        }
        catch (BLangFreezeException e) {
            freezeStatus.setUnfrozen();
            return null;
        }
        catch (BallerinaException e) {
            freezeStatus.setUnfrozen();
            throw e;
        }
    }

    default public void serialize(OutputStream outputStream2) {
        try {
            outputStream2.write(StringUtils.getJsonString(this).getBytes(Charset.defaultCharset()));
        }
        catch (IOException e) {
            throw new BallerinaException("error occurred while serializing data", e);
        }
    }
}

