/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values;

import java.util.Map;
import java.util.UUID;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.streams.StreamSubscriptionManager;
import org.ballerinalang.jvm.types.BStreamType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.FPValue;
import org.ballerinalang.jvm.values.RefValue;

public class StreamValue
implements RefValue {
    private BType type;
    private BType constraintType;
    private StreamSubscriptionManager streamSubscriptionManager = StreamSubscriptionManager.getInstance();
    public String streamId;

    public StreamValue(BType type) {
        this.constraintType = ((BStreamType)type).getConstrainedType();
        this.type = new BStreamType(this.constraintType);
        this.streamId = UUID.randomUUID().toString();
    }

    public String getStreamId() {
        return this.streamId;
    }

    @Override
    public String stringValue(Strand strand) {
        return "stream " + this.streamId + " " + this.getType().toString();
    }

    @Override
    public BType getType() {
        return this.type;
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        throw new UnsupportedOperationException();
    }

    public BType getConstraintType() {
        return this.constraintType;
    }

    public void publish(Strand strand, Object data) {
        this.streamSubscriptionManager.sendMessage(this, strand, data);
    }

    public void subscribe(FPValue<Object[], Object> functionPointer) {
        this.streamSubscriptionManager.registerMessageProcessor(this, functionPointer);
    }
}

