/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMDocType;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.impl.common.OMChildrenQNameIterator;
import org.apache.axiom.om.impl.common.OMNamespaceImpl;
import org.apache.axiom.om.impl.llom.OMElementImpl;
import org.apache.commons.lang3.StringEscapeUtils;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.XMLFactory;
import org.ballerinalang.jvm.XMLNodeType;
import org.ballerinalang.jvm.XMLValidator;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BMapType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.util.BLangConstants;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.IteratorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.XMLIterator;
import org.ballerinalang.jvm.values.XMLSequence;
import org.ballerinalang.jvm.values.XMLValue;
import org.ballerinalang.jvm.values.freeze.FreezeUtils;
import org.ballerinalang.jvm.values.freeze.State;
import org.ballerinalang.jvm.values.freeze.Status;

public final class XMLItem
extends XMLValue<OMNode> {
    OMNode omNode;
    private XMLNodeType nodeType;

    public XMLItem() {
        this.omNode = new OMElementImpl();
        this.setXMLNodeType();
    }

    public XMLItem(String xmlValue) {
        if (xmlValue == null) {
            return;
        }
        try {
            this.omNode = XMLFactory.stringToOM(xmlValue);
            this.setXMLNodeType();
        }
        catch (Throwable t) {
            XMLItem.handleXmlException("failed to create xml: ", t);
        }
    }

    public XMLItem(OMNode value2) {
        this.omNode = value2;
        this.setXMLNodeType();
    }

    public XMLItem(InputStream inputStream2) {
        if (inputStream2 == null) {
            return;
        }
        try {
            this.omNode = OMXMLBuilderFactory.createOMBuilder(XMLFactory.STAX_PARSER_CONFIGURATION, inputStream2).getDocumentElement();
            this.setXMLNodeType();
        }
        catch (Throwable t) {
            XMLItem.handleXmlException("failed to create xml: ", t);
        }
    }

    @Override
    public XMLNodeType getNodeType() {
        return this.nodeType;
    }

    @Override
    public boolean isEmpty() {
        return this.omNode == null;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public String getItemType() {
        return new String(this.nodeType.value());
    }

    @Override
    public String getElementName() {
        if (this.nodeType == XMLNodeType.ELEMENT) {
            return new String(((OMElement)this.omNode).getQName().toString());
        }
        return (String)BTypes.typeString.getEmptyValue();
    }

    @Override
    public String getTextValue() {
        switch (this.nodeType) {
            case ELEMENT: {
                StringBuilder elementTextBuilder = new StringBuilder();
                Iterator children = ((OMElement)this.omNode).getChildren();
                while (children.hasNext()) {
                    elementTextBuilder.append(this.getTextValue((OMNode)children.next()));
                }
                return elementTextBuilder.toString();
            }
            case TEXT: {
                String text = ((OMText)this.omNode).getText();
                return StringEscapeUtils.escapeXml11(text);
            }
            case COMMENT: {
                return (String)BTypes.typeString.getZeroValue();
            }
            case PI: {
                return (String)BTypes.typeString.getZeroValue();
            }
        }
        return (String)BTypes.typeString.getZeroValue();
    }

    @Override
    public String getAttribute(String localName, String namespace) {
        return this.getAttribute(localName, namespace, "");
    }

    @Override
    public String getAttribute(String localName, String namespace, String prefix) {
        if (this.nodeType != XMLNodeType.ELEMENT || localName == null || localName.isEmpty()) {
            return BLangConstants.STRING_NULL_VALUE;
        }
        QName attributeName = this.getQName(localName, namespace, prefix);
        OMAttribute attribute = ((OMElement)this.omNode).getAttribute(attributeName);
        if (attribute != null) {
            return attribute.getAttributeValue();
        }
        OMNamespace ns = ((OMElement)this.omNode).findNamespaceURI(localName);
        return ns == null ? BLangConstants.STRING_NULL_VALUE : ns.getNamespaceURI();
    }

    @Override
    public void setAttribute(String localName, String namespaceUri, String prefix, String value2) {
        if (this.nodeType != XMLNodeType.ELEMENT) {
            return;
        }
        if (localName == null || localName.isEmpty()) {
            throw BallerinaErrors.createError("localname of the attribute cannot be empty");
        }
        XMLValidator.validateXMLName(localName);
        XMLValidator.validateXMLName(prefix);
        OMElement node = (OMElement)this.omNode;
        QName qname = this.getQName(localName, namespaceUri, prefix);
        OMAttribute attr = node.getAttribute(qname);
        if (attr != null) {
            attr.setAttributeValue(value2);
            return;
        }
        if (prefix != null && prefix.equals("xmlns")) {
            node.declareNamespace(value2, localName);
            return;
        }
        this.createAttribute(localName, namespaceUri, prefix, value2, node);
    }

    @Override
    public MapValue<String, ?> getAttributesMap() {
        XMLAttributeMap attrMap = new XMLAttributeMap(this);
        return attrMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttributes(MapValue<String, ?> attributes) {
        XMLItem xMLItem = this;
        synchronized (xMLItem) {
            if (this.freezeStatus.getState() != State.UNFROZEN) {
                FreezeUtils.handleInvalidUpdate(this.freezeStatus.getState(), "lang.xml");
            }
        }
        if (this.nodeType != XMLNodeType.ELEMENT || attributes == null) {
            return;
        }
        OMElement omElement = (OMElement)this.omNode;
        Iterator attrIterator = omElement.getAllAttributes();
        while (attrIterator.hasNext()) {
            omElement.removeAttribute((OMAttribute)attrIterator.next());
        }
        Iterator namespaceIterator = omElement.getAllDeclaredNamespaces();
        while (namespaceIterator.hasNext()) {
            namespaceIterator.next();
            namespaceIterator.remove();
        }
        for (String qname : attributes.getKeys()) {
            String uri;
            String localName;
            if (qname.startsWith("{") && qname.indexOf(125) > 0) {
                localName = qname.substring(qname.indexOf(125) + 1, qname.length());
                uri = qname.substring(1, qname.indexOf(125));
            } else {
                localName = qname;
                uri = BLangConstants.STRING_NULL_VALUE;
            }
            XMLValidator.validateXMLName(localName);
            this.setAttribute(localName, uri, BLangConstants.STRING_NULL_VALUE, attributes.get(qname).toString());
        }
    }

    @Override
    public XMLValue<?> elements() {
        ArrayValue elementsSeq = new ArrayValue(new BArrayType(BTypes.typeXML));
        switch (this.nodeType) {
            case ELEMENT: {
                elementsSeq.add(0L, this);
                break;
            }
        }
        return new XMLSequence(elementsSeq);
    }

    @Override
    public XMLValue<?> elements(String qname) {
        ArrayValue elementsSeq = new ArrayValue(new BArrayType(BTypes.typeXML));
        switch (this.nodeType) {
            case ELEMENT: {
                if (!this.getElementName().toString().equals(this.getQname(qname).toString())) break;
                elementsSeq.add(0L, this);
                break;
            }
        }
        return new XMLSequence(elementsSeq);
    }

    @Override
    public XMLValue<?> children() {
        ArrayValue elementsSeq = new ArrayValue(new BArrayType(BTypes.typeXML));
        switch (this.nodeType) {
            case ELEMENT: {
                Iterator childrenItr = ((OMElement)this.omNode).getChildren();
                int i = 0;
                while (childrenItr.hasNext()) {
                    elementsSeq.add((long)i++, new XMLItem((OMNode)childrenItr.next()));
                }
                break;
            }
        }
        return new XMLSequence(elementsSeq);
    }

    @Override
    public XMLValue<?> children(String qname) {
        ArrayValue elementsSeq = new ArrayValue(new BArrayType(BTypes.typeXML));
        switch (this.nodeType) {
            case ELEMENT: {
                OMChildrenQNameIterator childrenItr = new OMChildrenQNameIterator(((OMElement)this.omNode).getFirstOMChild(), this.getQname(qname));
                int i = 0;
                while (childrenItr.hasNext()) {
                    OMNode node = (OMNode)childrenItr.next();
                    elementsSeq.add((long)i++, new XMLItem(node));
                }
                break;
            }
        }
        return new XMLSequence(elementsSeq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setChildren(XMLValue<?> seq) {
        OMElement currentNode;
        XMLItem xMLItem = this;
        synchronized (xMLItem) {
            if (this.freezeStatus.getState() != State.UNFROZEN) {
                FreezeUtils.handleInvalidUpdate(this.freezeStatus.getState(), "lang.xml");
            }
        }
        if (seq == null) {
            return;
        }
        switch (this.nodeType) {
            case ELEMENT: {
                currentNode = (OMElement)this.omNode;
                break;
            }
            default: {
                throw BallerinaErrors.createError("not an " + (Object)((Object)XMLNodeType.ELEMENT));
            }
        }
        currentNode.removeChildren();
        if (seq.getNodeType() == XMLNodeType.SEQUENCE) {
            ArrayValue childSeq = ((XMLSequence)seq).value();
            for (int i = 0; i < childSeq.size(); ++i) {
                XMLValue child = (XMLValue)childSeq.getRefValue(i);
                currentNode.addChild((OMNode)child.value());
            }
        } else {
            currentNode.addChild((OMNode)seq.value());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildren(XMLValue<?> seq) {
        OMElement currentNode;
        XMLItem xMLItem = this;
        synchronized (xMLItem) {
            if (this.freezeStatus.getState() != State.UNFROZEN) {
                FreezeUtils.handleInvalidUpdate(this.freezeStatus.getState(), "lang.xml");
            }
        }
        if (seq == null) {
            return;
        }
        switch (this.nodeType) {
            case ELEMENT: {
                currentNode = (OMElement)this.omNode;
                break;
            }
            default: {
                throw BallerinaErrors.createError("not an " + (Object)((Object)XMLNodeType.ELEMENT));
            }
        }
        if (seq.getNodeType() == XMLNodeType.SEQUENCE) {
            ArrayValue childSeq = ((XMLSequence)seq).value();
            for (int i = 0; i < childSeq.size(); ++i) {
                XMLValue child = (XMLValue)childSeq.getRefValue(i);
                currentNode.addChild((OMNode)child.value());
            }
        } else {
            currentNode.addChild((OMNode)seq.value());
        }
    }

    @Override
    public XMLValue<?> strip() {
        if (this.omNode == null || this.nodeType == XMLNodeType.TEXT && ((OMText)this.omNode).getText().trim().isEmpty()) {
            return new XMLSequence();
        }
        return this;
    }

    @Override
    public XMLValue<?> slice(long startIndex, long endIndex) {
        if (startIndex > 1L || endIndex > 1L || startIndex < -1L || endIndex < -1L) {
            throw BallerinaErrors.createError("index out of range: [" + startIndex + "," + endIndex + "]");
        }
        if (startIndex == -1L) {
            startIndex = 0L;
        }
        if (endIndex == -1L) {
            endIndex = 1L;
        }
        if (startIndex == endIndex) {
            return new XMLSequence();
        }
        if (startIndex > endIndex) {
            throw BallerinaErrors.createError("invalid indices: " + startIndex + " < " + endIndex);
        }
        return this;
    }

    @Override
    public XMLValue<?> descendants(String qname) {
        ArrayList descendants = new ArrayList();
        switch (this.nodeType) {
            case ELEMENT: {
                this.addDescendants(descendants, (OMElement)this.omNode, this.getQname(qname).toString());
                break;
            }
        }
        Object[] array2 = descendants.toArray(new XMLValue[descendants.size()]);
        return new XMLSequence(new ArrayValue(array2, new BArrayType(BTypes.typeXML)));
    }

    @Override
    public void serialize(OutputStream outputStream2) {
        try {
            if (this.omNode.getType() == 1) {
                this.omNode.serializeAndConsume(outputStream2);
            } else {
                XMLOutputFactory factory = XMLOutputFactory.newInstance();
                XMLStreamWriter writer = factory.createXMLStreamWriter(outputStream2);
                this.omNode.serializeAndConsume(writer);
            }
        }
        catch (Throwable t) {
            XMLItem.handleXmlException("error occurred during writing the message to the output stream: ", t);
        }
    }

    @Override
    public OMNode value() {
        return this.omNode;
    }

    public String toString() {
        return this.stringValue();
    }

    @Override
    public String stringValue(Strand strand) {
        try {
            switch (this.omNode.getType()) {
                case 4: 
                case 6: {
                    return ((OMText)this.omNode).getText();
                }
                case 5: {
                    return "<!--" + ((OMComment)this.omNode).getValue() + "-->";
                }
                case 3: {
                    return "<?" + ((OMProcessingInstruction)this.omNode).getTarget() + " " + ((OMProcessingInstruction)this.omNode).getValue() + "?>";
                }
                case 11: {
                    return ((OMDocType)this.omNode).getInternalSubset();
                }
            }
            return this.omNode.toString();
        }
        catch (Throwable t) {
            XMLItem.handleXmlException("failed to get xml as string: ", t);
            return BLangConstants.STRING_NULL_VALUE;
        }
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        if (this.isFrozen()) {
            return this;
        }
        switch (this.nodeType) {
            case ELEMENT: {
                return new XMLItem(((OMElement)this.omNode).cloneOMElement());
            }
            case TEXT: {
                return XMLFactory.createXMLText(((OMText)this.omNode).getText());
            }
            case COMMENT: {
                return XMLFactory.createXMLComment(((OMComment)this.omNode).getValue());
            }
            case PI: {
                return XMLFactory.createXMLProcessingInstruction(((OMProcessingInstruction)this.omNode).getTarget(), ((OMProcessingInstruction)this.omNode).getValue());
            }
        }
        return new XMLItem(this.omNode);
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        XMLItem copy = (XMLItem)this.copy(refs);
        if (!copy.isFrozen()) {
            copy.freezeDirect();
        }
        return copy;
    }

    @Override
    public XMLValue<?> getItem(int index) {
        if (index != 0) {
            throw BallerinaErrors.createError("index out of range: index: " + index + ", size: 1");
        }
        return this;
    }

    @Override
    public int size() {
        if (this.getNodeType() == XMLNodeType.TEXT) {
            String textContent = ((OMText)this.omNode).getText();
            return textContent.codePointCount(0, textContent.length());
        }
        return this.omNode == null ? 0 : 1;
    }

    public int length() {
        return this.omNode == null ? 0 : 1;
    }

    @Override
    public void build() {
        this.omNode.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAttribute(String qname) {
        XMLItem xMLItem = this;
        synchronized (xMLItem) {
            if (this.freezeStatus.getState() != State.UNFROZEN) {
                FreezeUtils.handleInvalidUpdate(this.freezeStatus.getState(), "lang.xml");
            }
        }
        if (this.nodeType != XMLNodeType.ELEMENT || qname.isEmpty()) {
            return;
        }
        OMElement omElement = (OMElement)this.omNode;
        OMAttribute attribute = omElement.getAttribute(this.getQname(qname));
        if (attribute == null) {
            return;
        }
        omElement.removeAttribute(attribute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChildren(String qname) {
        XMLItem xMLItem = this;
        synchronized (xMLItem) {
            if (this.freezeStatus.getState() != State.UNFROZEN) {
                FreezeUtils.handleInvalidUpdate(this.freezeStatus.getState(), "lang.xml");
            }
        }
        switch (this.nodeType) {
            case ELEMENT: {
                OMChildrenQNameIterator childrenItr = new OMChildrenQNameIterator(((OMElement)this.omNode).getFirstOMChild(), this.getQname(qname));
                while (childrenItr.hasNext()) {
                    childrenItr.next();
                    childrenItr.remove();
                }
                break;
            }
        }
    }

    @Override
    public synchronized void attemptFreeze(Status freezeStatus) {
        if (FreezeUtils.isOpenForFreeze(this.freezeStatus, freezeStatus)) {
            this.freezeStatus = freezeStatus;
        }
    }

    @Override
    public void freezeDirect() {
        this.freezeStatus.setFrozen();
    }

    private void setXMLNodeType() {
        switch (this.omNode.getType()) {
            case 1: {
                this.nodeType = XMLNodeType.ELEMENT;
                break;
            }
            case 4: 
            case 6: {
                this.nodeType = XMLNodeType.TEXT;
                break;
            }
            case 5: {
                this.nodeType = XMLNodeType.COMMENT;
                break;
            }
            case 3: {
                this.nodeType = XMLNodeType.PI;
                break;
            }
            default: {
                this.nodeType = XMLNodeType.SEQUENCE;
            }
        }
    }

    private String getTextValue(OMNode node) {
        switch (node.getType()) {
            case 1: {
                StringBuilder sb = new StringBuilder();
                Iterator children = ((OMElement)node).getChildren();
                while (children.hasNext()) {
                    sb.append(this.getTextValue((OMNode)children.next()));
                }
                return sb.toString();
            }
            case 4: {
                return ((OMText)node).getText();
            }
            case 5: {
                return BLangConstants.STRING_NULL_VALUE;
            }
            case 3: {
                return BLangConstants.STRING_NULL_VALUE;
            }
        }
        return BLangConstants.STRING_NULL_VALUE;
    }

    private QName getQName(String localName, String namespaceUri, String prefix) {
        QName qname = prefix != null ? new QName(namespaceUri, localName, prefix) : new QName(namespaceUri, localName);
        return qname;
    }

    private void createAttribute(String localName, String namespaceUri, String prefix, String value2, OMElement node) {
        if (namespaceUri == null || namespaceUri.isEmpty()) {
            node.addAttribute(localName, value2, null);
            return;
        }
        if (prefix != null && !prefix.isEmpty()) {
            OMNamespace existingNs = node.findNamespaceURI(prefix);
            if (existingNs != null && !namespaceUri.equals(existingNs.getNamespaceURI())) {
                throw BallerinaErrors.createError("failed to add attribute '" + prefix + ":" + localName + "'. prefix '" + prefix + "' is already bound to namespace '" + existingNs.getNamespaceURI() + "'");
            }
            node.addAttribute(localName, value2, new OMNamespaceImpl(namespaceUri, prefix));
            return;
        }
        Iterator<String> prefixes = node.getNamespaceContext(false).getPrefixes(namespaceUri);
        if (prefixes.hasNext()) {
            prefix = prefixes.next();
            if (prefix.isEmpty()) {
                node.addAttribute(localName, value2, null);
                return;
            }
            if (prefix.equals("xmlns")) {
                node.declareNamespace(value2, localName);
                return;
            }
        }
        node.addAttribute(localName, value2, new OMNamespaceImpl(namespaceUri, prefix));
    }

    @Override
    public IteratorValue getIterator() {
        return new XMLIterator.ItemIterator(this);
    }

    private static class XMLAttributeMap
    extends MapValueImpl<String, String> {
        private final XMLItem bXmlItem;

        XMLAttributeMap(XMLItem bXmlItem) {
            super(new BMapType(BTypes.typeString));
            this.bXmlItem = bXmlItem;
        }

        @Override
        public String put(String key, String value2) {
            int startBrace;
            String url = null;
            String localName = key;
            int endOfUrl = key.lastIndexOf(125);
            if (endOfUrl != -1 && (startBrace = key.indexOf(123)) == 0) {
                url = key.substring(startBrace + 1, endOfUrl);
                localName = key.substring(endOfUrl + 1);
            }
            this.bXmlItem.setAttribute(localName, url, null, value2);
            return null;
        }

        @Override
        public String get(Object key) {
            int startBrace;
            String name = (String)key;
            String namespace = null;
            String localName = name;
            int endOfUrl = name.lastIndexOf(125);
            if (endOfUrl != -1 && (startBrace = name.indexOf(123)) == 0) {
                namespace = name.substring(startBrace + 1, endOfUrl);
                localName = name.substring(endOfUrl + 1);
            }
            return this.bXmlItem.getAttribute(localName, namespace);
        }

        @Override
        public Object copy(Map<Object, Object> refs) {
            MapValueImpl<String, String> attrMap = new MapValueImpl<String, String>(new BMapType(BTypes.typeString));
            if (this.bXmlItem.nodeType != XMLNodeType.ELEMENT) {
                return attrMap;
            }
            String namespaceOfPrefix = this.getNamespaceOfPrefix();
            Iterator namespaceIterator = ((OMElement)this.bXmlItem.omNode).getAllDeclaredNamespaces();
            while (namespaceIterator.hasNext()) {
                OMNamespace namespace = (OMNamespace)namespaceIterator.next();
                String prefix = namespace.getPrefix();
                if (prefix.isEmpty()) continue;
                attrMap.put(namespaceOfPrefix + prefix, namespace.getNamespaceURI());
            }
            Iterator attrIterator = ((OMElement)this.bXmlItem.omNode).getAllAttributes();
            while (attrIterator.hasNext()) {
                OMAttribute attr = (OMAttribute)attrIterator.next();
                attrMap.put(attr.getQName().toString(), attr.getAttributeValue());
            }
            return attrMap;
        }

        @Override
        public String stringValue() {
            StringJoiner sj = new StringJoiner(" ");
            if (this.bXmlItem.nodeType != XMLNodeType.ELEMENT) {
                return "{}";
            }
            String namespaceOfPrefix = this.getNamespaceOfPrefix();
            Iterator namespaceIterator = ((OMElement)this.bXmlItem.omNode).getAllDeclaredNamespaces();
            while (namespaceIterator.hasNext()) {
                OMNamespace namespace = (OMNamespace)namespaceIterator.next();
                String prefix = namespace.getPrefix();
                if (prefix.isEmpty()) continue;
                sj.add(namespaceOfPrefix + prefix + "=" + namespace.getNamespaceURI());
            }
            Iterator attrIterator = ((OMElement)this.bXmlItem.omNode).getAllAttributes();
            while (attrIterator.hasNext()) {
                OMAttribute attr = (OMAttribute)attrIterator.next();
                sj.add(attr.getQName().toString() + "=" + attr.getAttributeValue());
            }
            return sj.toString();
        }

        @Override
        public Set<String> keySet() {
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            if (this.bXmlItem.nodeType != XMLNodeType.ELEMENT) {
                return keys;
            }
            String namespaceOfPrefix = this.getNamespaceOfPrefix();
            Iterator namespaceIterator = ((OMElement)this.bXmlItem.omNode).getAllDeclaredNamespaces();
            while (namespaceIterator.hasNext()) {
                OMNamespace namespace = (OMNamespace)namespaceIterator.next();
                String prefix = namespace.getPrefix();
                if (prefix.isEmpty()) continue;
                keys.add(namespaceOfPrefix + prefix);
            }
            Iterator attrIterator = ((OMElement)this.bXmlItem.omNode).getAllAttributes();
            while (attrIterator.hasNext()) {
                OMAttribute attr = (OMAttribute)attrIterator.next();
                keys.add(attr.getQName().toString());
            }
            return keys;
        }

        public String[] getKeys() {
            Set<String> keys = this.keySet();
            return keys.toArray(new String[keys.size()]);
        }

        @Override
        public int size() {
            int size = 0;
            Iterator namespaceIterator = ((OMElement)this.bXmlItem.omNode).getAllDeclaredNamespaces();
            Iterator attrIterator = ((OMElement)this.bXmlItem.omNode).getAllAttributes();
            while (namespaceIterator.hasNext()) {
                if (((OMNamespace)namespaceIterator.next()).getPrefix().isEmpty()) continue;
                ++size;
            }
            while (attrIterator.hasNext()) {
                attrIterator.next();
                ++size;
            }
            return size;
        }

        @Override
        public String getOrThrow(Object key) {
            String value2 = this.get(key);
            if (value2 == null) {
                throw BallerinaErrors.createError(BallerinaErrorReasons.getModulePrefixedReason("lang.xml", "KeyNotFound"), "cannot find key '" + key + "'");
            }
            return value2;
        }

        @Override
        public String fillAndGet(Object key) {
            String value2 = this.get(key);
            if (value2 == null) {
                value2 = (String)BTypes.typeString.getZeroValue();
                this.put((String)key, value2);
            }
            return value2;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.get(key) == null;
        }

        @Override
        public Collection<String> values() {
            ArrayList<String> values = new ArrayList<String>();
            if (this.bXmlItem.nodeType != XMLNodeType.ELEMENT) {
                return values;
            }
            Iterator namespaceIterator = ((OMElement)this.bXmlItem.omNode).getAllDeclaredNamespaces();
            while (namespaceIterator.hasNext()) {
                OMNamespace namespace = (OMNamespace)namespaceIterator.next();
                String prefix = namespace.getPrefix();
                if (prefix.isEmpty()) continue;
                values.add(namespace.getNamespaceURI());
            }
            Iterator attrIterator = ((OMElement)this.bXmlItem.omNode).getAllAttributes();
            while (attrIterator.hasNext()) {
                OMAttribute attr = (OMAttribute)attrIterator.next();
                values.add(attr.getAttributeValue());
            }
            return values;
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public String toString() {
            return this.stringValue();
        }

        @Override
        public String remove(Object key) {
            String attr = this.get(key);
            this.bXmlItem.removeAttribute((String)key);
            return attr;
        }

        @Override
        public Object frozenCopy(Map<Object, Object> refs) {
            XMLAttributeMap copy = new XMLAttributeMap((XMLItem)this.bXmlItem.copy(refs));
            if (!copy.isFrozen()) {
                copy.freezeDirect();
            }
            return copy;
        }

        @Override
        public String stringValue(Strand strand) {
            return this.stringValue();
        }

        @Override
        public synchronized void attemptFreeze(Status freezeStatus) {
            this.bXmlItem.attemptFreeze(freezeStatus);
        }

        @Override
        public void freezeDirect() {
            this.bXmlItem.freezeDirect();
        }

        @Override
        public synchronized boolean isFrozen() {
            return this.bXmlItem.isFrozen();
        }

        private String getNamespaceOfPrefix() {
            OMNamespace defaultNs = ((OMElement)this.bXmlItem.omNode).getDefaultNamespace();
            String namespaceOfPrefix = '{' + (defaultNs == null ? "http://www.w3.org/2000/xmlns/" : defaultNs.getNamespaceURI()) + '}';
            return namespaceOfPrefix;
        }
    }
}

