/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values;

import org.apache.axiom.om.OMText;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.XMLNodeType;
import org.ballerinalang.jvm.values.IteratorValue;
import org.ballerinalang.jvm.values.XMLItem;
import org.ballerinalang.jvm.values.XMLSequence;

public class XMLIterator {

    public static class CodePointIterator
    implements IteratorValue {
        private String charSequence;
        private int offset;

        public CodePointIterator(String charSequence) {
            this.charSequence = charSequence;
            this.offset = 0;
        }

        static CodePointIterator from(String seq) {
            return new CodePointIterator(seq);
        }

        public Object next() {
            int codePoint = this.charSequence.codePointAt(this.offset);
            this.offset += Character.charCount(codePoint);
            StringBuilder sb = new StringBuilder(2);
            sb.appendCodePoint(codePoint);
            return sb.toString();
        }

        @Override
        public boolean hasNext() {
            return this.offset < this.charSequence.length();
        }
    }

    static class SequenceIterator
    implements IteratorValue {
        XMLSequence value;
        int cursor = 0;
        IterMode iterMode = IterMode.SEQUENCE;
        CodePointIterator codePointIterator;

        SequenceIterator(XMLSequence bxmlSequence) {
            this.value = bxmlSequence;
        }

        public Object next() {
            Object curVal;
            if (this.iterMode == IterMode.CODE_POINT) {
                if (this.codePointIterator.hasNext()) {
                    return this.codePointIterator.next();
                }
                this.iterMode = IterMode.SEQUENCE;
                this.codePointIterator = null;
            }
            if (TypeChecker.getType(curVal = this.value.sequence.getRefValue(this.cursor++)).getTag() == 8 && ((XMLItem)curVal).getNodeType() == XMLNodeType.TEXT) {
                this.iterMode = IterMode.CODE_POINT;
                this.codePointIterator = CodePointIterator.from(curVal.toString());
                return this.codePointIterator.next();
            }
            return curVal;
        }

        @Override
        public boolean hasNext() {
            boolean hasMoreXmlItems;
            boolean bl = hasMoreXmlItems = this.cursor < this.value.sequence.size();
            return this.iterMode == IterMode.SEQUENCE ? hasMoreXmlItems : this.codePointIterator.hasNext() || hasMoreXmlItems;
        }
    }

    static class ItemIterator
    implements IteratorValue {
        XMLItem value;
        int cursor = 0;
        CodePointIterator codePointIterator;

        ItemIterator(XMLItem bxmlItem) {
            this.value = bxmlItem;
        }

        public Object next() {
            if (this.value.getNodeType() == XMLNodeType.TEXT) {
                if (this.codePointIterator == null) {
                    this.codePointIterator = this.createCodePointIterator(this.value);
                }
                ++this.cursor;
                return this.codePointIterator.next();
            }
            if (this.hasNext()) {
                ++this.cursor;
                return this.value;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            if (this.value.getNodeType() == XMLNodeType.TEXT) {
                if (this.codePointIterator == null) {
                    this.codePointIterator = this.createCodePointIterator(this.value);
                }
                return this.codePointIterator.hasNext();
            }
            return this.cursor == 0;
        }

        private CodePointIterator createCodePointIterator(XMLItem value2) {
            return new CodePointIterator(((OMText)value2.omNode).getText());
        }
    }

    static enum IterMode {
        SEQUENCE,
        CODE_POINT;

    }
}

