/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values;

import java.util.Map;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.RefValue;

public final class XMLQName
implements RefValue {
    private String localName;
    private String uri;
    private String prefix;

    public XMLQName(String localName, String uri, String prefix) {
        this.localName = localName;
        this.uri = uri;
        this.prefix = prefix;
    }

    public XMLQName(String qNameStr) {
        int parenEndIndex = qNameStr.indexOf(125);
        if (qNameStr.startsWith("{") && parenEndIndex > 0) {
            this.localName = qNameStr.substring(parenEndIndex + 1, qNameStr.length());
            this.uri = qNameStr.substring(1, parenEndIndex);
        } else {
            this.localName = qNameStr;
            this.uri = null;
        }
    }

    public String toString() {
        return this.uri == null || this.uri.isEmpty() ? this.localName : '{' + this.uri + '}' + this.localName;
    }

    @Override
    public String stringValue(Strand strand) {
        return this.uri == null || this.uri.isEmpty() ? this.localName : '{' + this.uri + '}' + this.localName;
    }

    @Override
    public BType getType() {
        return BTypes.typeXMLAttributes;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof XMLQName)) {
            return false;
        }
        return ((XMLQName)obj).toString().equals(this.localName);
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        if (this.isFrozen()) {
            return this;
        }
        return new XMLQName(this.localName, this.uri, this.prefix);
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        XMLQName copy = (XMLQName)this.copy(refs);
        if (!copy.isFrozen()) {
            copy.freezeDirect();
        }
        return copy;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

