/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.XMLNodeType;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.util.BLangConstants;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.IteratorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.RefValue;
import org.ballerinalang.jvm.values.XMLItem;
import org.ballerinalang.jvm.values.XMLIterator;
import org.ballerinalang.jvm.values.XMLValue;
import org.ballerinalang.jvm.values.freeze.FreezeUtils;
import org.ballerinalang.jvm.values.freeze.State;
import org.ballerinalang.jvm.values.freeze.Status;

public final class XMLSequence
extends XMLValue<ArrayValue> {
    ArrayValue sequence;

    public XMLSequence() {
        this.sequence = new ArrayValue(new BArrayType(BTypes.typeXML), 0L);
    }

    public XMLSequence(ArrayValue sequence) {
        this.sequence = sequence;
    }

    @Override
    public XMLNodeType getNodeType() {
        return XMLNodeType.SEQUENCE;
    }

    @Override
    public boolean isEmpty() {
        return this.sequence.size() == 0;
    }

    @Override
    public boolean isSingleton() {
        return this.sequence.size() == 1;
    }

    @Override
    public String getItemType() {
        if (this.sequence.size() == 1) {
            return ((XMLItem)this.sequence.getRefValue(0L)).getItemType();
        }
        return XMLNodeType.SEQUENCE.value();
    }

    @Override
    public String getElementName() {
        if (this.sequence.size() == 1) {
            return ((XMLItem)this.sequence.getRefValue(0L)).getElementName();
        }
        return "";
    }

    @Override
    public String getTextValue() {
        StringBuilder seqTextBuilder = new StringBuilder();
        for (int i = 0; i < this.sequence.size(); ++i) {
            XMLItem item = (XMLItem)this.sequence.getRefValue(i);
            seqTextBuilder.append(item.getTextValue().toString());
        }
        return seqTextBuilder.toString();
    }

    @Override
    public String getAttribute(String localName, String namespace) {
        if (this.sequence.size() == 1) {
            return ((XMLItem)this.sequence.getRefValue(0L)).getAttribute(localName, namespace);
        }
        return BLangConstants.STRING_NULL_VALUE;
    }

    @Override
    public String getAttribute(String localName, String namespace, String prefix) {
        if (this.sequence.size() == 1) {
            return ((XMLItem)this.sequence.getRefValue(0L)).getAttribute(localName, namespace, prefix);
        }
        return BLangConstants.STRING_NULL_VALUE;
    }

    @Override
    public void setAttribute(String localName, String namespace, String prefix, String value2) {
        if (this.sequence.size() == 1) {
            ((XMLItem)this.sequence.getRefValue(0L)).setAttribute(localName, namespace, prefix, value2);
        }
    }

    @Override
    public MapValue<String, ?> getAttributesMap() {
        if (this.sequence.size() == 1) {
            return ((XMLItem)this.sequence.getRefValue(0L)).getAttributesMap();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttributes(MapValue<String, ?> attributes) {
        XMLSequence xMLSequence = this;
        synchronized (xMLSequence) {
            if (this.freezeStatus.getState() != State.UNFROZEN) {
                FreezeUtils.handleInvalidUpdate(this.freezeStatus.getState(), "lang.xml");
            }
        }
        if (this.sequence.size() == 1) {
            ((XMLItem)this.sequence.getRefValue(0L)).setAttributes(attributes);
        }
    }

    @Override
    public XMLValue<?> elements() {
        ArrayValue elementsSeq = new ArrayValue(new BArrayType(BTypes.typeXML));
        int j = 0;
        for (int i = 0; i < this.sequence.size(); ++i) {
            XMLItem item = (XMLItem)this.sequence.getRefValue(i);
            if (item.getNodeType() != XMLNodeType.ELEMENT) continue;
            elementsSeq.add((long)j++, item);
        }
        return new XMLSequence(elementsSeq);
    }

    @Override
    public XMLValue<?> elements(String qname) {
        ArrayValue elementsSeq = new ArrayValue(new BArrayType(BTypes.typeXML));
        String qnameStr = this.getQname(qname).toString();
        int j = 0;
        for (int i = 0; i < this.sequence.size(); ++i) {
            XMLItem item = (XMLItem)this.sequence.getRefValue(i);
            if (item.getNodeType() != XMLNodeType.ELEMENT || !item.getElementName().toString().equals(qnameStr)) continue;
            elementsSeq.add((long)j++, item);
        }
        return new XMLSequence(elementsSeq);
    }

    @Override
    public XMLValue<?> children() {
        ArrayValue elementsSeq = new ArrayValue(new BArrayType(BTypes.typeXML));
        int index = 0;
        for (int i = 0; i < this.sequence.size(); ++i) {
            XMLItem element = (XMLItem)this.sequence.getRefValue(i);
            if (element.getNodeType() != XMLNodeType.ELEMENT) continue;
            Iterator childrenItr = ((OMElement)element.value()).getChildren();
            while (childrenItr.hasNext()) {
                elementsSeq.add((long)index++, new XMLItem((OMNode)childrenItr.next()));
            }
        }
        return new XMLSequence(elementsSeq);
    }

    @Override
    public XMLValue<?> children(String qname) {
        ArrayValue elementsSeq = new ArrayValue(new BArrayType(BTypes.typeXML));
        QName name = this.getQname(qname);
        int index = 0;
        for (int i = 0; i < this.sequence.size(); ++i) {
            XMLItem element = (XMLItem)this.sequence.getRefValue(i);
            if (element.getNodeType() != XMLNodeType.ELEMENT) continue;
            Iterator childrenItr = ((OMElement)element.value()).getChildrenWithName(name);
            while (childrenItr.hasNext()) {
                OMNode child = (OMNode)childrenItr.next();
                elementsSeq.add((long)index++, new XMLItem(child));
            }
        }
        return new XMLSequence(elementsSeq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setChildren(XMLValue<?> seq) {
        XMLSequence xMLSequence = this;
        synchronized (xMLSequence) {
            if (this.freezeStatus.getState() != State.UNFROZEN) {
                FreezeUtils.handleInvalidUpdate(this.freezeStatus.getState(), "lang.xml");
            }
        }
        if (this.sequence.size() != 1) {
            throw BallerinaErrors.createError("not an " + (Object)((Object)XMLNodeType.ELEMENT));
        }
        ((XMLItem)this.sequence.getRefValue(0L)).setChildren(seq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildren(XMLValue<?> seq) {
        XMLSequence xMLSequence = this;
        synchronized (xMLSequence) {
            if (this.freezeStatus.getState() != State.UNFROZEN) {
                FreezeUtils.handleInvalidUpdate(this.freezeStatus.getState(), "lang.xml");
            }
        }
        if (this.sequence.size() != 1) {
            throw BallerinaErrors.createError("not an " + (Object)((Object)XMLNodeType.ELEMENT));
        }
        ((XMLItem)this.sequence.getRefValue(0L)).addChildren(seq);
    }

    @Override
    public XMLValue<?> strip() {
        ArrayValue elementsSeq = new ArrayValue(new BArrayType(BTypes.typeXML));
        int j = 0;
        for (int i = 0; i < this.sequence.size(); ++i) {
            XMLItem element = (XMLItem)this.sequence.getRefValue(i);
            if (element.value() == null || element.getNodeType() == XMLNodeType.TEXT && ((OMText)element.value()).getText().trim().isEmpty()) continue;
            elementsSeq.add((long)j++, element);
        }
        return new XMLSequence(elementsSeq);
    }

    @Override
    public XMLValue<?> slice(long startIndex, long endIndex) {
        if (startIndex > (long)this.sequence.size() || endIndex > (long)this.sequence.size() || startIndex < -1L || endIndex < -1L) {
            throw BallerinaErrors.createError("index out of range: [" + startIndex + "," + endIndex + "]");
        }
        if (startIndex == -1L) {
            startIndex = 0L;
        }
        if (endIndex == -1L) {
            endIndex = this.sequence.size();
        }
        if (startIndex == endIndex) {
            return new XMLSequence();
        }
        if (startIndex > endIndex) {
            throw BallerinaErrors.createError("invalid indices: " + startIndex + " < " + endIndex);
        }
        int j = 0;
        ArrayValue elementsSeq = new ArrayValue(new BArrayType(BTypes.typeXML));
        int i = (int)startIndex;
        while ((long)i < endIndex) {
            elementsSeq.add((long)j++, this.sequence.getRefValue(i));
            ++i;
        }
        return new XMLSequence(elementsSeq);
    }

    @Override
    public XMLValue<?> descendants(String qname) {
        ArrayList descendants = new ArrayList();
        block3: for (int i = 0; i < this.sequence.size(); ++i) {
            XMLItem element = (XMLItem)this.sequence.getRefValue(i);
            switch (element.getNodeType()) {
                case ELEMENT: {
                    this.addDescendants(descendants, (OMElement)element.value(), this.getQname(qname).toString());
                    continue block3;
                }
            }
        }
        Object[] array2 = descendants.toArray(new XMLValue[descendants.size()]);
        return new XMLSequence(new ArrayValue(array2, new BArrayType(BTypes.typeXML)));
    }

    @Override
    public void serialize(OutputStream outputStream2) {
        for (int i = 0; i < this.sequence.size(); ++i) {
            ((XMLValue)this.sequence.getRefValue(i)).serialize(outputStream2);
        }
    }

    @Override
    public ArrayValue value() {
        return this.sequence;
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.sequence.size(); ++i) {
                sb.append(this.sequence.getRefValue(i).toString());
            }
            return sb.toString();
        }
        catch (Throwable t) {
            XMLSequence.handleXmlException("failed to get xml as string: ", t);
            return BLangConstants.STRING_NULL_VALUE;
        }
    }

    @Override
    public String stringValue(Strand strand) {
        try {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.sequence.size(); ++i) {
                sb.append(((RefValue)this.sequence.getRefValue(i)).stringValue(strand));
            }
            return sb.toString();
        }
        catch (Throwable t) {
            XMLSequence.handleXmlException("failed to get xml as string: ", t);
            return BLangConstants.STRING_NULL_VALUE;
        }
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        if (this.isFrozen()) {
            return this;
        }
        if (refs.containsKey(this)) {
            return refs.get(this);
        }
        Object[] copiedVals = new Object[this.sequence.size()];
        refs.put(this, new XMLSequence(new ArrayValue(copiedVals, new BArrayType(BTypes.typeXML))));
        for (int i = 0; i < this.sequence.size(); ++i) {
            copiedVals[i] = ((XMLValue)this.sequence.getRefValue(i)).copy(refs);
        }
        return refs.get(this);
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        XMLSequence copy = (XMLSequence)this.copy(refs);
        if (!copy.isFrozen()) {
            copy.freezeDirect();
        }
        return copy;
    }

    @Override
    public XMLValue<?> getItem(int index) {
        try {
            return (XMLValue)this.sequence.getRefValue(index);
        }
        catch (Exception e) {
            throw BallerinaErrors.createError(BallerinaErrorReasons.XML_OPERATION_ERROR, e.getMessage());
        }
    }

    @Override
    public int size() {
        int size = 0;
        for (int i = 0; i < this.sequence.size; ++i) {
            Object refValue = this.sequence.getRefValue(i);
            if (refValue instanceof XMLValue) {
                XMLValue xmlItem = (XMLValue)refValue;
                size += xmlItem.size();
                continue;
            }
            ++size;
        }
        return size;
    }

    @Override
    public void build() {
        for (int i = 0; i < this.sequence.size(); ++i) {
            ((XMLValue)this.sequence.getRefValue(i)).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAttribute(String qname) {
        XMLSequence xMLSequence = this;
        synchronized (xMLSequence) {
            if (this.freezeStatus.getState() != State.UNFROZEN) {
                FreezeUtils.handleInvalidUpdate(this.freezeStatus.getState(), "lang.xml");
            }
        }
        if (this.sequence.size() != 1) {
            throw BallerinaErrors.createError("not an " + (Object)((Object)XMLNodeType.ELEMENT));
        }
        ((XMLItem)this.sequence.getRefValue(0L)).removeAttribute(qname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChildren(String qname) {
        XMLSequence xMLSequence = this;
        synchronized (xMLSequence) {
            if (this.freezeStatus.getState() != State.UNFROZEN) {
                FreezeUtils.handleInvalidUpdate(this.freezeStatus.getState(), "lang.xml");
            }
        }
        if (this.sequence.size() != 1) {
            throw BallerinaErrors.createError("not an " + (Object)((Object)XMLNodeType.ELEMENT));
        }
        ((XMLItem)this.sequence.getRefValue(0L)).removeChildren(qname);
    }

    @Override
    public synchronized void attemptFreeze(Status freezeStatus) {
        if (FreezeUtils.isOpenForFreeze(this.freezeStatus, freezeStatus)) {
            this.freezeStatus = freezeStatus;
            Arrays.stream(this.sequence.refValues).forEach(val -> ((RefValue)val).attemptFreeze(freezeStatus));
        }
    }

    @Override
    public void freezeDirect() {
        this.freezeStatus.setFrozen();
        Arrays.stream(this.sequence.refValues).forEach(val -> ((RefValue)val).freezeDirect());
    }

    @Override
    public IteratorValue getIterator() {
        return new XMLIterator.SequenceIterator(this);
    }
}

